/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon;

import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.SingleBookSubProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon.categories.BlocksCategoryProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon.categories.GenesCategoryProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon.categories.GettingStartedCategoryProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon.categories.ItemsCategoryProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.modonomicon.categories.NegativeGenesCategoryProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0004H\u0014J\b\u0010\u0011\u001a\u00020\u0004H\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/datagen/modonomicon/ModModonomiconProvider;", "Lcom/klikli_dev/modonomicon/api/datagen/SingleBookSubProvider;", "defaultLang", "Ljava/util/function/BiConsumer;", "", "lookupProvider", "Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/core/HolderLookup$Provider;", "<init>", "(Ljava/util/function/BiConsumer;Ljava/util/concurrent/CompletableFuture;)V", "registries", "additionalSetup", "Lcom/klikli_dev/modonomicon/api/datagen/book/BookModel;", "book", "generateCategories", "", "bookName", "bookTooltip", "registerDefaultMacros", "geneticsresequenced-1.21.1"})
public final class ModModonomiconProvider
extends SingleBookSubProvider {
    @NotNull
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public ModModonomiconProvider(@NotNull BiConsumer<String, String> defaultLang, @NotNull CompletableFuture<HolderLookup.Provider> lookupProvider) {
        Intrinsics.checkNotNullParameter(defaultLang, (String)"defaultLang");
        Intrinsics.checkNotNullParameter(lookupProvider, (String)"lookupProvider");
        super("guide", "geneticsresequenced", defaultLang);
        this.lookupProvider = lookupProvider;
    }

    @NotNull
    protected HolderLookup.Provider registries() {
        HolderLookup.Provider provider = this.lookupProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"get(...)");
        return provider;
    }

    @NotNull
    protected BookModel additionalSetup(@NotNull BookModel book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookModel bookModel = book.withCreativeTab(this.modLoc("creative_tab")).withDisplayMode(BookDisplayMode.INDEX).withBookTextOffsetX(3).withBookTextOffsetY(3).withBookTextOffsetWidth(-3);
        Intrinsics.checkNotNullExpressionValue((Object)bookModel, (String)"withBookTextOffsetWidth(...)");
        return bookModel;
    }

    protected void generateCategories() {
        this.add(new GettingStartedCategoryProvider((ModonomiconProviderBase)this).generate());
        this.add(new ItemsCategoryProvider((ModonomiconProviderBase)this).generate());
        this.add(new BlocksCategoryProvider((ModonomiconProviderBase)this).generate());
        this.add(new GenesCategoryProvider((ModonomiconProviderBase)this).generate());
        this.add(new NegativeGenesCategoryProvider((ModonomiconProviderBase)this).generate());
    }

    @NotNull
    protected String bookName() {
        return "Big Book of Genetics";
    }

    @NotNull
    protected String bookTooltip() {
        return "A guide to all things genetic";
    }

    protected void registerDefaultMacros() {
    }
}

