/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.datagen.custom_recipe_types;

import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.VirusRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0012\u0010\u0012\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/datagen/custom_recipe_types/VirusRecipeBuilder;", "Lnet/minecraft/data/recipes/RecipeBuilder;", "inputDnaGene", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "outputGene", "<init>", "(Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/resources/ResourceKey;)V", "getInputDnaGene", "()Lnet/minecraft/resources/ResourceKey;", "getOutputGene", "criteria", "", "", "Lnet/minecraft/advancements/Criterion;", "unlockedBy", "name", "criterion", "group", "p0", "getResult", "Lnet/minecraft/world/item/Item;", "save", "", "output", "Lnet/minecraft/data/recipes/RecipeOutput;", "defaultId", "Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nVirusRecipeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirusRecipeBuilder.kt\ndev/aaronhowser/mods/geneticsresequenced/datagen/custom_recipe_types/VirusRecipeBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,60:1\n216#2,2:61\n*S KotlinDebug\n*F\n+ 1 VirusRecipeBuilder.kt\ndev/aaronhowser/mods/geneticsresequenced/datagen/custom_recipe_types/VirusRecipeBuilder\n*L\n54#1:61,2\n*E\n"})
public final class VirusRecipeBuilder
implements RecipeBuilder {
    @NotNull
    private final ResourceKey<Gene> inputDnaGene;
    @NotNull
    private final ResourceKey<Gene> outputGene;
    @NotNull
    private final Map<String, Criterion<?>> criteria;

    public VirusRecipeBuilder(@NotNull ResourceKey<Gene> inputDnaGene, @NotNull ResourceKey<Gene> outputGene) {
        Intrinsics.checkNotNullParameter(inputDnaGene, (String)"inputDnaGene");
        Intrinsics.checkNotNullParameter(outputGene, (String)"outputGene");
        this.inputDnaGene = inputDnaGene;
        this.outputGene = outputGene;
        this.criteria = new LinkedHashMap();
    }

    @NotNull
    public final ResourceKey<Gene> getInputDnaGene() {
        return this.inputDnaGene;
    }

    @NotNull
    public final ResourceKey<Gene> getOutputGene() {
        return this.outputGene;
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(criterion, (String)"criterion");
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String p0) {
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public Item getResult() {
        Object object = ModItems.INSTANCE.getDNA_HELIX().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    public void save(@NotNull RecipeOutput output, @NotNull ResourceLocation defaultId) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)defaultId, (String)"defaultId");
        StringBuilder idString = new StringBuilder();
        idString.append("incubator/").append("virus/").append(this.inputDnaGene.location().getPath()).append("_to_").append(this.outputGene.location().getPath());
        String string = idString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ResourceLocation id = OtherUtil.INSTANCE.modResource(string);
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        Map<String, Criterion<?>> $this$forEach$iv = this.criteria;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Criterion<?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Criterion<?>> element$iv;
            Map.Entry<String, Criterion<?>> entry2 = element$iv = iterator.next();
            boolean bl = false;
            String name = entry2.getKey();
            Criterion<?> criterion = entry2.getValue();
            advancement.addCriterion(name, criterion);
        }
        VirusRecipe recipe = new VirusRecipe(this.inputDnaGene, this.outputGene);
        output.accept(id, (Recipe)recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

