/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.data.GeneRequirements;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\nH\u0002J,\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirements;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "<init>", "()V", "addGeneRequirements", "", "gene", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "requirements", "", "apply", "pObject", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "pResourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "pProfiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "Companion", "GeneRequirementsData", "geneticsresequenced-1.21.1"})
public final class GeneRequirements
extends SimpleJsonResourceReloadListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DIRECTORY = "geneticsresequenced/gene_requirements";
    @NotNull
    private static final Map<ResourceKey<Gene>, Set<ResourceKey<Gene>>> geneRequirements = new LinkedHashMap();

    public GeneRequirements() {
        super(new GsonBuilder().setPrettyPrinting().create(), DIRECTORY);
    }

    private final void addGeneRequirements(ResourceKey<Gene> gene, List<? extends ResourceKey<Gene>> requirements) {
        Map<ResourceKey<Gene>, Set<ResourceKey<Gene>>> map = geneRequirements;
        Set set = geneRequirements.get(gene);
        if (set == null || (set = SetsKt.plus(set, (Iterable)requirements)) == null) {
            set = CollectionsKt.toSet((Iterable)requirements);
        }
        Set set2 = set;
        map.put(gene, set2);
    }

    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        Intrinsics.checkNotNullParameter(pObject, (String)"pObject");
        Intrinsics.checkNotNullParameter((Object)pResourceManager, (String)"pResourceManager");
        Intrinsics.checkNotNullParameter((Object)pProfiler, (String)"pProfiler");
        geneRequirements.clear();
        for (Map.Entry<ResourceLocation, ? extends JsonElement> entry2 : pObject.entrySet()) {
            ResourceLocation key = entry2.getKey();
            JsonElement value = entry2.getValue();
            Object object = GeneRequirementsData.Companion.getCODEC().parse((DynamicOps)JsonOps.INSTANCE, (Object)value).getOrThrow(arg_0 -> GeneRequirements.apply$lambda$0(key, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(...)");
            GeneRequirementsData geneRequirements = (GeneRequirementsData)object;
            this.addGeneRequirements(geneRequirements.getGene(), geneRequirements.getRequirements());
            GeneticsResequenced.Companion.getLOGGER().info("Loaded gene requirements for " + geneRequirements.getGene());
        }
    }

    private static final IllegalArgumentException apply$lambda$0(ResourceLocation $key, String it) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return new IllegalArgumentException("Failed to decode entity genes for " + $key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\n0\fJ \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bJ \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ(\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000f0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirements$Companion;", "", "<init>", "()V", "DIRECTORY", "", "geneRequirements", "", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "", "getGeneRequirements", "", "getGeneRequiredGeneRks", "gene", "Lnet/minecraft/core/Holder;", "getGeneRequiredGeneHolders", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nGeneRequirements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneRequirements.kt\ndev/aaronhowser/mods/geneticsresequenced/data/GeneRequirements$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1557#2:92\n1628#2,3:93\n*S KotlinDebug\n*F\n+ 1 GeneRequirements.kt\ndev/aaronhowser/mods/geneticsresequenced/data/GeneRequirements$Companion\n*L\n40#1:92\n40#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<ResourceKey<Gene>, Set<ResourceKey<Gene>>> getGeneRequirements() {
            return MapsKt.toMap((Map)geneRequirements);
        }

        @NotNull
        public final Set<ResourceKey<Gene>> getGeneRequiredGeneRks(@NotNull ResourceKey<Gene> gene) {
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            Set set = (Set)geneRequirements.get(gene);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public final Set<ResourceKey<Gene>> getGeneRequiredGeneRks(@NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            ResourceKey resourceKey = gene.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            return this.getGeneRequiredGeneRks((ResourceKey<Gene>)resourceKey);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Holder<Gene>> getGeneRequiredGeneHolders(@NotNull Holder<Gene> gene, @NotNull HolderLookup.Provider registries) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            Iterable $this$map$iv = this.getGeneRequiredGeneRks(gene);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResourceKey resourceKey = (ResourceKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ModGenes.INSTANCE.getHolderOrThrow((ResourceKey<Gene>)it, registries));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0006H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirements$GeneRequirementsData;", "", "gene", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "requirements", "", "<init>", "(Lnet/minecraft/resources/ResourceKey;Ljava/util/List;)V", "getGene", "()Lnet/minecraft/resources/ResourceKey;", "getRequirements", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
    public static final class GeneRequirementsData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceKey<Gene> gene;
        @NotNull
        private final List<ResourceKey<Gene>> requirements;
        @NotNull
        private static final Codec<GeneRequirementsData> CODEC;

        public GeneRequirementsData(@NotNull ResourceKey<Gene> gene, @NotNull List<? extends ResourceKey<Gene>> requirements) {
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
            this.gene = gene;
            this.requirements = requirements;
        }

        @NotNull
        public final ResourceKey<Gene> getGene() {
            return this.gene;
        }

        @NotNull
        public final List<ResourceKey<Gene>> getRequirements() {
            return this.requirements;
        }

        @NotNull
        public final ResourceKey<Gene> component1() {
            return this.gene;
        }

        @NotNull
        public final List<ResourceKey<Gene>> component2() {
            return this.requirements;
        }

        @NotNull
        public final GeneRequirementsData copy(@NotNull ResourceKey<Gene> gene, @NotNull List<? extends ResourceKey<Gene>> requirements) {
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
            return new GeneRequirementsData(gene, requirements);
        }

        public static /* synthetic */ GeneRequirementsData copy$default(GeneRequirementsData geneRequirementsData, ResourceKey resourceKey, List list, int n, Object object) {
            if ((n & 1) != 0) {
                resourceKey = geneRequirementsData.gene;
            }
            if ((n & 2) != 0) {
                list = geneRequirementsData.requirements;
            }
            return geneRequirementsData.copy(resourceKey, list);
        }

        @NotNull
        public String toString() {
            return "GeneRequirementsData(gene=" + this.gene + ", requirements=" + this.requirements + ")";
        }

        public int hashCode() {
            int result = this.gene.hashCode();
            result = result * 31 + ((Object)this.requirements).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneRequirementsData)) {
                return false;
            }
            GeneRequirementsData geneRequirementsData = (GeneRequirementsData)other;
            if (!Intrinsics.areEqual(this.gene, geneRequirementsData.gene)) {
                return false;
            }
            return Intrinsics.areEqual(this.requirements, geneRequirementsData.requirements);
        }

        private static final ResourceKey CODEC$lambda$2$lambda$0(KProperty1 $tmp0, GeneRequirementsData p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final List CODEC$lambda$2$lambda$1(KProperty1 $tmp0, GeneRequirementsData p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (List)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
            return instance.group((App)ResourceKey.codec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()).fieldOf("gene").forGetter(arg_0 -> GeneRequirementsData.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)ResourceKey.codec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()).listOf().fieldOf("requirements").forGetter(arg_0 -> GeneRequirementsData.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, GeneRequirementsData::new);
        }

        static {
            Codec codec = RecordCodecBuilder.create(GeneRequirementsData::CODEC$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirements$GeneRequirementsData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/data/GeneRequirements$GeneRequirementsData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<GeneRequirementsData> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

