/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.data.EntityGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0004\u0012\u00020\f0\nH\u0002J,\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/EntityGenes;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "<init>", "()V", "addGeneWeights", "", "entityRk", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/entity/EntityType;", "newGeneWeights", "", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "", "apply", "pObject", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "pResourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "pProfiler", "Lnet/minecraft/util/profiling/ProfilerFiller;", "Companion", "EntityGenesData", "geneticsresequenced-1.21.1"})
public final class EntityGenes
extends SimpleJsonResourceReloadListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DIRECTORY = "geneticsresequenced/entity_genes";
    @NotNull
    private static final Map<EntityType<?>, Map<ResourceKey<Gene>, Integer>> entityGeneMap = new LinkedHashMap();

    public EntityGenes() {
        super(new GsonBuilder().setPrettyPrinting().create(), DIRECTORY);
    }

    private final void addGeneWeights(ResourceKey<EntityType<?>> entityRk, Map<ResourceKey<Gene>, Integer> newGeneWeights) {
        Object object = BuiltInRegistries.ENTITY_TYPE.get(entityRk);
        Intrinsics.checkNotNull((Object)object);
        EntityType entityType = (EntityType)object;
        Map map = entityGeneMap.get(entityType);
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map currentGenes = map;
        for (Map.Entry<ResourceKey<Gene>, Integer> entry2 : newGeneWeights.entrySet()) {
            ResourceKey<Gene> gene = entry2.getKey();
            int weight = ((Number)entry2.getValue()).intValue();
            Map map2 = currentGenes;
            Integer n = (Integer)currentGenes.get(gene);
            Integer n2 = n != null ? n + weight : weight;
            map2.put(gene, n2);
        }
        entityGeneMap.put(entityType, currentGenes);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        Intrinsics.checkNotNullParameter(pObject, (String)"pObject");
        Intrinsics.checkNotNullParameter((Object)pResourceManager, (String)"pResourceManager");
        Intrinsics.checkNotNullParameter((Object)pProfiler, (String)"pProfiler");
        entityGeneMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : pObject.entrySet()) {
            ResourceLocation key = entry2.getKey();
            JsonElement value = entry2.getValue();
            try {
                Object object = ((com.mojang.datafixers.util.Pair)EntityGenesData.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)value).getOrThrow(arg_0 -> EntityGenes.apply$lambda$0(key, arg_0))).getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
                EntityGenesData entityGenesData = (EntityGenesData)object;
                String entityName = entityGenesData.getEntity().location().getPath();
                String string = key.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String[] stringArray = new String[]{":"};
                String fileName = (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                if (!Intrinsics.areEqual((Object)entityName, (Object)fileName)) {
                    GeneticsResequenced.Companion.getLOGGER().warn("Gene-mob data for " + key + " has the entity " + entityName + " instead of " + fileName + ". This may be a mistake.");
                }
                this.addGeneWeights(entityGenesData.getEntity(), entityGenesData.getGeneWeights());
                GeneticsResequenced.Companion.getLOGGER().debug("Loaded gene-mob data for " + entityGenesData.getEntity().location() + ", with " + entityGenesData.getGeneWeights().size() + " genes");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final IllegalArgumentException apply$lambda$0(ResourceLocation $key, String it) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return new IllegalArgumentException("Failed to decode entity genes for " + $key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\r\u001a$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t0\tJ0\u0010\u000e\u001a$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u0004\u0012\u00020\f0\t0\t2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\bJ,\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\u0004\u0012\u00020\f0\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R0\u0010\u0006\u001a$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/EntityGenes$Companion;", "", "<init>", "()V", "DIRECTORY", "", "entityGeneMap", "", "Lnet/minecraft/world/entity/EntityType;", "", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "", "getEntityGeneRkMap", "getEntityGeneHolderMap", "Lnet/minecraft/core/Holder;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getGeneRkWeights", "entityType", "getGeneHolderWeights", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nEntityGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/data/EntityGenes$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n126#2:126\n153#2,3:127\n126#2:130\n153#2,3:131\n*S KotlinDebug\n*F\n+ 1 EntityGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/data/EntityGenes$Companion\n*L\n35#1:126\n35#1:127,3\n47#1:130\n47#1:131,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<EntityType<?>, Map<ResourceKey<Gene>, Integer>> getEntityGeneRkMap() {
            return MapsKt.toMap((Map)entityGeneMap);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<EntityType<?>, Map<Holder<Gene>, Integer>> getEntityGeneHolderMap(@NotNull HolderLookup.Provider registries) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            Map $this$map$iv = entityGeneMap;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                EntityType entityType = (EntityType)entry2.getKey();
                Map geneRkMap = (Map)entry2.getValue();
                Map<Holder<Gene>, Integer> holders = Companion.getGeneHolderWeights(entityType, registries);
                collection.add(TuplesKt.to((Object)entityType, holders));
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public final Map<ResourceKey<Gene>, Integer> getGeneRkWeights(@NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            Map map = (Map)entityGeneMap.get(entityType);
            if (map == null) {
                map = MapsKt.mapOf((Pair)TuplesKt.to(ModGenes.INSTANCE.getBASIC(), (Object)1));
            }
            return map;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Holder<Gene>, Integer> getGeneHolderWeights(@NotNull EntityType<?> entityType, @NotNull HolderLookup.Provider registries) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            Map<ResourceKey<Gene>, Integer> $this$map$iv = this.getGeneRkWeights(entityType);
            boolean $i$f$map = false;
            Map<ResourceKey<Gene>, Integer> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ResourceKey rk = (ResourceKey)entry2.getKey();
                int weight = ((Number)entry2.getValue()).intValue();
                collection.add(TuplesKt.to(ModGenes.INSTANCE.getHolderOrThrow((ResourceKey<Gene>)rk, registries), (Object)weight));
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B3\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u00c6\u0003J\u001b\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003J9\u0010\u0011\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/EntityGenes$EntityGenesData;", "", "entity", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/entity/EntityType;", "geneWeights", "", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "", "<init>", "(Lnet/minecraft/resources/ResourceKey;Ljava/util/Map;)V", "getEntity", "()Lnet/minecraft/resources/ResourceKey;", "getGeneWeights", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
    public static final class EntityGenesData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceKey<EntityType<?>> entity;
        @NotNull
        private final Map<ResourceKey<Gene>, Integer> geneWeights;
        @NotNull
        private static final Codec<EntityGenesData> CODEC;

        public EntityGenesData(@NotNull ResourceKey<EntityType<?>> entity, @NotNull Map<ResourceKey<Gene>, Integer> geneWeights) {
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            Intrinsics.checkNotNullParameter(geneWeights, (String)"geneWeights");
            this.entity = entity;
            this.geneWeights = geneWeights;
        }

        @NotNull
        public final ResourceKey<EntityType<?>> getEntity() {
            return this.entity;
        }

        @NotNull
        public final Map<ResourceKey<Gene>, Integer> getGeneWeights() {
            return this.geneWeights;
        }

        @NotNull
        public final ResourceKey<EntityType<?>> component1() {
            return this.entity;
        }

        @NotNull
        public final Map<ResourceKey<Gene>, Integer> component2() {
            return this.geneWeights;
        }

        @NotNull
        public final EntityGenesData copy(@NotNull ResourceKey<EntityType<?>> entity, @NotNull Map<ResourceKey<Gene>, Integer> geneWeights) {
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            Intrinsics.checkNotNullParameter(geneWeights, (String)"geneWeights");
            return new EntityGenesData(entity, geneWeights);
        }

        public static /* synthetic */ EntityGenesData copy$default(EntityGenesData entityGenesData, ResourceKey resourceKey, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                resourceKey = entityGenesData.entity;
            }
            if ((n & 2) != 0) {
                map = entityGenesData.geneWeights;
            }
            return entityGenesData.copy(resourceKey, map);
        }

        @NotNull
        public String toString() {
            return "EntityGenesData(entity=" + this.entity + ", geneWeights=" + this.geneWeights + ")";
        }

        public int hashCode() {
            int result = this.entity.hashCode();
            result = result * 31 + ((Object)this.geneWeights).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityGenesData)) {
                return false;
            }
            EntityGenesData entityGenesData = (EntityGenesData)other;
            if (!Intrinsics.areEqual(this.entity, entityGenesData.entity)) {
                return false;
            }
            return Intrinsics.areEqual(this.geneWeights, entityGenesData.geneWeights);
        }

        private static final ResourceKey CODEC$lambda$2$lambda$0(KProperty1 $tmp0, EntityGenesData p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Map CODEC$lambda$2$lambda$1(KProperty1 $tmp0, EntityGenesData p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Map)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
            return instance.group((App)ResourceKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity").forGetter(arg_0 -> EntityGenesData.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.unboundedMap((Codec)ResourceKey.codec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()), (Codec)((Codec)Codec.INT)).fieldOf("gene_weights").forGetter(arg_0 -> EntityGenesData.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, EntityGenesData::new);
        }

        static {
            Codec codec = RecordCodecBuilder.create(EntityGenesData::CODEC$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/data/EntityGenes$EntityGenesData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/data/EntityGenes$EntityGenesData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<EntityGenesData> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

