/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe.machine;

import dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.GmoCell;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/CellToHelixEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "cellStack", "Lnet/minecraft/world/item/ItemStack;", "helixStack", "<init>", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V", "getCellStack", "()Lnet/minecraft/world/item/ItemStack;", "getHelixStack", "cell", "Ldev/emi/emi/api/stack/EmiIngredient;", "helix", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "Companion", "geneticsresequenced-1.21.1"})
public final class CellToHelixEmiRecipe
implements EmiRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStack cellStack;
    @NotNull
    private final ItemStack helixStack;
    @NotNull
    private final EmiIngredient cell;
    @NotNull
    private final EmiStack helix;

    public CellToHelixEmiRecipe(@NotNull ItemStack cellStack, @NotNull ItemStack helixStack) {
        Intrinsics.checkNotNullParameter((Object)cellStack, (String)"cellStack");
        Intrinsics.checkNotNullParameter((Object)helixStack, (String)"helixStack");
        this.cellStack = cellStack;
        this.helixStack = helixStack;
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)DataComponentIngredient.of((boolean)false, (ItemStack)this.cellStack));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.cell = emiIngredient;
        EmiStack emiStack = EmiStack.of((ItemStack)this.helixStack);
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        this.helix = emiStack;
    }

    @NotNull
    public final ItemStack getCellStack() {
        return this.cellStack;
    }

    @NotNull
    public final ItemStack getHelixStack() {
        return this.helixStack;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getDNA_EXTRACTOR_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        Object string = "cell_to_helix/";
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(this.cellStack);
        if (entityType == null) {
            throw new IllegalStateException("Invalid entity type".toString());
        }
        EntityType<?> entityType2 = entityType;
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(entityType2);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
        ResourceLocation entityTypeRl = resourceLocation;
        String string2 = entityTypeRl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String entityString = StringsKt.replace$default((String)string2, (char)':', (char)'/', (boolean)false, (int)4, null);
        string = (String)string + entityString;
        if (Intrinsics.areEqual((Object)this.cellStack.getItem(), (Object)ModItems.INSTANCE.getGMO_CELL().get())) {
            string = (String)string + "/gmo/";
            Holder<Gene> holder = DnaHelixItem.Companion.getGeneHolder(this.helixStack);
            if (holder == null) {
                throw new IllegalStateException("Invalid gene".toString());
            }
            Holder<Gene> geneHolder = holder;
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            String string3 = resourceKey.location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String geneString = StringsKt.replace$default((String)string3, (char)':', (char)'/', (boolean)false, (int)4, null);
            string = (String)string + geneString;
        }
        return OtherUtil.INSTANCE.modResource((String)string);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        return CollectionsKt.listOf((Object)this.cell);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.helix);
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 26, 1);
        widgets.addSlot(this.cell, 0, 0);
        widgets.addSlot((EmiIngredient)this.helix, 58, 0).recipeContext((EmiRecipe)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/CellToHelixEmiRecipe$Companion;", "", "<init>", "()V", "getAllRecipes", "", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/CellToHelixEmiRecipe;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nCellToHelixEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CellToHelixEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/CellToHelixEmiRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1755#2,3:136\n1663#2,8:139\n*S KotlinDebug\n*F\n+ 1 CellToHelixEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/machine/CellToHelixEmiRecipe$Companion\n*L\n62#1:136,3\n81#1:139,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<CellToHelixEmiRecipe> getAllRecipes(@NotNull RecipeManager recipeManager) {
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List recipes = new ArrayList();
            Set<EntityType<?>> validEntityTypes = EntityDnaItem.Companion.getValidEntityTypes();
            for (EntityType<?> entityType : validEntityTypes) {
                ItemStack itemStack = ModItems.INSTANCE.getCELL().toStack();
                Intrinsics.checkNotNull((Object)itemStack);
                EntityDnaItem.Companion.setEntityType(itemStack, entityType);
                ItemStack helixStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
                Intrinsics.checkNotNull((Object)helixStack);
                EntityDnaItem.Companion.setEntityType(helixStack, entityType);
                recipes.add(new CellToHelixEmiRecipe(itemStack, helixStack));
            }
            List<RecipeHolder<GmoRecipe>> allGmoRecipes = GmoRecipe.Companion.getGmoRecipes(recipeManager);
            for (RecipeHolder<GmoRecipe> recipeHolder : allGmoRecipes) {
                boolean recipeAlreadyExists;
                boolean bl;
                EntityType<?> entityType;
                block6: {
                    entityType = ((GmoRecipe)recipeHolder.value()).getEntityType();
                    ResourceKey<Gene> goodGeneRk = ((GmoRecipe)recipeHolder.value()).getIdealGeneRk();
                    ItemStack goodGmoStack = ModItems.INSTANCE.getGMO_CELL().toStack();
                    Intrinsics.checkNotNull((Object)goodGmoStack);
                    RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
                    Intrinsics.checkNotNull((Object)registryAccess);
                    GmoCell.Companion.setDetails(goodGmoStack, entityType, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(goodGeneRk, (HolderLookup.Provider)registryAccess)));
                    RegistryAccess registryAccess2 = ClientUtil.INSTANCE.getLocalRegistryAccess();
                    Intrinsics.checkNotNull((Object)registryAccess2);
                    ItemStack goodHelix = DnaHelixItem.Companion.getHelixStack(goodGeneRk, (HolderLookup.Provider)registryAccess2);
                    recipes.add(new CellToHelixEmiRecipe(goodGmoStack, goodHelix));
                    Iterable $this$any$iv = recipes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CellToHelixEmiRecipe it = (CellToHelixEmiRecipe)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual(EntityDnaItem.Companion.getEntityType(it.getCellStack()), entityType) && Gene.Companion.isGene(DnaHelixItem.Companion.getGeneHolder(it.getHelixStack()), ModGenes.INSTANCE.getBASIC()))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (recipeAlreadyExists = bl) continue;
                ItemStack badGmoStack = ModItems.INSTANCE.getGMO_CELL().toStack();
                Intrinsics.checkNotNull((Object)badGmoStack);
                ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getBASIC();
                RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
                Intrinsics.checkNotNull((Object)registryAccess);
                GmoCell.Companion.setDetails(badGmoStack, entityType, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess)));
                ResourceKey<Gene> resourceKey2 = ModGenes.INSTANCE.getBASIC();
                RegistryAccess registryAccess3 = ClientUtil.INSTANCE.getLocalRegistryAccess();
                Intrinsics.checkNotNull((Object)registryAccess3);
                ItemStack badHelix = DnaHelixItem.Companion.getHelixStack(resourceKey2, (HolderLookup.Provider)registryAccess3);
                recipes.add(new CellToHelixEmiRecipe(badGmoStack, badHelix));
            }
            Iterable iterable = recipes;
            boolean bl = false;
            HashSet<ResourceLocation> set$iv = new HashSet<ResourceLocation>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : iterable) {
                CellToHelixEmiRecipe it = (CellToHelixEmiRecipe)e$iv;
                boolean bl2 = false;
                ResourceLocation key$iv = it.getId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            return list$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

