/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.emi.recipe;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.data.EntityGenes;
import dev.aaronhowser.mods.geneticsresequenced.data.GeneRequirements;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/emi/recipe/ModInformationRecipes;", "", "<init>", "()V", "getInformationRecipes", "", "Ldev/emi/emi/api/recipe/EmiInfoRecipe;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "geneDescriptions", "organicMatter", "mobGenes", "geneticsresequenced-1.21.1"})
public final class ModInformationRecipes {
    @NotNull
    public static final ModInformationRecipes INSTANCE = new ModInformationRecipes();

    private ModInformationRecipes() {
    }

    @NotNull
    public final List<EmiInfoRecipe> getInformationRecipes(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.organicMatter(), (Iterable)this.geneDescriptions(registries)), (Iterable)this.mobGenes(registries));
    }

    private final List<EmiInfoRecipe> geneDescriptions(HolderLookup.Provider registries) {
        List recipes = new ArrayList();
        for (Holder geneHolder : ModGenes.getRegistrySorted$default(ModGenes.INSTANCE, registries, true, false, 4, null)) {
            if (Gene.Companion.isDisabled((Holder<Gene>)geneHolder)) continue;
            List components = new ArrayList();
            MutableComponent mutableComponent = Gene.Companion.getNameComponent((Holder<Gene>)geneHolder).withStyle(ModInformationRecipes::geneDescriptions$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            components.add(mutableComponent);
            String translationKey = "info." + Gene.Companion.getTranslationKey((Holder<Gene>)geneHolder);
            MutableComponent geneDesc = Component.translatable((String)translationKey);
            if (Intrinsics.areEqual((Object)geneDesc.toString(), (Object)translationKey)) {
                GeneticsResequenced.Companion.getLOGGER().error("Gene is missing information translation key: " + translationKey);
            }
            Intrinsics.checkNotNull((Object)geneDesc);
            components.add(geneDesc);
            Set<Holder<Gene>> requiredGeneHolders = GeneRequirements.Companion.getGeneRequiredGeneHolders((Holder<Gene>)geneHolder, registries);
            if (!((Collection)requiredGeneHolders).isEmpty()) {
                MutableComponent mutableComponent2 = Component.literal((String)"\n");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
                components.add(mutableComponent2);
                components.add(ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.requires_genes", new Object[0]));
                for (Holder<Gene> requiredGeneHolder : requiredGeneHolders) {
                    MutableComponent requiredGeneComponent = Gene.Companion.isNegative(requiredGeneHolder) || Gene.Companion.isMutation(requiredGeneHolder) ? Gene.Companion.getNameComponent(requiredGeneHolder) : Gene.Companion.getNameComponent(requiredGeneHolder).withStyle(ModInformationRecipes::geneDescriptions$lambda$1);
                    MutableComponent line = Component.literal((String)"\u2022 ").append((Component)requiredGeneComponent);
                    Intrinsics.checkNotNull((Object)line);
                    components.add(line);
                }
            }
            ItemStack helix = DnaHelixItem.Companion.getHelixStack((Holder<Gene>)geneHolder);
            ItemStack[] itemStackArray = new ItemStack[]{helix};
            List list = CollectionsKt.listOf((Object)EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray)));
            List list2 = CollectionsKt.toList((Iterable)components);
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            String string = resourceKey.location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            EmiInfoRecipe recipe = new EmiInfoRecipe(list, list2, OtherUtil.INSTANCE.modResource("/info/gene/" + StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null)));
            recipes.add(recipe);
        }
        return recipes;
    }

    private final List<EmiInfoRecipe> organicMatter() {
        ItemStack[] itemStackArray = new ItemStack[]{ModItems.INSTANCE.getORGANIC_MATTER().toStack()};
        EmiInfoRecipe noEntityRecipe = new EmiInfoRecipe(CollectionsKt.listOf((Object)EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray))), CollectionsKt.listOf((Object)ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.organic_matter.empty", new Object[0])), OtherUtil.INSTANCE.modResource("/info/organic_matter/no_entity"));
        EmiInfoRecipe[] emiInfoRecipeArray = new EmiInfoRecipe[]{noEntityRecipe};
        List recipes = CollectionsKt.mutableListOf((Object[])emiInfoRecipeArray);
        for (EntityType entityType : EntityDnaItem.Companion.getValidEntityTypes()) {
            Object[] objectArray = new Object[]{entityType.getDescription()};
            MutableComponent component = ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.organic_matter", objectArray);
            ItemStack organicMatterStack = ModItems.INSTANCE.getORGANIC_MATTER().toStack();
            Intrinsics.checkNotNull((Object)organicMatterStack);
            EntityDnaItem.Companion.setEntityType(organicMatterStack, entityType);
            String string = EntityType.getKey((EntityType)entityType).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String entityString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
            ItemStack[] itemStackArray2 = new ItemStack[]{organicMatterStack};
            EmiInfoRecipe recipe = new EmiInfoRecipe(CollectionsKt.listOf((Object)EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray2))), CollectionsKt.listOf((Object)component), OtherUtil.INSTANCE.modResource("/info/organic_matter/" + entityString));
            recipes.add(recipe);
        }
        return recipes;
    }

    private final List<EmiInfoRecipe> mobGenes(HolderLookup.Provider registries) {
        List recipes = new ArrayList();
        for (EntityType<?> entityType : EntityDnaItem.Companion.getValidEntityTypes()) {
            List chance2;
            Object[] objectArray;
            Map<Holder<Gene>, Integer> geneWeights = EntityGenes.Companion.getGeneHolderWeights(entityType, registries);
            Object[] objectArray2 = new Object[]{entityType.getDescription()};
            MutableComponent informationTextComponent = ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.mob_gene.line1", objectArray2);
            int sumOfWeights = CollectionsKt.sumOfInt((Iterable)geneWeights.values());
            for (Map.Entry<Holder<Gene>, Integer> entry2 : geneWeights.entrySet()) {
                Holder<Gene> geneHolder = entry2.getKey();
                int weight = ((Number)entry2.getValue()).intValue();
                int chance2 = (int)((double)weight / (double)sumOfWeights * (double)100);
                MutableComponent geneComponent = Gene.Companion.isNegative(geneHolder) || Gene.Companion.isMutation(geneHolder) ? Gene.Companion.getNameComponent(geneHolder) : Gene.Companion.getNameComponent(geneHolder).withStyle(ModInformationRecipes::mobGenes$lambda$2);
                objectArray = new Object[]{chance2, geneComponent};
                MutableComponent component = ModLanguageProvider.Companion.toComponent("info.geneticsresequenced.mob_gene.line2", objectArray);
                informationTextComponent.append((Component)component);
            }
            ItemStack organicMatterStack = EntityDnaItem.Companion.getOrganicStack(entityType);
            ItemStack cellStack = EntityDnaItem.Companion.getCell(entityType);
            SpawnEggItem mobSpawnEgg = SpawnEggItem.byId(entityType);
            List $this$mobGenes_u24lambda_u243 = chance2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            objectArray = new EmiIngredient[2];
            ItemStack[] itemStackArray = new ItemStack[]{organicMatterStack};
            objectArray[0] = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
            itemStackArray = new ItemStack[]{cellStack};
            objectArray[1] = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
            $this$mobGenes_u24lambda_u243.add(EmiIngredient.of((List)CollectionsKt.listOf((Object[])objectArray)));
            if (mobSpawnEgg != null) {
                objectArray = new ItemStack[]{mobSpawnEgg.getDefaultInstance()};
                $this$mobGenes_u24lambda_u243.add(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])objectArray)));
            }
            List list = CollectionsKt.build((List)chance2);
            String string = EntityType.getKey(entityType).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String entityString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
            EmiInfoRecipe recipe = new EmiInfoRecipe(list, CollectionsKt.listOf((Object)informationTextComponent), OtherUtil.INSTANCE.modResource("/info/mob_genes/" + entityString));
            recipes.add(recipe);
        }
        return recipes;
    }

    private static final Style geneDescriptions$lambda$0(Style it) {
        return it.withColor(ChatFormatting.RESET).withUnderlined(Boolean.valueOf(true));
    }

    private static final Style geneDescriptions$lambda$1(Style it) {
        return it.withColor(ChatFormatting.RESET);
    }

    private static final Style mobGenes$lambda$2(Style it) {
        return it.withColor(ChatFormatting.RESET);
    }
}

