/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.plasmid_infuser;

import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.plasmid_infuser.PlasmidInfuserBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.plasmid_infuser.PlasmidInfuserMenu;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntities;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0014J\b\u0010'\u001a\u00020(H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/plasmid_infuser/PlasmidInfuserBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "machineName", "", "getMachineName", "()Ljava/lang/String;", "energyMaximum", "", "getEnergyMaximum", "()I", "energyTransferMaximum", "getEnergyTransferMaximum", "baseEnergyCostPerTick", "getBaseEnergyCostPerTick", "amountOfItemSlots", "getAmountOfItemSlots", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "tick", "", "craftItem", "hasRecipe", "", "Companion", "geneticsresequenced-1.21.1"})
public final class PlasmidInfuserBlockEntity
extends CraftingMachineBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String machineName;
    private final int energyMaximum;
    private final int energyTransferMaximum;
    private final int baseEnergyCostPerTick;
    private final int amountOfItemSlots;
    @NotNull
    private final ItemStackHandler itemHandler;

    public PlasmidInfuserBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        Object object = ModBlockEntities.INSTANCE.getPLASMID_INFUSER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pPos, pBlockState);
        this.machineName = "plasmid_infuser";
        this.energyMaximum = 60000;
        this.energyTransferMaximum = 256;
        this.baseEnergyCostPerTick = 32;
        this.amountOfItemSlots = 3;
        int n = this.getAmountOfItemSlots();
        this.itemHandler = new ItemStackHandler(this, n){
            final /* synthetic */ PlasmidInfuserBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void onContentsChanged(int slot) {
                this.this$0.setChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> stack.is((Item)ModItems.INSTANCE.getDNA_HELIX().get());
                    case 2 -> stack.is((Item)ModItems.INSTANCE.getOVERCLOCKER().get());
                    case 1 -> stack.is((Item)ModItems.INSTANCE.getPLASMID().get());
                    default -> false;
                };
            }
        };
    }

    @Override
    @NotNull
    public String getMachineName() {
        return this.machineName;
    }

    @Override
    public int getEnergyMaximum() {
        return this.energyMaximum;
    }

    @Override
    public int getEnergyTransferMaximum() {
        return this.energyTransferMaximum;
    }

    @Override
    public int getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getAmountOfItemSlots() {
        return this.amountOfItemSlots;
    }

    @Override
    @NotNull
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return new PlasmidInfuserMenu(pContainerId, pPlayerInventory, this, this.getContainerData());
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = ((PlasmidInfuserBlock)((Object)ModBlocks.INSTANCE.getPLASMID_INFUSER().get())).getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    @Override
    public void tick() {
        if (this.hasRecipe() && this.hasEnoughEnergy()) {
            this.extractEnergy();
            this.setProgress(this.getProgress() + (1 + this.getAmountOfOverclockers()));
            this.setChanged();
            if (this.getProgress() >= this.getMaxProgress()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            this.setChanged();
        }
    }

    @Override
    protected void craftItem() {
        int n;
        if (!this.hasRecipe()) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        ItemStack inputHelix = this.getItemHandler().getStackInSlot(0);
        ItemStack outputPlasmid = this.getItemHandler().getStackInSlot(1);
        Intrinsics.checkNotNull((Object)outputPlasmid);
        Holder<Gene> plasmidGeneHolder = PlasmidItem.Companion.getGene(outputPlasmid);
        Intrinsics.checkNotNull((Object)inputHelix);
        Holder<Gene> inputGeneHolder = DnaHelixItem.Companion.getGeneHolder(inputHelix);
        if (plasmidGeneHolder == null) {
            if (inputGeneHolder == null) {
                return;
            }
            PlasmidItem.Companion.setGene(outputPlasmid, inputGeneHolder, 0);
            this.getItemHandler().extractItem(0, 1, false);
            return;
        }
        if (inputGeneHolder == null) {
            return;
        }
        if (Gene.Companion.isGene(inputGeneHolder, ModGenes.INSTANCE.getBASIC())) {
            n = 1;
        } else if (Gene.Companion.isGene(inputGeneHolder, plasmidGeneHolder)) {
            n = 2;
        } else {
            return;
        }
        int inputAmount = n;
        PlasmidItem.Companion.increaseDnaPoints(outputPlasmid, inputAmount);
        this.getItemHandler().extractItem(0, 1, false);
    }

    @Override
    protected boolean hasRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.getItemHandler().getSlots());
        int n = this.getItemHandler().getSlots();
        for (int i = 0; i < n; ++i) {
            inventory.setItem(i, this.getItemHandler().getStackInSlot(i));
        }
        ItemStack inputHelix = inventory.getItem(0);
        ItemStack outputPlasmid = inventory.getItem(1);
        if (!inputHelix.is((Item)ModItems.INSTANCE.getDNA_HELIX().get()) || !outputPlasmid.is((Item)ModItems.INSTANCE.getPLASMID().get())) {
            return false;
        }
        Intrinsics.checkNotNull((Object)outputPlasmid);
        if (PlasmidItem.Companion.isComplete(outputPlasmid)) {
            return false;
        }
        Holder<Gene> plasmidGeneHolder = PlasmidItem.Companion.getGene(outputPlasmid);
        Intrinsics.checkNotNull((Object)inputHelix);
        Holder<Gene> inputGeneHolder = DnaHelixItem.Companion.getGeneHolder(inputHelix);
        boolean helixIsBasic = Gene.Companion.isGene(inputGeneHolder, ModGenes.INSTANCE.getBASIC());
        if (plasmidGeneHolder == null) {
            return !helixIsBasic && inputGeneHolder != null;
        }
        return helixIsBasic || Intrinsics.areEqual(inputGeneHolder, plasmidGeneHolder);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/plasmid_infuser/PlasmidInfuserBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/plasmid_infuser/PlasmidInfuserBlockEntity;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull PlasmidInfuserBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

