/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator_advanced;

import dev.aaronhowser.mods.geneticsresequenced.block.base.InventoryEnergyBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.menu.MachineMenu;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator.IncubatorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator_advanced.AdvancedIncubatorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModMenuTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00038B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorMenu;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/menu/MachineMenu;", "id", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity;", "containerData", "Lnet/minecraft/world/inventory/ContainerData;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity;Lnet/minecraft/world/inventory/ContainerData;)V", "extraData", "Lnet/minecraft/network/FriendlyByteBuf;", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "stillValid", "", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "value", "ticksRemaining", "getTicksRemaining", "()I", "setTicksRemaining", "(I)V", "isHighTemperature", "()Z", "setHighTemperature", "(Z)V", "isCrafting", "getPercentDone", "", "clickMenuButton", "pId", "toggleTemperature", "", "Companion", "geneticsresequenced-1.21.1"})
public final class AdvancedIncubatorMenu
extends MachineMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContainerData containerData;

    public AdvancedIncubatorMenu(int id, @NotNull Inventory inventory, @NotNull AdvancedIncubatorBlockEntity blockEntity, @NotNull ContainerData containerData2) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)containerData2, (String)"containerData");
        Object object = ModMenuTypes.INSTANCE.getADVANCED_INCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((MenuType)object, blockEntity, id, inventory);
        this.containerData = containerData2;
        AbstractContainerMenu.checkContainerSize((Container)((Container)inventory), (int)2);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        ItemStackHandler itemHandler2 = this.getBlockEntity().getItemHandler();
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler2, 0, 83, 21));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler2, 1, 60, 55));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler2, 2, 83, 62));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler2, 3, 106, 55));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler2, 4, 141, 38));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler2, 5, 141, 60));
        this.addDataSlots(this.containerData);
    }

    public AdvancedIncubatorMenu(int id, @NotNull Inventory inventory, @NotNull FriendlyByteBuf extraData) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        BlockEntity blockEntity = inventory.player.level().getBlockEntity(extraData.readBlockPos());
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator_advanced.AdvancedIncubatorBlockEntity");
        this(id, inventory, (AdvancedIncubatorBlockEntity)blockEntity, (ContainerData)new SimpleContainerData(2));
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockEntity().getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocks.INSTANCE.getADVANCED_INCUBATOR().get()));
    }

    private final int getTicksRemaining() {
        return this.containerData.get(0);
    }

    private final void setTicksRemaining(int value) {
        this.containerData.set(0, value);
    }

    public final boolean isHighTemperature() {
        return this.containerData.get(1) == 1;
    }

    private final void setHighTemperature(boolean value) {
        this.containerData.set(1, value ? 1 : 0);
    }

    public final boolean isCrafting() {
        return this.getTicksRemaining() > 0;
    }

    @Override
    public float getPercentDone() {
        if (this.getTicksRemaining() <= 0) {
            return 0.0f;
        }
        int maxProgress = IncubatorBlockEntity.Companion.getTicksPerBrew();
        int progress = maxProgress - this.getTicksRemaining();
        return maxProgress != 0 ? (float)progress / (float)maxProgress : 0.0f;
    }

    public boolean clickMenuButton(@NotNull Player pPlayer, int pId) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        if (pPlayer instanceof ServerPlayer && pId == 1) {
            this.toggleTemperature();
            return true;
        }
        return false;
    }

    private final void toggleTemperature() {
        this.setHighTemperature(!this.isHighTemperature());
        InventoryEnergyBlockEntity inventoryEnergyBlockEntity = this.getBlockEntity();
        Intrinsics.checkNotNull((Object)((Object)inventoryEnergyBlockEntity), (String)"null cannot be cast to non-null type dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator_advanced.AdvancedIncubatorBlockEntity");
        ((AdvancedIncubatorBlockEntity)inventoryEnergyBlockEntity).resetBrewTime();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorMenu$Companion;", "", "<init>", "()V", "showChanceTooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void showChanceTooltip(@NotNull ItemTooltipEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ItemStack potionStack = event.getItemStack();
            Intrinsics.checkNotNull((Object)potionStack);
            Holder<Potion> holder = OtherUtil.INSTANCE.getPotion(potionStack);
            if (holder == null) {
                return;
            }
            Holder<Potion> potion = holder;
            if (!Intrinsics.areEqual(potion, ModPotions.INSTANCE.getCELL_GROWTH()) && !Intrinsics.areEqual(potion, ModPotions.INSTANCE.getMUTATION())) {
                return;
            }
            Player player = event.getEntity();
            if (player == null) {
                return;
            }
            Player player2 = player;
            AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
            AdvancedIncubatorMenu advancedIncubatorMenu = abstractContainerMenu instanceof AdvancedIncubatorMenu ? (AdvancedIncubatorMenu)abstractContainerMenu : null;
            if (advancedIncubatorMenu == null) {
                return;
            }
            AdvancedIncubatorMenu menu = advancedIncubatorMenu;
            InventoryEnergyBlockEntity inventoryEnergyBlockEntity = menu.getBlockEntity();
            AdvancedIncubatorBlockEntity advancedIncubatorBlockEntity = inventoryEnergyBlockEntity instanceof AdvancedIncubatorBlockEntity ? (AdvancedIncubatorBlockEntity)inventoryEnergyBlockEntity : null;
            if (advancedIncubatorBlockEntity == null) {
                return;
            }
            AdvancedIncubatorBlockEntity blockEntity = advancedIncubatorBlockEntity;
            ItemStack topStack = blockEntity.getItemHandler().getStackInSlot(0);
            ClientLevel clientLevel = ClientUtil.INSTANCE.getLocalLevel();
            Intrinsics.checkNotNull((Object)clientLevel);
            Level level = (Level)clientLevel;
            Intrinsics.checkNotNull((Object)topStack);
            GmoRecipe gmoRecipe = GmoRecipe.Companion.getGmoRecipe(level, topStack, potionStack, blockEntity.isHighTemperature());
            if (gmoRecipe == null) {
                return;
            }
            GmoRecipe recipe = gmoRecipe;
            float chanceDecreasePerOverclocker = (float)((Number)ServerConfig.Companion.getIncubatorOverclockerChanceDecrease().get()).doubleValue();
            float chanceIncreasePerChorus = (float)((Number)ServerConfig.Companion.getIncubatorChorusFruitChanceIncrease().get()).doubleValue();
            float baseChance = recipe.getGeneChance();
            int amountOverclockers = blockEntity.getAmountOfOverclockers();
            float overclockerChanceFactor = 1.0f - (float)amountOverclockers * chanceDecreasePerOverclocker;
            float reducedChance = RangesKt.coerceIn((float)(baseChance * overclockerChanceFactor), (float)0.0f, (float)1.0f);
            int chorusRequiredForMaxChance = Mth.ceil((float)((1.0f - reducedChance) / chanceIncreasePerChorus));
            int chorusAvailable = blockEntity.getItemHandler().getStackInSlot(4).getCount();
            int chorusUsed = Math.min(chorusRequiredForMaxChance, chorusAvailable);
            float chorusBoost = (float)chorusUsed * chanceIncreasePerChorus;
            float finalChance = reducedChance + chorusBoost;
            int index = event.getToolTip().size();
            event.getToolTip().add(index++, CommonComponents.EMPTY);
            int n = index++;
            Object[] objectArray = new Object[]{Gene.Companion.getNameComponent$default(Gene.Companion, recipe.getIdealGeneRk(), null, 2, null), (int)(baseChance * (float)100)};
            event.getToolTip().add(n, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo.chance", objectArray).withStyle(ChatFormatting.GRAY));
            if (amountOverclockers != 0) {
                int n2 = index++;
                objectArray = new Object[]{amountOverclockers, (int)(reducedChance * (float)100)};
                event.getToolTip().add(n2, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo.overclocker", objectArray).withStyle(ChatFormatting.GRAY));
            }
            if (chorusUsed != 0) {
                objectArray = new Object[]{chorusUsed, (int)(finalChance * (float)100)};
                event.getToolTip().add(index, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo.chorus", objectArray).withStyle(ChatFormatting.GRAY));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

