/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator_advanced;

import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.handler.WrappedHandler;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator.IncubatorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator_advanced.AdvancedIncubatorBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.incubator_advanced.AdvancedIncubatorMenu;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntities;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0097\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u00012\u0018\u0000 Z2\u00020\u00012\u00020\u0002:\u0001ZB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0014J\u0018\u0010I\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0014J\u0006\u0010L\u001a\u00020DJ\b\u0010N\u001a\u00020DH\u0016J\b\u0010O\u001a\u00020DH\u0014J\u0018\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020Q2\u0006\u0010W\u001a\u00020XH\u0002J\b\u0010Y\u001a\u00020;H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010&R\u0014\u0010+\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010&R\u0014\u0010-\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010&R\u0014\u0010/\u001a\u00020#X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010&R\u0010\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00103R\u000e\u00104\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000e8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010\u0010\"\u0004\b8\u00109R\u000e\u0010:\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010<\u001a\u00020;2\u0006\u00105\u001a\u00020;8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010=R\u0014\u0010A\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0010R\u0014\u0010J\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u0010R\u000e\u0010M\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "machineName", "", "getMachineName", "()Ljava/lang/String;", "energyMaximum", "", "getEnergyMaximum", "()I", "energyTransferMaximum", "getEnergyTransferMaximum", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "amountOfItemSlots", "getAmountOfItemSlots", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "chorusHandler", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "upItemHandler", "getUpItemHandler", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "downItemHandler", "getDownItemHandler", "backItemHandler", "getBackItemHandler", "frontItemHandler", "getFrontItemHandler", "rightItemHandler", "getRightItemHandler", "leftItemHandler", "getLeftItemHandler", "data", "dev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity$data$1", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity$data$1;", "ticksRemainingNbtKey", "value", "ticksRemaining", "getTicksRemaining", "setTicksRemaining", "(I)V", "isHighTemperatureNbtKey", "", "isHighTemperature", "()Z", "setHighTemperature", "(Z)V", "isBrewing", "baseEnergyCostPerTick", "getBaseEnergyCostPerTick", "saveAdditional", "", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "amountOfOverclockers", "getAmountOfOverclockers", "resetBrewTime", "subticks", "tick", "craftItem", "gmoRecipeOutput", "Lnet/minecraft/world/item/ItemStack;", "gmoRecipe", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/GmoRecipe;", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "nonGmoRecipeOutput", "incubatorRecipe", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "hasRecipe", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAdvancedIncubatorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedIncubatorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1755#2,3:321\n*S KotlinDebug\n*F\n+ 1 AdvancedIncubatorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity\n*L\n285#1:321,3\n*E\n"})
public final class AdvancedIncubatorBlockEntity
extends CraftingMachineBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String machineName;
    private final int energyMaximum;
    private final int energyTransferMaximum;
    private final int amountOfItemSlots;
    @NotNull
    private final ItemStackHandler itemHandler;
    @NotNull
    private final WrappedHandler chorusHandler;
    @NotNull
    private final WrappedHandler upItemHandler;
    @NotNull
    private final WrappedHandler downItemHandler;
    @NotNull
    private final WrappedHandler backItemHandler;
    @NotNull
    private final WrappedHandler frontItemHandler;
    @NotNull
    private final WrappedHandler rightItemHandler;
    @NotNull
    private final WrappedHandler leftItemHandler;
    @NotNull
    private final data.1 data;
    @NotNull
    private final String ticksRemainingNbtKey;
    @NotNull
    private final String isHighTemperatureNbtKey;
    private final int baseEnergyCostPerTick;
    private int subticks;
    public static final int SIMPLE_CONTAINER_SIZE = 2;
    public static final int REMAINING_TICKS_INDEX = 0;
    public static final int IS_HIGH_TEMPERATURE_INDEX = 1;
    public static final int TOP_SLOT_INDEX = 0;
    public static final int LEFT_BOTTLE_SLOT_INDEX = 1;
    public static final int MIDDLE_BOTTLE_SLOT_INDEX = 2;
    public static final int RIGHT_BOTTLE_SLOT_INDEX = 3;
    public static final int CHORUS_SLOT_INDEX = 4;
    public static final int OVERCLOCKER_SLOT_INDEX = 5;

    public AdvancedIncubatorBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        Object object = ModBlockEntities.INSTANCE.getADVANCED_INCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pPos, pBlockState);
        this.machineName = "advanced_incubator";
        this.energyMaximum = 50000;
        this.energyTransferMaximum = 500;
        this.amountOfItemSlots = 6;
        int n = this.getAmountOfItemSlots();
        this.itemHandler = new ItemStackHandler(this, n){
            final /* synthetic */ AdvancedIncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void onContentsChanged(int slot) {
                this.this$0.setChanged();
                if (slot == 5) {
                    this.this$0.resetBrewTime();
                }
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> {
                        Level v0 = AdvancedIncubatorBlockEntity.access$getLevel$p(this.this$0);
                        Intrinsics.checkNotNull((Object)v0);
                        yield AbstractIncubatorRecipe.Companion.isValidIngredient(v0, stack);
                    }
                    case 1, 2, 3 -> {
                        Level v2 = AdvancedIncubatorBlockEntity.access$getLevel$p(this.this$0);
                        Intrinsics.checkNotNull((Object)v2);
                        yield AbstractIncubatorRecipe.Companion.isValidIngredient(v2, stack);
                    }
                    case 5 -> Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getOVERCLOCKER().get());
                    case 4 -> Intrinsics.areEqual((Object)stack.getItem(), (Object)Items.CHORUS_FRUIT);
                    default -> false;
                };
            }
        };
        this.chorusHandler = new WrappedHandler((IItemHandlerModifiable)this.getItemHandler(), (Function1<? super Integer, Boolean>)((Function1)AdvancedIncubatorBlockEntity::chorusHandler$lambda$0), (Function2<? super Integer, ? super ItemStack, Boolean>)((Function2)AdvancedIncubatorBlockEntity::chorusHandler$lambda$1));
        this.upItemHandler = IncubatorBlockEntity.Companion.topSlotHandler((IItemHandlerModifiable)this.getItemHandler());
        this.downItemHandler = IncubatorBlockEntity.Companion.bottomSlotsHandler((IItemHandlerModifiable)this.getItemHandler());
        this.backItemHandler = this.chorusHandler;
        this.frontItemHandler = this.chorusHandler;
        this.rightItemHandler = IncubatorBlockEntity.Companion.bottomSlotsHandler((IItemHandlerModifiable)this.getItemHandler());
        this.leftItemHandler = IncubatorBlockEntity.Companion.bottomSlotsHandler((IItemHandlerModifiable)this.getItemHandler());
        this.data = new ContainerData(this){
            private int remainingTicks;
            private int isHighTemperature;
            final /* synthetic */ AdvancedIncubatorBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> this.remainingTicks;
                    case 1 -> this.isHighTemperature;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        this.remainingTicks = pValue;
                        break;
                    }
                    case 1: {
                        this.isHighTemperature = pValue;
                    }
                }
                this.this$0.setChanged();
            }

            public int getCount() {
                return 2;
            }
        };
        this.ticksRemainingNbtKey = this.getMachineName() + ".ticksRemaining";
        this.isHighTemperatureNbtKey = this.getMachineName() + ".isHighTemperature";
        this.baseEnergyCostPerTick = 10;
    }

    @Override
    @NotNull
    public String getMachineName() {
        return this.machineName;
    }

    @Override
    public int getEnergyMaximum() {
        return this.energyMaximum;
    }

    @Override
    public int getEnergyTransferMaximum() {
        return this.energyTransferMaximum;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return new AdvancedIncubatorMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = ((Block)ModBlocks.INSTANCE.getADVANCED_INCUBATOR().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    @Override
    public int getAmountOfItemSlots() {
        return this.amountOfItemSlots;
    }

    @Override
    @NotNull
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getUpItemHandler() {
        return this.upItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getDownItemHandler() {
        return this.downItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getBackItemHandler() {
        return this.backItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getFrontItemHandler() {
        return this.frontItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getRightItemHandler() {
        return this.rightItemHandler;
    }

    @Override
    @NotNull
    protected WrappedHandler getLeftItemHandler() {
        return this.leftItemHandler;
    }

    public final int getTicksRemaining() {
        return this.data.get(0);
    }

    private final void setTicksRemaining(int value) {
        this.data.set(0, value);
    }

    public final boolean isHighTemperature() {
        return this.data.get(1) == 1;
    }

    private final void setHighTemperature(boolean value) {
        this.data.set(1, value ? 1 : 0);
    }

    public final boolean isBrewing() {
        return this.getTicksRemaining() > 0;
    }

    @Override
    public int getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        pTag.putInt(this.ticksRemainingNbtKey, this.getTicksRemaining());
        pTag.putBoolean(this.isHighTemperatureNbtKey, this.isHighTemperature());
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        this.setTicksRemaining(pTag.getInt(this.ticksRemainingNbtKey));
        this.setHighTemperature(pTag.getBoolean(this.isHighTemperatureNbtKey));
        super.loadAdditional(pTag, pRegistries);
    }

    @Override
    public int getAmountOfOverclockers() {
        return this.getItemHandler().getStackInSlot(5).getCount();
    }

    public final void resetBrewTime() {
        this.setTicksRemaining(IncubatorBlockEntity.Companion.getTicksPerBrew());
        this.subticks = 0;
    }

    @Override
    public void tick() {
        if (!this.isBrewing() && this.hasRecipe()) {
            this.setTicksRemaining(IncubatorBlockEntity.Companion.getTicksPerBrew());
        } else if (!this.hasRecipe()) {
            this.setTicksRemaining(0);
            return;
        }
        if (this.isHighTemperature()) {
            this.getEnergyStorage().extractEnergy(this.energyCostPerTick(), false);
            this.setTicksRemaining(this.getTicksRemaining() - (1 + this.getAmountOfOverclockers()));
        } else {
            int amountOfOverclockers = this.getAmountOfOverclockers();
            this.subticks += 1 + amountOfOverclockers;
            int subticksOverMax = this.subticks - Companion.getLowTempTickFactor();
            if (subticksOverMax >= 0) {
                this.subticks = subticksOverMax;
                this.getEnergyStorage().extractEnergy(this.energyCostPerTick(), false);
                this.setTicksRemaining(this.getTicksRemaining() - 1);
            }
        }
        if (this.getTicksRemaining() <= 0) {
            this.craftItem();
            return;
        }
    }

    @Override
    protected void craftItem() {
        ItemStack topStack = this.getItemHandler().getStackInSlot(0);
        Object object = new Integer[]{1, 2, 3};
        List bottleSlots = CollectionsKt.listOf((Object[])object);
        object = bottleSlots.iterator();
        while (object.hasNext()) {
            AbstractIncubatorRecipe incubatorRecipe;
            ItemStack output;
            int slotIndex = ((Number)object.next()).intValue();
            ItemStack bottomStack = this.getItemHandler().getStackInSlot(slotIndex);
            Intrinsics.checkNotNull((Object)topStack);
            Intrinsics.checkNotNull((Object)bottomStack);
            IncubatorRecipeInput incubatorInput = new IncubatorRecipeInput(topStack, bottomStack, this.isHighTemperature());
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            if (AbstractIncubatorRecipe.Companion.getIncubatorRecipe(level, incubatorInput) == null || (output = incubatorRecipe instanceof GmoRecipe ? this.gmoRecipeOutput((GmoRecipe)incubatorRecipe, incubatorInput) : this.nonGmoRecipeOutput(incubatorRecipe)).isEmpty()) continue;
            this.getItemHandler().setStackInSlot(slotIndex, output);
        }
        topStack.shrink(1);
        this.setChanged();
    }

    private final ItemStack gmoRecipeOutput(GmoRecipe gmoRecipe, IncubatorRecipeInput input) {
        ItemStack itemStack;
        float chanceDecreasePerOverclocker = (float)((Number)ServerConfig.Companion.getIncubatorOverclockerChanceDecrease().get()).doubleValue();
        float chanceIncreasePerChorus = (float)((Number)ServerConfig.Companion.getIncubatorChorusFruitChanceIncrease().get()).doubleValue();
        float geneChance = gmoRecipe.getGeneChance();
        float overclockerChanceFactor = 1.0f - (float)this.getAmountOfOverclockers() * chanceDecreasePerOverclocker;
        float reducedChance = RangesKt.coerceIn((float)(geneChance * overclockerChanceFactor), (float)0.0f, (float)1.0f);
        int chorusRequiredForMaxChance = Mth.ceil((float)((1.0f - reducedChance) / chanceIncreasePerChorus));
        int chorusAvailable = this.getItemHandler().getStackInSlot(4).getCount();
        int chorusUsed = Math.min(chorusRequiredForMaxChance, chorusAvailable);
        this.getItemHandler().getStackInSlot(4).shrink(chorusUsed);
        float chorusBoost = (float)chorusUsed * chanceIncreasePerChorus;
        float finalChance = reducedChance + chorusBoost;
        float nextFloat = Random.Default.nextFloat();
        if (nextFloat <= finalChance) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            RegistryAccess registryAccess = level.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            itemStack = gmoRecipe.assemble(input, (HolderLookup.Provider)registryAccess);
        } else {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            RegistryAccess registryAccess = level.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            itemStack = gmoRecipe.getFailure((HolderLookup.Provider)registryAccess);
        }
        return itemStack;
    }

    private final ItemStack nonGmoRecipeOutput(AbstractIncubatorRecipe incubatorRecipe) {
        ItemStack itemStack = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        ItemStack itemStack2 = this.getItemHandler().getStackInSlot(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackInSlot(...)");
        RecipeInput recipeInput = new IncubatorRecipeInput(itemStack, itemStack2, this.isHighTemperature());
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        ItemStack output = incubatorRecipe.assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
        Intrinsics.checkNotNull((Object)output);
        return output;
    }

    @Override
    protected boolean hasRecipe() {
        boolean bl;
        block7: {
            if (!this.hasEnoughEnergy()) {
                return false;
            }
            ItemStack topStack = this.getItemHandler().getStackInSlot(0);
            if (topStack.isEmpty()) {
                return false;
            }
            Object[] objectArray = new ItemStack[]{this.getItemHandler().getStackInSlot(1), this.getItemHandler().getStackInSlot(2), this.getItemHandler().getStackInSlot(3)};
            List bottomStacks = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = bottomStacks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ItemStack bottomStack = (ItemStack)element$iv;
                    boolean bl3 = false;
                    if (bottomStack.isEmpty()) {
                        bl2 = false;
                    } else {
                        Intrinsics.checkNotNull((Object)topStack);
                        Intrinsics.checkNotNull((Object)bottomStack);
                        IncubatorRecipeInput input = new IncubatorRecipeInput(topStack, bottomStack, this.isHighTemperature());
                        Level level = this.level;
                        Intrinsics.checkNotNull((Object)level);
                        bl2 = AbstractIncubatorRecipe.Companion.hasIncubatorRecipe(level, input);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean chorusHandler$lambda$0(int slot) {
        return slot == 1;
    }

    private static final boolean chorusHandler$lambda$1(int slot, ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return slot == 4;
    }

    public static final /* synthetic */ Level access$getLevel$p(AdvancedIncubatorBlockEntity $this) {
        return $this.level;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/incubator_advanced/AdvancedIncubatorBlockEntity;", "SIMPLE_CONTAINER_SIZE", "", "REMAINING_TICKS_INDEX", "IS_HIGH_TEMPERATURE_INDEX", "TOP_SLOT_INDEX", "LEFT_BOTTLE_SLOT_INDEX", "MIDDLE_BOTTLE_SLOT_INDEX", "RIGHT_BOTTLE_SLOT_INDEX", "CHORUS_SLOT_INDEX", "OVERCLOCKER_SLOT_INDEX", "lowTempTickFactor", "getLowTempTickFactor", "()I", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull AdvancedIncubatorBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public final int getLowTempTickFactor() {
            Object object = ServerConfig.Companion.getIncubatorLowTempTickFactor().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

