/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.machine.dna_decryptor;

import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.dna_decryptor.DnaDecryptorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.machine.dna_decryptor.DnaDecryptorMenu;
import dev.aaronhowser.mods.geneticsresequenced.data.EntityGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntities;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020%H\u0014J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0002J$\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'022\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00103\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020-H\u0002R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/dna_decryptor/DnaDecryptorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "machineName", "", "getMachineName", "()Ljava/lang/String;", "energyMaximum", "", "getEnergyMaximum", "()I", "energyTransferMaximum", "getEnergyTransferMaximum", "baseEnergyCostPerTick", "getBaseEnergyCostPerTick", "amountOfItemSlots", "getAmountOfItemSlots", "itemHandler", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getItemHandler", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "isNextGeneSet", "", "nextGeneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "craftItem", "", "hasRecipe", "getOutputFromInput", "Lnet/minecraft/world/item/ItemStack;", "input", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getPossibleGenes", "", "outputSlotHasRoom", "inventory", "Lnet/minecraft/world/SimpleContainer;", "potentialOutput", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDnaDecryptorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnaDecryptorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/machine/dna_decryptor/DnaDecryptorBlockEntity\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n126#2:168\n153#2,3:169\n827#3:172\n855#3,2:173\n*S KotlinDebug\n*F\n+ 1 DnaDecryptorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/machine/dna_decryptor/DnaDecryptorBlockEntity\n*L\n142#1:168\n142#1:169,3\n143#1:172\n143#1:173,2\n*E\n"})
public final class DnaDecryptorBlockEntity
extends CraftingMachineBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String machineName;
    private final int energyMaximum;
    private final int energyTransferMaximum;
    private final int baseEnergyCostPerTick;
    private final int amountOfItemSlots;
    @NotNull
    private final ItemStackHandler itemHandler;
    private boolean isNextGeneSet;
    @Nullable
    private Holder<Gene> nextGeneHolder;

    public DnaDecryptorBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        Object object = ModBlockEntities.INSTANCE.getDNA_DECRYPTOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pPos, pBlockState);
        this.machineName = "dna_decryptor";
        this.energyMaximum = 60000;
        this.energyTransferMaximum = 256;
        this.baseEnergyCostPerTick = 32;
        this.amountOfItemSlots = 3;
        int n = this.getAmountOfItemSlots();
        this.itemHandler = new ItemStackHandler(this, n){
            final /* synthetic */ DnaDecryptorBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void onContentsChanged(int slot) {
                this.this$0.setChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getDNA_HELIX().get());
                    case 2 -> Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getOVERCLOCKER().get());
                    case 1 -> false;
                    default -> false;
                };
            }
        };
    }

    @Override
    @NotNull
    public String getMachineName() {
        return this.machineName;
    }

    @Override
    public int getEnergyMaximum() {
        return this.energyMaximum;
    }

    @Override
    public int getEnergyTransferMaximum() {
        return this.energyTransferMaximum;
    }

    @Override
    public int getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getAmountOfItemSlots() {
        return this.amountOfItemSlots;
    }

    @Override
    @NotNull
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return new DnaDecryptorMenu(pContainerId, pPlayerInventory, this, this.getContainerData());
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = ((DnaDecryptorBlock)((Object)ModBlocks.INSTANCE.getDNA_DECRYPTOR().get())).getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    @Override
    protected void craftItem() {
        if (!this.hasRecipe()) {
            return;
        }
        ItemStack inputItem = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkNotNull((Object)inputItem);
        Level level = this.level;
        Object object = level != null ? level.registryAccess() : null;
        Intrinsics.checkNotNull((Object)object);
        ItemStack itemStack = this.getOutputFromInput(inputItem, (HolderLookup.Provider)object);
        if (itemStack == null) {
            return;
        }
        ItemStack outputItem = itemStack;
        int amountAlreadyInOutput = this.getItemHandler().getStackInSlot(1).getCount();
        outputItem.setCount(amountAlreadyInOutput + 1);
        this.getItemHandler().extractItem(0, 1, false);
        this.getItemHandler().setStackInSlot(1, outputItem);
        this.resetProgress();
        this.isNextGeneSet = false;
    }

    @Override
    protected boolean hasRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.getItemHandler().getSlots());
        int n = this.getItemHandler().getSlots();
        for (int i = 0; i < n; ++i) {
            inventory.setItem(i, this.getItemHandler().getStackInSlot(i));
        }
        ItemStack inputStack = inventory.getItem(0);
        if (!Intrinsics.areEqual((Object)inputStack.getItem(), (Object)ModItems.INSTANCE.getDNA_HELIX().get())) {
            return false;
        }
        Intrinsics.checkNotNull((Object)inputStack);
        if (DnaHelixItem.Companion.getGeneHolder(inputStack) != null) {
            return false;
        }
        ItemStack itemStack = inventory.getItem(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        Level level = this.level;
        Object object = level != null ? level.registryAccess() : null;
        Intrinsics.checkNotNull((Object)object);
        ItemStack itemStack2 = this.getOutputFromInput(itemStack, (HolderLookup.Provider)object);
        if (itemStack2 == null) {
            return false;
        }
        ItemStack outputItem = itemStack2;
        return this.outputSlotHasRoom(inventory, outputItem);
    }

    private final ItemStack getOutputFromInput(ItemStack input, HolderLookup.Provider registries) {
        List<Holder<Gene>> possibleGeneHolders = this.getPossibleGenes(input, registries);
        Holder geneHolder = null;
        if (!this.isNextGeneSet) {
            if (!Intrinsics.areEqual((Object)input.getItem(), (Object)ModItems.INSTANCE.getDNA_HELIX().get())) {
                throw new IllegalStateException("Invalid item in input slot");
            }
            this.nextGeneHolder = geneHolder = (Holder)CollectionsKt.random((Collection)possibleGeneHolders, (Random)((Random)Random.Default));
            this.isNextGeneSet = true;
        } else {
            if (!CollectionsKt.contains((Iterable)possibleGeneHolders, this.nextGeneHolder)) {
                this.isNextGeneSet = false;
                return null;
            }
            if (this.nextGeneHolder != null) {
                Holder holder = this.nextGeneHolder;
                Intrinsics.checkNotNull(holder);
                geneHolder = holder;
            } else {
                return null;
            }
        }
        ItemStack helixStack = DnaHelixItem.Companion.getHelixStack((Holder<Gene>)geneHolder);
        return helixStack;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Holder<Gene>> getPossibleGenes(ItemStack input, HolderLookup.Provider registries) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Holder it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map<Holder<Gene>, Integer> genesFromMob;
        Holder.Reference<Gene> basic = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.INSTANCE.getBASIC(), registries);
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(input);
        if (entityType == null) {
            return CollectionsKt.listOf(basic);
        }
        EntityType<?> mobType = entityType;
        Map<Holder<Gene>, Integer> map = genesFromMob = EntityGenes.Companion.getGeneHolderWeights(mobType, registries);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Holder)it.getKey());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Map.Entry element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Holder)element$iv$iv;
            boolean bl = false;
            if (Gene.Companion.isDisabled((Holder<Gene>)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean outputSlotHasRoom(SimpleContainer inventory, ItemStack potentialOutput) {
        ItemStack currentItemInOutput = inventory.getItem(1);
        if (currentItemInOutput.isEmpty()) {
            return true;
        }
        if (currentItemInOutput.getCount() + potentialOutput.getCount() > currentItemInOutput.getMaxStackSize()) {
            return false;
        }
        Intrinsics.checkNotNull((Object)currentItemInOutput);
        return Intrinsics.areEqual(DnaHelixItem.Companion.getGeneHolder(currentItemInOutput), DnaHelixItem.Companion.getGeneHolder(potentialOutput));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/machine/dna_decryptor/DnaDecryptorBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/machine/dna_decryptor/DnaDecryptorBlockEntity;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull DnaDecryptorBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

