/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.base.menu.part;

import dev.aaronhowser.mods.geneticsresequenced.block.base.handler.ModEnergyStorage;
import dev.aaronhowser.mods.geneticsresequenced.block.base.menu.ScreenTextures;
import dev.aaronhowser.mods.geneticsresequenced.datagen.ModLanguageProvider;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/menu/part/EnergyBar;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "x", "", "y", "energyStorage", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/ModEnergyStorage;", "font", "Lnet/minecraft/client/gui/Font;", "<init>", "(IILdev/aaronhowser/mods/geneticsresequenced/block/base/handler/ModEnergyStorage;Lnet/minecraft/client/gui/Font;)V", "getEnergyStorage", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/ModEnergyStorage;", "getFont", "()Lnet/minecraft/client/gui/Font;", "renderWidget", "", "pGuiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "pMouseX", "pMouseY", "pPartialTick", "", "renderTooltip", "updateWidgetNarration", "pNarrationElementOutput", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "geneticsresequenced-1.21.1"})
public final class EnergyBar
extends AbstractWidget {
    @NotNull
    private final ModEnergyStorage energyStorage;
    @NotNull
    private final Font font;

    public EnergyBar(int x, int y, @NotNull ModEnergyStorage energyStorage2, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)((Object)energyStorage2), (String)"energyStorage");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        super(x, y, 18, 57, (Component)Component.empty());
        this.energyStorage = energyStorage2;
        this.font = font;
    }

    @NotNull
    public final ModEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Intrinsics.checkNotNullParameter((Object)pGuiGraphics, (String)"pGuiGraphics");
        float percentFull = (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored();
        int energyTotalHeight = this.height;
        int energyCurrentHeight = Mth.ceil((double)((double)energyTotalHeight * (double)percentFull));
        pGuiGraphics.blitSprite(ScreenTextures.Elements.Energy.INSTANCE.getTEXTURE(), 64, 64, 0, energyTotalHeight - energyCurrentHeight, this.getX(), this.getY() + energyTotalHeight - energyCurrentHeight, 64, energyCurrentHeight);
        if (this.isHovered) {
            this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        }
    }

    private final void renderTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        String string = "%,d";
        Object[] objectArray = new Object[]{this.energyStorage.getEnergyStored()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String currentAmountString = string2;
        objectArray = "%,d";
        Object[] objectArray2 = new Object[]{this.energyStorage.getMaxEnergyStored()};
        String string3 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String maxAmountString = string3;
        objectArray = new Object[]{currentAmountString, maxAmountString};
        MutableComponent component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.fe", objectArray);
        pGuiGraphics.renderComponentTooltip(this.font, CollectionsKt.listOf((Object)component), pMouseX, pMouseY);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)pNarrationElementOutput, (String)"pNarrationElementOutput");
        this.defaultButtonNarrationText(pNarrationElementOutput);
    }
}

