/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.base.menu;

import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.block.base.InventoryEnergyBlockEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0001$B+\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0014J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0014J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/menu/MachineMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "menuType", "Lnet/minecraft/world/inventory/MenuType;", "blockEntity", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/InventoryEnergyBlockEntity;", "id", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "<init>", "(Lnet/minecraft/world/inventory/MenuType;Ldev/aaronhowser/mods/geneticsresequenced/block/base/InventoryEnergyBlockEntity;ILnet/minecraft/world/entity/player/Inventory;)V", "getBlockEntity", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/InventoryEnergyBlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "topLeftInventoryX", "getTopLeftInventoryX", "()I", "topLeftInventoryY", "getTopLeftInventoryY", "getPercentDone", "", "addPlayerInventory", "", "playerInventory", "addPlayerHotbar", "amountSlots", "getAmountSlots", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "playerIn", "Lnet/minecraft/world/entity/player/Player;", "index", "Companion", "geneticsresequenced-1.21.1"})
public abstract class MachineMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InventoryEnergyBlockEntity blockEntity;
    @NotNull
    private final Level level;
    private final int topLeftInventoryX;
    private final int topLeftInventoryY;
    private final int amountSlots;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;

    public MachineMenu(@NotNull MenuType<?> menuType, @NotNull InventoryEnergyBlockEntity blockEntity, int id, @NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter(menuType, (String)"menuType");
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        super(menuType, id);
        this.blockEntity = blockEntity;
        Level level = inventory.player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.level = level;
        this.topLeftInventoryX = 8;
        this.topLeftInventoryY = 90;
        this.amountSlots = this.blockEntity.getAmountOfItemSlots();
    }

    @NotNull
    public final InventoryEnergyBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @NotNull
    protected final Level getLevel() {
        return this.level;
    }

    protected int getTopLeftInventoryX() {
        return this.topLeftInventoryX;
    }

    protected int getTopLeftInventoryY() {
        return this.topLeftInventoryY;
    }

    public abstract float getPercentDone();

    protected void addPlayerInventory(@NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, column + row * 9 + 9, this.getTopLeftInventoryX() + column * 18, this.getTopLeftInventoryY() + row * 18));
            }
        }
    }

    protected void addPlayerHotbar(@NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, this.getTopLeftInventoryX() + column * 18, this.getTopLeftInventoryY() + 4 + 54));
        }
    }

    protected final int getAmountSlots() {
        return this.amountSlots;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        NonNullList nonNullList = this.slots;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"slots");
        Slot sourceSlot = (Slot)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 36 + this.amountSlots, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else if (index < 36 + this.amountSlots) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else {
            GeneticsResequenced.Companion.getLOGGER().error("Invalid slotIndex: " + index);
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        Intrinsics.checkNotNull((Object)copyOfSourceStack);
        return copyOfSourceStack;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/menu/MachineMenu$Companion;", "", "<init>", "()V", "HOTBAR_SLOT_COUNT", "", "PLAYER_INVENTORY_ROW_COUNT", "PLAYER_INVENTORY_COLUMN_COUNT", "PLAYER_INVENTORY_SLOT_COUNT", "VANILLA_SLOT_COUNT", "VANILLA_FIRST_SLOT_INDEX", "TE_INVENTORY_FIRST_SLOT_INDEX", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

