/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.base;

import dev.aaronhowser.mods.geneticsresequenced.block.base.InventoryEnergyBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.handler.WrappedHandler;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\b&\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0001IB#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0004J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020\u001aH\u0014J\b\u0010.\u001a\u00020,H$J\b\u0010/\u001a\u00020\u001aH$J\b\u00100\u001a\u00020\u001aH\u0016R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0015R\u0014\u0010\u001b\u001a\u00020\u001c8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010'\u001a\u00020(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b3\u00104R\u001b\u00107\u001a\u0002028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u00106\u001a\u0004\b8\u00104R\u001b\u0010:\u001a\u0002028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u00106\u001a\u0004\b;\u00104R\u001b\u0010=\u001a\u0002028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u00106\u001a\u0004\b>\u00104R\u001b\u0010@\u001a\u0002028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u00106\u001a\u0004\bA\u00104R\u001b\u0010C\u001a\u0002028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u00106\u001a\u0004\bD\u00104R\u001b\u0010F\u001a\u0002028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u00106\u001a\u0004\bG\u00104\u00a8\u0006J"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/InventoryEnergyBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "baseEnergyCostPerTick", "", "getBaseEnergyCostPerTick", "()I", "energyCostPerTick", "amountOfOverclockers", "getAmountOfOverclockers", "progress", "getProgress", "setProgress", "(I)V", "maxProgress", "getMaxProgress", "setMaxProgress", "resetProgress", "", "progressNbtKey", "", "getProgressNbtKey", "()Ljava/lang/String;", "maxProgressNbtKey", "getMaxProgressNbtKey", "saveAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "containerData", "Lnet/minecraft/world/inventory/ContainerData;", "getContainerData", "()Lnet/minecraft/world/inventory/ContainerData;", "hasEnoughEnergy", "", "extractEnergy", "hasRecipe", "craftItem", "tick", "allFaceHandler", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "getAllFaceHandler", "()Ldev/aaronhowser/mods/geneticsresequenced/block/base/handler/WrappedHandler;", "allFaceHandler$delegate", "Lkotlin/Lazy;", "upItemHandler", "getUpItemHandler", "upItemHandler$delegate", "downItemHandler", "getDownItemHandler", "downItemHandler$delegate", "backItemHandler", "getBackItemHandler", "backItemHandler$delegate", "frontItemHandler", "getFrontItemHandler", "frontItemHandler$delegate", "rightItemHandler", "getRightItemHandler", "rightItemHandler$delegate", "leftItemHandler", "getLeftItemHandler", "leftItemHandler$delegate", "Companion", "geneticsresequenced-1.21.1"})
public abstract class CraftingMachineBlockEntity
extends InventoryEnergyBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int progress;
    private int maxProgress;
    @NotNull
    private final ContainerData containerData;
    @NotNull
    private final Lazy allFaceHandler$delegate;
    @NotNull
    private final Lazy upItemHandler$delegate;
    @NotNull
    private final Lazy downItemHandler$delegate;
    @NotNull
    private final Lazy backItemHandler$delegate;
    @NotNull
    private final Lazy frontItemHandler$delegate;
    @NotNull
    private final Lazy rightItemHandler$delegate;
    @NotNull
    private final Lazy leftItemHandler$delegate;
    public static final int SIMPLE_CONTAINER_SIZE = 2;
    public static final int ITEMSTACK_HANDLER_SIZE = 3;
    public static final int INPUT_SLOT_INDEX = 0;
    public static final int OUTPUT_SLOT_INDEX = 1;
    public static final int OVERCLOCK_SLOT_INDEX = 2;

    public CraftingMachineBlockEntity(@NotNull BlockEntityType<?> pType, @NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter(pType, (String)"pType");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super(pType, pPos, pBlockState);
        this.maxProgress = 80;
        this.containerData = new ContainerData(this){
            private final int PROGRESS_INDEX;
            private final int MAX_PROGRESS_INDEX;
            final /* synthetic */ CraftingMachineBlockEntity this$0;
            {
                this.this$0 = $receiver;
                this.MAX_PROGRESS_INDEX = 1;
            }

            public int get(int pIndex) {
                int n = pIndex;
                return n == this.PROGRESS_INDEX ? this.this$0.getProgress() : (n == this.MAX_PROGRESS_INDEX ? this.this$0.getMaxProgress() : 0);
            }

            public void set(int pIndex, int pValue) {
                int n = pIndex;
                if (n == this.PROGRESS_INDEX) {
                    this.this$0.setProgress(pValue);
                } else if (n == this.MAX_PROGRESS_INDEX) {
                    this.this$0.setMaxProgress(pValue);
                }
            }

            public int getCount() {
                return 2;
            }
        };
        this.allFaceHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.allFaceHandler_delegate$lambda$2(this));
        this.upItemHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.upItemHandler_delegate$lambda$3(this));
        this.downItemHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.downItemHandler_delegate$lambda$4(this));
        this.backItemHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.backItemHandler_delegate$lambda$5(this));
        this.frontItemHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.frontItemHandler_delegate$lambda$6(this));
        this.rightItemHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.rightItemHandler_delegate$lambda$7(this));
        this.leftItemHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.leftItemHandler_delegate$lambda$8(this));
    }

    public abstract int getBaseEnergyCostPerTick();

    public final int energyCostPerTick() {
        return this.getBaseEnergyCostPerTick() + (int)((float)(this.getBaseEnergyCostPerTick() * this.getAmountOfOverclockers()) * 0.25f);
    }

    public int getAmountOfOverclockers() {
        return this.getItemHandler().getStackInSlot(2).getCount();
    }

    protected final int getProgress() {
        return this.progress;
    }

    protected final void setProgress(int n) {
        this.progress = n;
    }

    protected final int getMaxProgress() {
        return this.maxProgress;
    }

    protected final void setMaxProgress(int n) {
        this.maxProgress = n;
    }

    protected final void resetProgress() {
        this.progress = 0;
    }

    @NotNull
    protected final String getProgressNbtKey() {
        return this.getMachineName() + ".progress";
    }

    @NotNull
    protected final String getMaxProgressNbtKey() {
        return this.getMachineName() + ".max_progress";
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        pTag.putInt(this.getProgressNbtKey(), this.progress);
        pTag.putInt(this.getMaxProgressNbtKey(), this.maxProgress);
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        this.maxProgress = pTag.getInt(this.getMaxProgressNbtKey());
        this.progress = pTag.getInt(this.getProgressNbtKey());
        super.loadAdditional(pTag, pRegistries);
    }

    @NotNull
    protected final ContainerData getContainerData() {
        return this.containerData;
    }

    protected boolean hasEnoughEnergy() {
        return this.getEnergyStorage().getEnergyStored() >= this.energyCostPerTick();
    }

    protected void extractEnergy() {
        if (this.getEnergyStorage().getEnergyStored() < this.energyCostPerTick()) {
            return;
        }
        this.getEnergyStorage().extractEnergy(this.energyCostPerTick(), false);
    }

    protected abstract boolean hasRecipe();

    protected abstract void craftItem();

    public void tick() {
        if (!this.hasEnoughEnergy()) {
            return;
        }
        if (this.hasRecipe()) {
            this.extractEnergy();
            this.progress += 1 + this.getAmountOfOverclockers();
            this.setChanged();
            if (this.progress >= this.maxProgress) {
                this.progress = 1;
                this.craftItem();
            }
        } else {
            this.resetProgress();
            this.setChanged();
        }
    }

    private final WrappedHandler getAllFaceHandler() {
        Lazy lazy = this.allFaceHandler$delegate;
        return (WrappedHandler)lazy.getValue();
    }

    @Override
    @NotNull
    protected WrappedHandler getUpItemHandler() {
        Lazy lazy = this.upItemHandler$delegate;
        return (WrappedHandler)lazy.getValue();
    }

    @Override
    @NotNull
    protected WrappedHandler getDownItemHandler() {
        Lazy lazy = this.downItemHandler$delegate;
        return (WrappedHandler)lazy.getValue();
    }

    @Override
    @NotNull
    protected WrappedHandler getBackItemHandler() {
        Lazy lazy = this.backItemHandler$delegate;
        return (WrappedHandler)lazy.getValue();
    }

    @Override
    @NotNull
    protected WrappedHandler getFrontItemHandler() {
        Lazy lazy = this.frontItemHandler$delegate;
        return (WrappedHandler)lazy.getValue();
    }

    @Override
    @NotNull
    protected WrappedHandler getRightItemHandler() {
        Lazy lazy = this.rightItemHandler$delegate;
        return (WrappedHandler)lazy.getValue();
    }

    @Override
    @NotNull
    protected WrappedHandler getLeftItemHandler() {
        Lazy lazy = this.leftItemHandler$delegate;
        return (WrappedHandler)lazy.getValue();
    }

    private static final boolean allFaceHandler_delegate$lambda$2$lambda$0(int slotId) {
        return slotId == 1;
    }

    private static final boolean allFaceHandler_delegate$lambda$2$lambda$1(int slotId, ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return slotId == 0;
    }

    private static final WrappedHandler allFaceHandler_delegate$lambda$2(CraftingMachineBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new WrappedHandler((IItemHandlerModifiable)this$0.getItemHandler(), (Function1<? super Integer, Boolean>)((Function1)CraftingMachineBlockEntity::allFaceHandler_delegate$lambda$2$lambda$0), (Function2<? super Integer, ? super ItemStack, Boolean>)((Function2)CraftingMachineBlockEntity::allFaceHandler_delegate$lambda$2$lambda$1));
    }

    private static final WrappedHandler upItemHandler_delegate$lambda$3(CraftingMachineBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getAllFaceHandler();
    }

    private static final WrappedHandler downItemHandler_delegate$lambda$4(CraftingMachineBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getAllFaceHandler();
    }

    private static final WrappedHandler backItemHandler_delegate$lambda$5(CraftingMachineBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getAllFaceHandler();
    }

    private static final WrappedHandler frontItemHandler_delegate$lambda$6(CraftingMachineBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getAllFaceHandler();
    }

    private static final WrappedHandler rightItemHandler_delegate$lambda$7(CraftingMachineBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getAllFaceHandler();
    }

    private static final WrappedHandler leftItemHandler_delegate$lambda$8(CraftingMachineBlockEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.getAllFaceHandler();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity$Companion;", "", "<init>", "()V", "SIMPLE_CONTAINER_SIZE", "", "ITEMSTACK_HANDLER_SIZE", "INPUT_SLOT_INDEX", "OUTPUT_SLOT_INDEX", "OVERCLOCK_SLOT_INDEX", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

