/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.advancement.SyringeGenesPredicate;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.SingleComponentItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001cB\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0011H\u0016J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/advancement/SyringeGenesPredicate;", "Lnet/minecraft/advancements/critereon/SingleComponentItemPredicate;", "Lnet/minecraft/core/HolderSet;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "genes", "isAntigene", "", "<init>", "(Lnet/minecraft/core/HolderSet;Z)V", "getGenes", "()Lnet/minecraft/core/HolderSet;", "()Z", "matches", "stack", "Lnet/minecraft/world/item/ItemStack;", "requiredGenes", "componentType", "Lnet/minecraft/core/component/DataComponentType;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSyringeGenesPredicate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyringeGenesPredicate.kt\ndev/aaronhowser/mods/geneticsresequenced/advancement/SyringeGenesPredicate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1734#2,2:70\n1755#2,3:72\n1736#2:75\n*S KotlinDebug\n*F\n+ 1 SyringeGenesPredicate.kt\ndev/aaronhowser/mods/geneticsresequenced/advancement/SyringeGenesPredicate\n*L\n30#1:70,2\n31#1:72,3\n30#1:75\n*E\n"})
public final class SyringeGenesPredicate
implements SingleComponentItemPredicate<HolderSet<Gene>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HolderSet<Gene> genes;
    private final boolean isAntigene;
    @NotNull
    private static final Codec<SyringeGenesPredicate> CODEC;
    @NotNull
    private static final ItemSubPredicate.Type<SyringeGenesPredicate> TYPE;

    public SyringeGenesPredicate(@NotNull HolderSet<Gene> genes, boolean isAntigene) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        this.genes = genes;
        this.isAntigene = isAntigene;
    }

    @NotNull
    public final HolderSet<Gene> getGenes() {
        return this.genes;
    }

    public final boolean isAntigene() {
        return this.isAntigene;
    }

    public boolean matches(@NotNull ItemStack stack, @NotNull HolderSet<Gene> requiredGenes) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter(requiredGenes, (String)"requiredGenes");
            Set<Holder<Gene>> stackGenes = this.isAntigene ? SyringeItem.Companion.getAntigenes(stack) : SyringeItem.Companion.getGenes(stack);
            Iterable $this$all$iv = (Iterable)requiredGenes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block6: {
                        Holder requiredGene = (Holder)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = stackGenes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                Holder it = (Holder)element$iv2;
                                boolean bl4 = false;
                                Intrinsics.checkNotNull((Object)requiredGene);
                                if (!Gene.Companion.isGene((Holder<Gene>)it, (Holder<Gene>)requiredGene)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public DataComponentType<HolderSet<Gene>> componentType() {
        DataComponentType dataComponentType;
        if (this.isAntigene) {
            Object object = ModDataComponents.INSTANCE.getANTIGENES_COMPONENT().get();
            Intrinsics.checkNotNull((Object)object);
            dataComponentType = (DataComponentType)object;
        } else {
            Object object = ModDataComponents.INSTANCE.getGENES_COMPONENT().get();
            Intrinsics.checkNotNull((Object)object);
            dataComponentType = (DataComponentType)object;
        }
        return dataComponentType;
    }

    @NotNull
    public final HolderSet<Gene> component1() {
        return this.genes;
    }

    public final boolean component2() {
        return this.isAntigene;
    }

    @NotNull
    public final SyringeGenesPredicate copy(@NotNull HolderSet<Gene> genes, boolean isAntigene) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        return new SyringeGenesPredicate(genes, isAntigene);
    }

    public static /* synthetic */ SyringeGenesPredicate copy$default(SyringeGenesPredicate syringeGenesPredicate, HolderSet holderSet, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            holderSet = syringeGenesPredicate.genes;
        }
        if ((n & 2) != 0) {
            bl = syringeGenesPredicate.isAntigene;
        }
        return syringeGenesPredicate.copy(holderSet, bl);
    }

    @NotNull
    public String toString() {
        return "SyringeGenesPredicate(genes=" + this.genes + ", isAntigene=" + this.isAntigene + ")";
    }

    public int hashCode() {
        int result = this.genes.hashCode();
        result = result * 31 + Boolean.hashCode(this.isAntigene);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SyringeGenesPredicate)) {
            return false;
        }
        SyringeGenesPredicate syringeGenesPredicate = (SyringeGenesPredicate)other;
        if (!Intrinsics.areEqual(this.genes, syringeGenesPredicate.genes)) {
            return false;
        }
        return this.isAntigene == syringeGenesPredicate.isAntigene;
    }

    private static final HolderSet CODEC$lambda$4$lambda$2(KProperty1 $tmp0, SyringeGenesPredicate p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HolderSet)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean CODEC$lambda$4$lambda$3(KProperty1 $tmp0, SyringeGenesPredicate p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$4(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Gene.Companion.getHOLDER_SET_CODEC().fieldOf("genes").forGetter(arg_0 -> SyringeGenesPredicate.CODEC$lambda$4$lambda$2((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("is_antigene", (Object)false).forGetter(arg_0 -> SyringeGenesPredicate.CODEC$lambda$4$lambda$3((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, SyringeGenesPredicate::new);
    }

    static {
        Codec codec = RecordCodecBuilder.create(SyringeGenesPredicate::CODEC$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        TYPE = new ItemSubPredicate.Type(CODEC);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/advancement/SyringeGenesPredicate$Companion;", "", "<init>", "()V", "blackDeath", "Ldev/aaronhowser/mods/geneticsresequenced/advancement/SyringeGenesPredicate;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "TYPE", "Lnet/minecraft/advancements/critereon/ItemSubPredicate$Type;", "getTYPE", "()Lnet/minecraft/advancements/critereon/ItemSubPredicate$Type;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SyringeGenesPredicate blackDeath(@NotNull HolderLookup.Provider lookup) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            Holder.Reference<Gene> blackDeathGeneHolder = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.INSTANCE.getBLACK_DEATH(), lookup);
            Holder[] holderArray = new Holder[]{blackDeathGeneHolder};
            HolderSet.Direct direct = HolderSet.direct((Holder[])holderArray);
            Intrinsics.checkNotNullExpressionValue((Object)direct, (String)"direct(...)");
            return new SyringeGenesPredicate((HolderSet<Gene>)((HolderSet)direct), false);
        }

        @NotNull
        public final Codec<SyringeGenesPredicate> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final ItemSubPredicate.Type<SyringeGenesPredicate> getTYPE() {
            return TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

