/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe.provider;

import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.recipe.provider.IndustrialSerializableProvider;
import com.hrznstudio.titanium.api.IRecipeProvider;
import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapelessRecipeBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.DeferredHolder;

public class IndustrialRecipeProvider
extends RecipeProvider {
    private final Lazy<List<Block>> blocks;

    public IndustrialRecipeProvider(DataGenerator generator, Lazy<List<Block>> blocksToProcess, CompletableFuture<HolderLookup.Provider> prov) {
        super(generator.getPackOutput(), prov);
        this.blocks = blocksToProcess;
    }

    public void buildRecipes(RecipeOutput consumer) {
        ((List)this.blocks.get()).stream().filter(block -> block instanceof BasicBlock).map(block -> (BasicBlock)block).forEach(blockBase -> blockBase.registerRecipe(consumer));
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ModuleCore.PINK_SLIME_BLOCK.get())).pattern("PPP").pattern("PPP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)ModuleCore.PINK_SLIME_ITEM.get()).save(consumer);
        TitaniumShapelessRecipeBuilder.shapelessRecipe((ItemLike)((ItemLike)ModuleCore.PINK_SLIME_ITEM.get()), (int)9).requires((ItemLike)ModuleCore.PINK_SLIME_BLOCK.get()).save(consumer);
        ConveyorUpgradeFactory.FACTORIES.forEach(conveyorUpgradeFactory -> conveyorUpgradeFactory.registerRecipe(consumer));
        TransporterTypeFactory.FACTORIES.forEach(typeFactory -> typeFactory.registerRecipe(consumer));
        ((IRecipeProvider)ModuleTool.MOB_IMPRISONMENT_TOOL.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.MEAT_FEEDER.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.INFINITY_DRILL.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.INFINITY_SAW.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.INFINITY_HAMMER.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.INFINITY_TRIDENT.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.INFINITY_BACKPACK.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.INFINITY_LAUNCHER.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleTool.INFINITY_NUKE.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleCore.STRAW.get()).registerRecipe(consumer);
        for (DeferredHolder<Item, Item> deferredHolder : ModuleCore.RANGE_ADDONS) {
            ((IRecipeProvider)deferredHolder.get()).registerRecipe(consumer);
        }
        ((IRecipeProvider)ModuleCore.SPEED_ADDON_1.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleCore.SPEED_ADDON_2.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleCore.EFFICIENCY_ADDON_1.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleCore.EFFICIENCY_ADDON_2.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleCore.PROCESSING_ADDON_1.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleCore.PROCESSING_ADDON_2.get()).registerRecipe(consumer);
        ((IRecipeProvider)ModuleCore.MACHINE_SETTINGS_COPIER.get()).registerRecipe(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModuleCore.DRY_RUBBER.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModuleCore.PLASTIC.get()), (float)0.3f, (int)200).unlockedBy("has_plastic", IndustrialRecipeProvider.has((ItemLike)((ItemLike)ModuleCore.DRY_RUBBER.get()))).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ModuleCore.PITY.get())).pattern("WIW").pattern("IRI").pattern("WIW").define(Character.valueOf('W'), ItemTags.LOGS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), Tags.Items.STORAGE_BLOCKS_REDSTONE).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ModuleCore.IRON_GEAR.get())).pattern(" P ").pattern("P P").pattern(" P ").define(Character.valueOf('P'), (ItemLike)Items.IRON_INGOT).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ModuleCore.GOLD_GEAR.get())).pattern(" P ").pattern("P P").pattern(" P ").define(Character.valueOf('P'), (ItemLike)Items.GOLD_INGOT).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ModuleCore.DIAMOND_GEAR.get())).pattern(" P ").pattern("P P").pattern(" P ").define(Character.valueOf('P'), (ItemLike)Items.DIAMOND).save(consumer);
        for (DeferredHolder<Item, Item> deferredHolder : ModuleCore.LASER_LENS) {
            ((IRecipeProvider)deferredHolder.get()).registerRecipe(consumer);
        }
        for (DeferredHolder<Item, Item> deferredHolder : DyeColor.values()) {
            TitaniumShapelessRecipeBuilder.shapelessRecipe((ItemLike)((ItemLike)ModuleCore.LASER_LENS[deferredHolder.getId()].get())).requires(Ingredient.of(Arrays.stream(ModuleCore.LASER_LENS).map(itemRegistryObject -> new ItemStack((ItemLike)itemRegistryObject.get())).collect(Collectors.toList()).stream())).requires(deferredHolder.getTag()).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("laser_lens_" + deferredHolder.getSerializedName() + "_recolor")));
        }
        IndustrialSerializableProvider.init(consumer);
    }
}

