/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidExtractorRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<FluidExtractorRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Ingredient.CODEC.fieldOf("input").forGetter(o -> o.input), (App)BlockState.CODEC.fieldOf("result").forGetter(o -> o.result), (App)Codec.FLOAT.fieldOf("breakChance").forGetter(o -> Float.valueOf(o.breakChance)), (App)FluidStack.CODEC.fieldOf("output").forGetter(o -> o.output), (App)Codec.BOOL.fieldOf("defaultRecipe").forGetter(o -> o.defaultRecipe)).apply((Applicative)in, FluidExtractorRecipe::new));
    public Ingredient input;
    public BlockState result;
    public float breakChance;
    public FluidStack output;
    public boolean defaultRecipe;

    public FluidExtractorRecipe(Ingredient input, BlockState result, float breakChance, FluidStack output, boolean defaultRecipe) {
        this.input = input;
        this.result = result;
        this.breakChance = breakChance;
        this.output = output;
        this.defaultRecipe = defaultRecipe;
    }

    public FluidExtractorRecipe() {
    }

    public static void init(RecipeOutput output) {
        FluidExtractorRecipe.createRecipe(output, "acacia", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.ACACIA_LOG)}), Blocks.STRIPPED_ACACIA_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 4), false));
        FluidExtractorRecipe.createRecipe(output, "mangrove", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.MANGROVE_LOG)}), Blocks.STRIPPED_MANGROVE_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 4), false));
        FluidExtractorRecipe.createRecipe(output, "dark_oak", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.DARK_OAK_LOG)}), Blocks.STRIPPED_DARK_OAK_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 3), false));
        FluidExtractorRecipe.createRecipe(output, "cherry", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.CHERRY_LOG)}), Blocks.STRIPPED_CHERRY_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 3), false));
        FluidExtractorRecipe.createRecipe(output, "oak", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.OAK_LOG)}), Blocks.STRIPPED_OAK_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false));
        FluidExtractorRecipe.createRecipe(output, "spruce", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.SPRUCE_LOG)}), Blocks.STRIPPED_SPRUCE_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false));
        FluidExtractorRecipe.createRecipe(output, "birch", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BIRCH_LOG)}), Blocks.STRIPPED_BIRCH_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false));
        FluidExtractorRecipe.createRecipe(output, "jungle", new FluidExtractorRecipe(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.JUNGLE_LOG)}), Blocks.STRIPPED_JUNGLE_LOG.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false));
        FluidExtractorRecipe.createRecipe(output, "default", new FluidExtractorRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Blocks.AIR.defaultBlockState(), 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1), true));
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, FluidExtractorRecipe recipe) {
        ResourceLocation rl = FluidExtractorRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("fluid_extractor/" + key));
    }

    public boolean matches(Level world, BlockPos pos) {
        return this.input.test(new ItemStack((ItemLike)world.getBlockState(pos).getBlock()));
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModuleCore.FLUID_EXTRACTOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.FLUID_EXTRACTOR_TYPE.get();
    }
}

