/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.util.TagUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class CrusherRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<CrusherRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Ingredient.CODEC.fieldOf("input").forGetter(crusherRecipe -> crusherRecipe.input), (App)Ingredient.CODEC.fieldOf("output").forGetter(crusherRecipe -> crusherRecipe.output)).apply((Applicative)in, CrusherRecipe::new));
    public Ingredient input;
    public Ingredient output;
    private ResourceLocation isTag;

    public CrusherRecipe(Ingredient input, Ingredient output) {
        this(input, output, null);
    }

    public CrusherRecipe(Ingredient input, Ingredient output, ResourceLocation isTag) {
        this.input = input;
        this.output = output;
        this.isTag = isTag;
    }

    public CrusherRecipe() {
    }

    public static void init(RecipeOutput output) {
        CrusherRecipe.createRecipe(output, "cobblestone", new CrusherRecipe(Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"cobblestones/normal"))), Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL})));
        CrusherRecipe.createRecipe(output, "gravel", new CrusherRecipe(Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gravels"))), Ingredient.of((ItemLike[])new ItemLike[]{Items.SAND})));
        CrusherRecipe.createRecipe(output, "sand", new CrusherRecipe(Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sand"))), Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"silicon"))), ResourceLocation.fromNamespaceAndPath((String)"c", (String)"silicons")));
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, CrusherRecipe recipe) {
        ResourceLocation rl = CrusherRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        ArrayList<NotCondition> conditions = new ArrayList<NotCondition>();
        if (recipe.isTag != null) {
            conditions.add(new NotCondition((ICondition)new TagEmptyCondition(recipe.isTag)));
        }
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, conditions.toArray(new ICondition[conditions.size()]));
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("crusher/" + key));
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModuleCore.CRUSHER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.CRUSHER_TYPE.get();
    }
}

