/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei;

import com.buuz135.industrial.api.recipe.ore.OreFluidEntryFermenter;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryRaw;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntrySieve;
import com.buuz135.industrial.block.generator.MycelialGeneratorBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.fluid.OreTitaniumFluidType;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.plugin.RecipeViewerHelper;
import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.plugin.jei.category.BioReactorRecipeCategory;
import com.buuz135.industrial.plugin.jei.category.DissolutionChamberCategory;
import com.buuz135.industrial.plugin.jei.category.FermentationStationCategory;
import com.buuz135.industrial.plugin.jei.category.FluidExtractorCategory;
import com.buuz135.industrial.plugin.jei.category.FluidSieveCategory;
import com.buuz135.industrial.plugin.jei.category.LaserDrillFluidCategory;
import com.buuz135.industrial.plugin.jei.category.LaserDrillOreCategory;
import com.buuz135.industrial.plugin.jei.category.OreWasherCategory;
import com.buuz135.industrial.plugin.jei.category.StoneWorkCategory;
import com.buuz135.industrial.plugin.jei.category.StoneWorkGeneratorCategory;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorCategory;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.plugin.jei.machineproduce.MachineProduceCategory;
import com.buuz135.industrial.plugin.jei.machineproduce.MachineProduceWrapper;
import com.buuz135.industrial.plugin.jei.subtype.AddonSubtypeInterpreter;
import com.buuz135.industrial.plugin.jei.subtype.InfinitySubtypeInterpreter;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

@JeiPlugin
public class JEICustomPlugin
implements IModPlugin {
    private static IRecipesGui recipesGui;
    private BioReactorRecipeCategory bioReactorRecipeCategory;
    private LaserDrillOreCategory laserRecipeOreCategory;
    private LaserDrillFluidCategory laserDrillFluidCategory;
    private FluidExtractorCategory fluidExtractorCategory;
    private DissolutionChamberCategory dissolutionChamberJEICategory;
    private List<MycelialGeneratorCategory> mycelialGeneratorCategories;
    private StoneWorkCategory stoneWorkCategory;
    private MachineProduceCategory machineProduceCategory;
    private StoneWorkGeneratorCategory stoneWorkGeneratorCategory;
    private OreWasherCategory oreWasherCategory;
    private FermentationStationCategory fermentationStationCategory;
    private FluidSieveCategory fluidSieveCategory;

    public static void showUses(ItemStack stack) {
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        List.of((Item)ModuleTool.INFINITY_DRILL.get(), (Item)ModuleTool.INFINITY_SAW.get(), (Item)ModuleTool.INFINITY_HAMMER.get(), (Item)ModuleTool.INFINITY_TRIDENT.get(), (Item)ModuleTool.INFINITY_BACKPACK.get(), (Item)ModuleTool.INFINITY_LAUNCHER.get(), (Item)ModuleTool.INFINITY_NUKE.get()).forEach(item -> registration.registerSubtypeInterpreter(item, (ISubtypeInterpreter)new InfinitySubtypeInterpreter()));
        Arrays.stream(ModuleCore.RANGE_ADDONS).forEach(itemItemDeferredHolder -> registration.registerSubtypeInterpreter((Item)itemItemDeferredHolder.get(), (ISubtypeInterpreter)new AddonSubtypeInterpreter()));
        List.of((Item)ModuleCore.EFFICIENCY_ADDON_1.get(), (Item)ModuleCore.EFFICIENCY_ADDON_2.get(), (Item)ModuleCore.SPEED_ADDON_1.get(), (Item)ModuleCore.SPEED_ADDON_2.get(), (Item)ModuleCore.PROCESSING_ADDON_1.get()).forEach(item -> registration.registerSubtypeInterpreter(item, (ISubtypeInterpreter)new AddonSubtypeInterpreter()));
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(GuiConveyor.class, (IGhostIngredientHandler)new IGhostIngredientHandler<GuiConveyor>(this){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(GuiConveyor guiConveyor, ITypedIngredient<I> i, boolean b) {
                if (i.getIngredient() instanceof ItemStack) {
                    return guiConveyor.getGhostSlots().stream().map(ghostSlot -> new IGhostIngredientHandler.Target<I>(){
                        final /* synthetic */ IFilter.GhostSlot val$ghostSlot;
                        {
                            this.val$ghostSlot = ghostSlot;
                        }

                        public Rect2i getArea() {
                            return this.val$ghostSlot.getArea();
                        }

                        public void accept(I stack) {
                            this.val$ghostSlot.accept((ItemStack)stack);
                        }
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
        registration.addGhostIngredientHandler(GuiTransporter.class, (IGhostIngredientHandler)new IGhostIngredientHandler<GuiTransporter>(this){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(GuiTransporter guiConveyor, ITypedIngredient<I> i, boolean b) {
                if (i.getIngredient() instanceof ItemStack) {
                    return guiConveyor.getGhostSlots().stream().map(ghostSlot -> new IGhostIngredientHandler.Target<I>(){
                        final /* synthetic */ IFilter.GhostSlot val$ghostSlot;
                        {
                            this.val$ghostSlot = ghostSlot;
                        }

                        public Rect2i getArea() {
                            return this.val$ghostSlot.getArea();
                        }

                        public void accept(I stack) {
                            this.val$ghostSlot.accept((ItemStack)stack);
                        }
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.bioReactorRecipeCategory = new BioReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Bioreactor accepted items");
        registry.addRecipeCategories(new IRecipeCategory[]{this.bioReactorRecipeCategory});
        this.fluidExtractorCategory = new FluidExtractorCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fluidExtractorCategory});
        this.dissolutionChamberJEICategory = new DissolutionChamberCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.dissolutionChamberJEICategory});
        this.laserRecipeOreCategory = new LaserDrillOreCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserRecipeOreCategory});
        this.laserDrillFluidCategory = new LaserDrillFluidCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserDrillFluidCategory});
        this.mycelialGeneratorCategories = new ArrayList<MycelialGeneratorCategory>();
        for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
            MycelialGeneratorCategory category = new MycelialGeneratorCategory(type, registry.getJeiHelpers().getGuiHelper());
            this.mycelialGeneratorCategories.add(category);
            registry.addRecipeCategories(new IRecipeCategory[]{category});
        }
        this.stoneWorkCategory = new StoneWorkCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.stoneWorkCategory});
        this.machineProduceCategory = new MachineProduceCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.machineProduceCategory});
        this.stoneWorkGeneratorCategory = new StoneWorkGeneratorCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.stoneWorkGeneratorCategory});
        this.oreWasherCategory = new OreWasherCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.oreWasherCategory});
        this.fermentationStationCategory = new FermentationStationCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fermentationStationCategory});
        this.fluidSieveCategory = new FluidSieveCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fluidSieveCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(IndustrialRecipeTypes.FLUID_EXTRACTOR, RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.FLUID_EXTRACTOR_TYPE.get())));
        registration.addRecipes(IndustrialRecipeTypes.DISSOLUTION, RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.DISSOLUTION_TYPE.get())));
        registration.addRecipes(IndustrialRecipeTypes.BIOREACTOR, RecipeViewerHelper.generateBioreactorRecipes());
        registration.addRecipes(IndustrialRecipeTypes.LASER_ORE, RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.LASER_DRILL_TYPE.get())).stream().filter(laserDrillOreRecipe -> !laserDrillOreRecipe.output.isEmpty()).collect(Collectors.toList()));
        registration.addRecipes(IndustrialRecipeTypes.LASER_FLUID, RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get())));
        for (int i = 0; i < IMycelialGeneratorType.TYPES.size(); ++i) {
            registration.addRecipes(this.mycelialGeneratorCategories.get(i).getRecipeType(), IMycelialGeneratorType.TYPES.get(i).getRecipes(IFAttachments.registryAccess()).stream().sorted(Comparator.comparingInt(value -> ((MycelialGeneratorRecipe)value).getTicks() * ((MycelialGeneratorRecipe)value).getPowerTick()).reversed()).collect(Collectors.toList()));
        }
        registration.addRecipes(IndustrialRecipeTypes.STONE_WORK, RecipeViewerHelper.getStoneWork());
        registration.addRecipes(this.machineProduceCategory.getRecipeType(), Arrays.asList(new MachineProduceWrapper(ModuleCore.LATEX_PROCESSING.getBlock(), new ItemStack((ItemLike)ModuleCore.DRY_RUBBER.get())), new MachineProduceWrapper(ModuleResourceProduction.SLUDGE_REFINER.getBlock(), IndustrialTags.Items.SLUDGE_OUTPUT), new MachineProduceWrapper(ModuleAgricultureHusbandry.SEWAGE_COMPOSTER.getBlock(), new ItemStack((ItemLike)ModuleCore.FERTILIZER.get())), new MachineProduceWrapper(ModuleResourceProduction.DYE_MIXER.getBlock(), (TagKey<Item>)Tags.Items.DYES), new MachineProduceWrapper(ModuleResourceProduction.SPORES_RECREATOR.getBlock(), (TagKey<Item>)Tags.Items.MUSHROOMS), new MachineProduceWrapper(ModuleResourceProduction.SPORES_RECREATOR.getBlock(), new ItemStack((ItemLike)Items.CRIMSON_FUNGUS), new ItemStack((ItemLike)Items.WARPED_FUNGUS)), new MachineProduceWrapper(ModuleAgricultureHusbandry.MOB_CRUSHER.getBlock(), new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), 1000)), new MachineProduceWrapper(ModuleAgricultureHusbandry.SLAUGHTER_FACTORY.getBlock(), new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), 1000)), new MachineProduceWrapper(ModuleAgricultureHusbandry.SLAUGHTER_FACTORY.getBlock(), new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 1000)), new MachineProduceWrapper(ModuleAgricultureHusbandry.ANIMAL_RANCHER.getBlock(), new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000)), new MachineProduceWrapper(ModuleAgricultureHusbandry.SEWER.getBlock(), new FluidStack((Fluid)ModuleCore.SEWAGE.getSourceFluid().get(), 1000)), new MachineProduceWrapper(ModuleAgricultureHusbandry.PLANT_GATHERER.getBlock(), new FluidStack((Fluid)ModuleCore.SLUDGE.getSourceFluid().get(), 1000)), new MachineProduceWrapper(ModuleResourceProduction.WATER_CONDENSATOR.getBlock(), new FluidStack((Fluid)Fluids.WATER, 1000))));
        registration.addRecipes(IndustrialRecipeTypes.STONE_WORK_GENERATOR, RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get())));
        ArrayList washer = new ArrayList();
        ArrayList fluidEntryFermenters = new ArrayList();
        ArrayList fluidSieve = new ArrayList();
        BuiltInRegistries.ITEM.getTagNames().map(itemTagKey -> itemTagKey.location()).filter(resourceLocation -> resourceLocation.toString().startsWith("c:raw_materials/") && OreTitaniumFluidType.isValid(resourceLocation)).forEach(resourceLocation -> {
            TagKey tag = TagUtil.getItemTag((ResourceLocation)resourceLocation);
            TagKey dust = TagUtil.getItemTag((ResourceLocation)ResourceLocation.parse((String)resourceLocation.toString().replace("c:raw_materials/", "c:dusts/")));
            washer.add(new OreFluidEntryRaw((TagKey<Item>)tag, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), 100), OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation)));
            fluidEntryFermenters.add(new OreFluidEntryFermenter(OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation), OreTitaniumFluidType.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 200, resourceLocation)));
            fluidSieve.add(new OreFluidEntrySieve(OreTitaniumFluidType.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 100, resourceLocation), TagUtil.getItemWithPreference((TagKey)dust), (TagKey<Item>)ItemTags.SAND));
        });
        registration.addRecipes(IndustrialRecipeTypes.ORE_WASHER, washer);
        registration.addRecipes(IndustrialRecipeTypes.FERMENTER, fluidEntryFermenters);
        registration.addRecipes(IndustrialRecipeTypes.ORE_SIEVE, fluidSieve);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleCore.FLUID_EXTRACTOR.getBlock()), new RecipeType[]{IndustrialRecipeTypes.FLUID_EXTRACTOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleCore.DISSOLUTION_CHAMBER.getBlock()), new RecipeType[]{IndustrialRecipeTypes.DISSOLUTION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleGenerator.BIOREACTOR.getBlock()), new RecipeType[]{IndustrialRecipeTypes.BIOREACTOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.ORE_LASER_BASE.getBlock()), new RecipeType[]{IndustrialRecipeTypes.LASER_ORE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.LASER_DRILL.getBlock()), new RecipeType[]{IndustrialRecipeTypes.LASER_ORE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.FLUID_LASER_BASE.getBlock()), new RecipeType[]{IndustrialRecipeTypes.LASER_FLUID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.LASER_DRILL.getBlock()), new RecipeType[]{IndustrialRecipeTypes.LASER_FLUID});
        for (BlockWithTile mycelialGenerator : ModuleGenerator.MYCELIAL_GENERATORS) {
            for (MycelialGeneratorCategory mycelialGeneratorCategory : this.mycelialGeneratorCategories) {
                if (!((MycelialGeneratorBlock)mycelialGenerator.getBlock()).getType().equals(mycelialGeneratorCategory.getType())) continue;
                registration.addRecipeCatalyst(new ItemStack((ItemLike)mycelialGenerator.getBlock()), new RecipeType[]{mycelialGeneratorCategory.getRecipeType()});
            }
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY.getBlock()), new RecipeType[]{this.stoneWorkCategory.getRecipeType(), this.stoneWorkGeneratorCategory.getRecipeType()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.POTION_BREWER.getBlock()), new RecipeType[]{RecipeTypes.BREWING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleMisc.ENCHANTMENT_APPLICATOR.getBlock()), new RecipeType[]{RecipeTypes.ANVIL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.RESOURCEFUL_FURNACE.getBlock()), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.WASHING_FACTORY.getBlock()), new RecipeType[]{IndustrialRecipeTypes.ORE_WASHER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.FERMENTATION_STATION.getBlock()), new RecipeType[]{IndustrialRecipeTypes.FERMENTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModuleResourceProduction.FLUID_SIEVING_MACHINE.getBlock()), new RecipeType[]{IndustrialRecipeTypes.ORE_SIEVE});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"default");
    }
}

