/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.emi.recipe;

import com.buuz135.industrial.plugin.emi.IFEmiPlugin;
import com.buuz135.industrial.plugin.emi.recipe.CustomEmiRecipe;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;

public class LaserDrillFluidEmiRecipe
extends CustomEmiRecipe {
    private final RecipeHolder<LaserDrillFluidRecipe> recipe;

    public LaserDrillFluidEmiRecipe(RecipeHolder<LaserDrillFluidRecipe> recipe) {
        super(recipe.id(), IFEmiPlugin.LASER_DRILL_FLUID_EMI_CATEGORY, List.of(), LaserDrillFluidEmiRecipe.fromOutput(NeoForgeEmiStack.of((FluidStack)((LaserDrillFluidRecipe)recipe.value()).output)));
        this.recipe = recipe;
    }

    public int getDisplayWidth() {
        return 152;
    }

    public int getDisplayHeight() {
        return 86;
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of((Ingredient)((LaserDrillFluidRecipe)this.recipe.value()).catalyst));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.getCatalysts().get(0), 36, 5).drawBack(false);
        widgets.addTank((EmiIngredient)this.getOutputs().get(0), 100, 5, 14, 15, 50).drawBack(false).recipeContext((EmiRecipe)this);
        widgets.addDrawable(0, 0, 0, 0, (draw, mouseX, mouseY, delta) -> {
            int recipeWidth = 152;
            RenderSystem.enableBlend();
            ResourceLocation toasts = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"toast/tree");
            int n = recipeWidth / 10 * 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            draw.blitSprite(toasts, n, 30 + (9 + 2) * 3, 20, 20);
            int n2 = recipeWidth / 10 * 7;
            Objects.requireNonNull(Minecraft.getInstance().font);
            draw.blitSprite(toasts, n2, 30 + (9 + 2) * 3, 20, 20);
            ResourceLocation icons = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"textures/gui/icons.png");
            int n3 = recipeWidth / 10 * 7 + 1;
            Objects.requireNonNull(Minecraft.getInstance().font);
            draw.blit(icons, n3, 30 + (9 + 2) * 3 + 3, 0, 16, 16, 16);
            String minY = Component.translatable((String)"text.industrialforegoing.miny").getString() + " " + ((LaserDrillFluidRecipe)this.recipe.value()).rarity.get(((LaserDrillFluidRecipe)this.recipe.value()).pointer).depth_min();
            String maxY = Component.translatable((String)"text.industrialforegoing.maxy").getString() + " " + ((LaserDrillFluidRecipe)this.recipe.value()).rarity.get(((LaserDrillFluidRecipe)this.recipe.value()).pointer).depth_max();
            String biomes = Component.translatable((String)"text.industrialforegoing.requirements").getString();
            draw.drawString(Minecraft.getInstance().font, String.valueOf(ChatFormatting.DARK_GRAY) + minY, recipeWidth / 10, 30, 0, false);
            if (!LaserDrillFluidRecipe.EMPTY.equals((Object)((LaserDrillFluidRecipe)this.recipe.value()).entity)) {
                String wight = "Over: " + Component.translatable((String)("entity." + ((LaserDrillFluidRecipe)this.recipe.value()).entity.toString().replace(":", "."))).getString();
                Font font = Minecraft.getInstance().font;
                String string = String.valueOf(ChatFormatting.DARK_GRAY) + wight;
                int n4 = recipeWidth / 10;
                Objects.requireNonNull(Minecraft.getInstance().font);
                draw.drawString(font, string, n4, 30 + (9 + 2), 0, false);
            }
            draw.drawString(Minecraft.getInstance().font, String.valueOf(ChatFormatting.DARK_GRAY) + maxY, recipeWidth / 10 * 6, 30, 0, false);
            Font font = Minecraft.getInstance().font;
            String string = String.valueOf(ChatFormatting.DARK_GRAY) + String.valueOf(ChatFormatting.UNDERLINE) + biomes;
            int n5 = recipeWidth / 2 - Minecraft.getInstance().font.width(biomes) / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            draw.drawString(font, string, n5, 30 + (9 + 2) * 2, 0, false);
            ArrayList<Component> components = new ArrayList<Component>();
            this.getTooltip(components, (LaserDrillFluidRecipe)this.recipe.value(), mouseX, mouseY);
            draw.renderComponentTooltip(Minecraft.getInstance().font, components, mouseX, mouseY);
            AssetUtil.drawAsset((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL), (int)98, (int)3);
        });
        widgets.addButton(0, 70, 12, 12, 0, 0, () -> ((LaserDrillFluidRecipe)this.recipe.value()).pointer > 0, (mouseX, mouseY, button) -> {
            if (((LaserDrillFluidRecipe)this.recipe.value()).pointer > 0) {
                --((LaserDrillFluidRecipe)this.recipe.value()).pointer;
            }
        });
        widgets.addButton(137, 70, 12, 12, 12, 0, () -> ((LaserDrillFluidRecipe)this.recipe.value()).pointer < ((LaserDrillFluidRecipe)this.recipe.value()).rarity.size() - 1, (mouseX, mouseY, button) -> {
            if (((LaserDrillFluidRecipe)this.recipe.value()).pointer < ((LaserDrillFluidRecipe)this.recipe.value()).rarity.size() - 1) {
                ++((LaserDrillFluidRecipe)this.recipe.value()).pointer;
            }
        });
    }

    public void getTooltip(List<Component> tooltip, LaserDrillFluidRecipe recipe, double mouseX, double mouseY) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.button.jei.prev_rarity"));
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.size() - 1) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.button.jei.next_rarity"));
        }
        if (mouseX > 26.0 && mouseX < 46.0) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.whitelisted_dimensions").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (recipe.rarity.get(recipe.pointer).dimensionRarity().whitelist().isEmpty()) {
                        tooltip.add((Component)Component.literal((String)"- Any"));
                    } else {
                        for (ResourceKey<DimensionType> resourceKey : recipe.rarity.get(recipe.pointer).dimensionRarity().whitelist()) {
                            tooltip.add((Component)Component.literal((String)("- " + WordUtils.capitalize((String)Arrays.stream(resourceKey.location().getPath().split("_")).reduce((string, string2) -> string + " " + string2).get()))));
                        }
                    }
                    tooltip.add((Component)Component.empty());
                    tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.whitelisted_biomes").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (recipe.rarity.get(recipe.pointer).biomeRarity().whitelist().isEmpty()) {
                        tooltip.add((Component)Component.literal((String)"- Any"));
                    } else {
                        for (TagKey tagKey : recipe.rarity.get(recipe.pointer).biomeRarity().whitelist()) {
                            for (Holder biomeHolder : Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getTagOrEmpty(tagKey)) {
                                tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)("biome." + biomeHolder.getKey().location().getNamespace() + "." + biomeHolder.getKey().location().getPath()))));
                            }
                        }
                    }
                }
            }
        }
        if (mouseX > 104.0 && mouseX < 124.0) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.blacklisted_dimensions").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (recipe.rarity.get(recipe.pointer).dimensionRarity().blacklist().isEmpty()) {
                        tooltip.add((Component)Component.literal((String)"- None"));
                    } else {
                        for (ResourceKey<DimensionType> resourceKey : recipe.rarity.get(recipe.pointer).dimensionRarity().blacklist()) {
                            tooltip.add((Component)Component.literal((String)("- " + WordUtils.capitalize((String)Arrays.stream(resourceKey.location().getPath().split("_")).reduce((string, string2) -> string + " " + string2).get()))));
                        }
                    }
                    tooltip.add((Component)Component.empty());
                    tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.blacklisted_biomes").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (recipe.rarity.get(recipe.pointer).biomeRarity().blacklist().isEmpty()) {
                        tooltip.add((Component)Component.literal((String)"- None"));
                    } else {
                        for (TagKey tagKey : recipe.rarity.get(recipe.pointer).biomeRarity().blacklist()) {
                            for (Holder biomeHolder : Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getTagOrEmpty(tagKey)) {
                                tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)("biome." + biomeHolder.getKey().location().getNamespace() + "." + biomeHolder.getKey().location().getPath()))));
                            }
                        }
                    }
                }
            }
        }
    }
}

