/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.emi.recipe;

import com.buuz135.industrial.block.core.tile.DissolutionChamberTile;
import com.buuz135.industrial.config.machine.core.DissolutionChamberConfig;
import com.buuz135.industrial.plugin.emi.IFEmiPlugin;
import com.buuz135.industrial.plugin.emi.recipe.CustomEmiRecipe;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class DissChamberEmiRecipe
extends CustomEmiRecipe {
    private final RecipeHolder<DissolutionChamberRecipe> recipe;

    public DissChamberEmiRecipe(RecipeHolder<DissolutionChamberRecipe> recipe) {
        super(recipe.id(), IFEmiPlugin.DISSOLUTION_CHAMBER_EMI_CATEGORY, DissChamberEmiRecipe.combineIng(DissChamberEmiRecipe.fromInputDiss(((DissolutionChamberRecipe)recipe.value()).input), DissChamberEmiRecipe.fromInput(((DissolutionChamberRecipe)recipe.value()).inputFluid)), DissChamberEmiRecipe.fromOutputDiss(((DissolutionChamberRecipe)recipe.value()).output.orElse(ItemStack.EMPTY), ((DissolutionChamberRecipe)recipe.value()).outputFluid.orElse(FluidStack.EMPTY)));
        this.recipe = recipe;
    }

    public static List<EmiIngredient> fromInputDiss(List<Ingredient> ingredients) {
        ArrayList<Ingredient> result = new ArrayList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack item : ingredient.getItems()) {
                item.getItem().onCraftedBy(item, null, null);
                stacks.add(item);
            }
            result.add(Ingredient.of((ItemStack[])stacks.toArray(new ItemStack[0])));
        }
        return result.stream().map(EmiIngredient::of).toList();
    }

    public static List<EmiStack> fromOutputDiss(ItemStack output, FluidStack fluidStack) {
        output.getItem().onCraftedBy(output, null, null);
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        list.add(EmiStack.of((ItemStack)output));
        list.add(EmiStack.of((Fluid)fluidStack.getFluid(), (DataComponentPatch)fluidStack.getComponentsPatch(), (long)fluidStack.getAmount()));
        return list;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return 82;
    }

    public void addWidgets(WidgetHolder widgets) {
        for (int i = 0; i < this.getInputs().size() - 1; ++i) {
            widgets.addSlot(this.getInputs().get(i), 23 + (Integer)DissolutionChamberTile.getSlotPos(i).getLeft(), 10 + (Integer)DissolutionChamberTile.getSlotPos(i).getRight());
        }
        widgets.addSlot(EmiIngredient.of(List.of(this.getOutputs().get(0))), 118, 15).recipeContext((EmiRecipe)this);
        widgets.addTank(this.getInputs().get(this.getInputs().size() - 1), 47, 34, 14, 15, 1000).drawBack(false);
        widgets.addTank((EmiIngredient)this.getOutputs().get(1), 141, 16, 14, 52, 1000).backgroundTexture(DefaultAssetProvider.DEFAULT_LOCATION, 180, 4).drawBack(false).recipeContext((EmiRecipe)this);
        widgets.addDrawable(0, 0, 0, 0, (draw, mouseX, mouseY, delta) -> {
            EnergyBarScreenAddon.drawBackground((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)0, (int)12, (int)0, (int)0);
            SlotsScreenAddon.drawAsset((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)24, (int)11, (int)0, (int)0, (int)8, DissolutionChamberTile::getSlotPos, integer -> ItemStack.EMPTY, (boolean)true, integer -> new Color(DyeColor.LIGHT_BLUE.getFireworkColor()), integer -> true, (int)1);
            SlotsScreenAddon.drawAsset((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)119, (int)16, (int)0, (int)0, (int)3, integer -> Pair.of((Object)(18 * (integer % 1)), (Object)(18 * (integer / 1))), integer -> ItemStack.EMPTY, (boolean)true, integer -> new Color(DyeColor.ORANGE.getFireworkColor()), integer -> true, (int)1);
            AssetUtil.drawAsset((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL), (int)45, (int)32);
            AssetUtil.drawAsset((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_NORMAL), (int)139, (int)14);
            AssetUtil.drawAsset((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAsset)IAssetProvider.getAsset((IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (IAssetType)AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_HORIZONTAL), (int)92, (int)33);
            int consumed = ((DissolutionChamberRecipe)this.recipe.value()).processingTime * DissolutionChamberConfig.powerPerTick;
            EnergyBarScreenAddon.drawForeground((GuiGraphics)draw, (Screen)Minecraft.getInstance().screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)0, (int)12, (int)0, (int)0, (double)consumed, (double)((int)Math.max(50000.0, Math.ceil(consumed))));
        });
        Rectangle rec = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.ENERGY_BACKGROUND).getArea();
        int consumed = ((DissolutionChamberRecipe)this.recipe.value()).processingTime * DissolutionChamberConfig.powerPerTick;
        widgets.addTooltipText(EnergyBarScreenAddon.getTooltip((int)consumed, (int)((int)Math.max(50000.0, Math.ceil(consumed)))), 0, 12, rec.width, rec.height);
    }
}

