/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.FacingUtil;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemInfinityHammer
extends ItemInfinity {
    public static HashMap<Class<?>, Function<Entity, ItemStack>> HEADS = new HashMap();
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;
    public static int DAMAGE = 10;
    public static float ATTACK_SPEED = -2.0f;
    public static String BEHEADING_NBT = "Beheading";

    public ItemInfinityHammer(TitaniumTab group) {
        super("infinity_hammer", group, new Item.Properties().stacksTo(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, true);
    }

    public static ItemStack createHead(GameProfile gameProfile) {
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(gameProfile));
        return stack;
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        stack.set(IFAttachments.INFINITY_HAMMER_BEHEADING, (Object)0);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return Items.DIAMOND_SWORD.supportsEnchantment(new ItemStack((ItemLike)Items.DIAMOND_SWORD), enchantment);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    @Override
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(Blocks.COBWEB)) {
            return 15.0f;
        }
        return 1.25f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        InfinityTier infinityTier = ItemInfinityHammer.getSelectedTier(stack);
        if (infinityTier.getRadius() > 1 && attacker instanceof Player) {
            AABB area = new AABB(target.getX(), target.getY(), target.getZ(), target.getX(), target.getY(), target.getZ()).inflate((double)infinityTier.getRadius());
            List mobs = attacker.getCommandSenderWorld().getEntitiesOfClass(Mob.class, new AABB(target.getX(), target.getY(), target.getZ(), target.getX(), target.getY(), target.getZ()).inflate((double)infinityTier.getRadius()));
            mobs.forEach(mobEntity -> {
                if (this.enoughFuel(stack)) {
                    mobEntity.hurt(target.damageSources().playerAttack((Player)attacker), (float)((double)DAMAGE + Math.pow(2.0, infinityTier.getRadius())) * 0.8f);
                    this.consumeFuel(stack);
                    if (mobEntity.getHealth() <= 0.0f && attacker.getCommandSenderWorld().random.nextDouble() <= (double)this.getCurrentBeheading(stack) * 0.15) {
                        ItemStack head = HEADS.getOrDefault(mobEntity.getClass(), entity -> ItemStack.EMPTY).apply((Entity)mobEntity);
                        Block.popResource((Level)attacker.level(), (BlockPos)attacker.blockPosition(), (ItemStack)head);
                    }
                }
            });
            attacker.getCommandSenderWorld().getEntitiesOfClass(ItemEntity.class, area.inflate(1.0)).forEach(itemEntity -> {
                itemEntity.setNoPickUpDelay();
                itemEntity.teleportTo((double)attacker.blockPosition().getX(), (double)(attacker.blockPosition().getY() + 1), (double)attacker.blockPosition().getZ());
            });
            attacker.getCommandSenderWorld().getEntitiesOfClass(ExperienceOrb.class, area.inflate(1.0)).forEach(entityXPOrb -> entityXPOrb.teleportTo((double)attacker.blockPosition().getX(), (double)attacker.blockPosition().getY(), (double)attacker.blockPosition().getZ()));
        }
        if (target.getHealth() <= 0.0f && target instanceof Player) {
            Block.popResource((Level)attacker.level(), (BlockPos)attacker.blockPosition(), (ItemStack)ItemInfinityHammer.createHead(((Player)target).getGameProfile()));
        }
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        InfinityTier infinityTier = ItemInfinityHammer.getSelectedTier(stack);
        Player player = context.getPlayer();
        if (infinityTier.getRadius() > 1) {
            Vec3[] all;
            Vec3 looking = player.getLookAngle();
            for (Vec3 vector3d : all = new Vec3[]{looking, looking.yRot(0.22f), looking.yRot(-0.22f)}) {
                float f = (float)Mth.atan2((double)vector3d.z, (double)vector3d.x);
                int i = 0;
                while ((double)i < (double)infinityTier.getRadius() * 1.5 + 1.0) {
                    double d2 = 1.25 * (double)(i + 1);
                    int j = 1;
                    this.spawnFangs((LivingEntity)player, player.getX() + (double)Mth.cos((float)f) * d2, player.getZ() + (double)Mth.sin((float)f) * d2, player.getY() - 1.0, player.getY() + 1.0, f, j);
                    this.consumeFuel(stack);
                    ++i;
                }
            }
            player.getCooldowns().addCooldown((Item)this, 12);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private void spawnFangs(LivingEntity caster, double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.below();
            BlockState blockstate = caster.level().getBlockState(blockpos1);
            if (!blockstate.isFaceSturdy((BlockGetter)caster.level(), blockpos1, Direction.UP)) continue;
            if (!caster.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = caster.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)caster.level(), blockpos)).isEmpty()) {
                d0 = voxelshape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (flag) {
            caster.level().addFreshEntity((Entity)new EvokerFangs(caster.level(), x, (double)blockpos.getY() + d0, z, rotation, delay, caster));
        }
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0f) {
            stack.hurtAndBreak(1, entityLiving, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState blockIn) {
        return blockIn.is(Blocks.COBWEB);
    }

    @Override
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers attributes = super.getDefaultAttributeModifiers(stack);
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityHammer.getPowerFromStack(stack)).getLeft());
        attributes = attributes.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"base_attack_damage"), (double)DAMAGE + Math.pow(2.0, infinityTier.getRadius()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        attributes = attributes.withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"base_attack_speed"), (double)ATTACK_SPEED, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return attributes;
    }

    public int getCurrentBeheading(ItemStack stack) {
        return (Integer)stack.getOrDefault(IFAttachments.INFINITY_HAMMER_BEHEADING, (Object)0);
    }

    public int getMaxBeheading(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityHammer.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius() - 2), 3);
    }

    public void setBeheading(ItemStack stack, int level) {
        stack.set(IFAttachments.INFINITY_HAMMER_BEHEADING, (Object)level);
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        String level = "0";
        switch (this.getCurrentBeheading(stack)) {
            case 1: {
                level = "I";
                break;
            }
            case 2: {
                level = "II";
                break;
            }
            case 3: {
                level = "III";
            }
        }
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.beheading").append(" " + level).withStyle(ChatFormatting.GRAY));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.display.beheading").append(": ").append(ItemInfinityHammer.this.getCurrentBeheading((ItemStack)stack.get()) + "/" + ItemInfinityHammer.this.getMaxBeheading((ItemStack)stack.get())).getString();
            }
        }));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.getItemInHand(InteractionHand.MAIN_HAND);
        int currentBeheading = this.getCurrentBeheading(stack);
        int maxBeheading = this.getMaxBeheading(stack);
        if (id == 5 && currentBeheading > 0) {
            this.setBeheading(stack, Math.max(currentBeheading - 1, 0));
        }
        if (id == 4 && currentBeheading < maxBeheading) {
            this.setBeheading(stack, Math.min(3, currentBeheading + 1));
        }
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        DissolutionChamberRecipe.createRecipe(consumer, "infinity_hammer", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_SWORD)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_AXE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())}), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD)), new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }

    static {
        HEADS.put(WitherSkeleton.class, entity -> new ItemStack((ItemLike)Blocks.WITHER_SKELETON_SKULL));
        HEADS.put(Skeleton.class, entity -> new ItemStack((ItemLike)Blocks.SKELETON_SKULL));
        HEADS.put(Zombie.class, entity -> new ItemStack((ItemLike)Blocks.ZOMBIE_HEAD));
        HEADS.put(Creeper.class, entity -> new ItemStack((ItemLike)Blocks.CREEPER_HEAD));
        HEADS.put(EnderDragon.class, entity -> new ItemStack((ItemLike)Blocks.DRAGON_HEAD));
    }
}

