/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.item.infinity.IInfinityDrillScreenAddons;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityTankStorage;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.IScreenInfoProvider;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.FacingUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinity
extends IFCustomItem
implements MenuProvider,
IButtonHandler,
IInfinityDrillScreenAddons,
ISpecialCreativeTabItem,
IScreenInfoProvider {
    private final int powerConsumption;
    private final int biofuelConsumption;
    private final boolean usesDepth;
    private boolean usesArea;

    public ItemInfinity(String name, TitaniumTab group, Item.Properties builder, int powerConsumption, int biofuelConsumption, boolean usesDepth) {
        super(name, group, builder);
        this.powerConsumption = powerConsumption;
        this.biofuelConsumption = biofuelConsumption;
        this.usesDepth = usesDepth;
        this.usesArea = true;
    }

    public static long getPowerFromStack(ItemStack stack) {
        return (Long)stack.getOrDefault(IFAttachments.INFINITY_ITEM_POWER, (Object)0L);
    }

    public void disableArea() {
        this.usesArea = false;
    }

    public String getFormattedArea(ItemStack stack, InfinityTier tier, int radius, boolean usesDepth) {
        int diameter = radius * 2 + 1;
        return diameter + "x" + diameter + "x" + (tier == InfinityTier.ARTIFACT || usesDepth ? diameter : 1);
    }

    public static InfinityTier getSelectedTier(ItemStack stack) {
        return (InfinityTier)((Object)stack.getOrDefault(IFAttachments.INFINITY_ITEM_SELECTED_TIER, (Object)InfinityTier.POOR));
    }

    public static boolean canCharge(ItemStack stack) {
        return (Boolean)stack.getOrDefault(IFAttachments.INFINITY_ITEM_CAN_CHARGE, (Object)false);
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
        this.addNbt(stack, 0L, 0, false);
    }

    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        stack.set(IFAttachments.INFINITY_ITEM_POWER, (Object)power);
        stack.set(IFAttachments.INFINITY_ITEM_SPECIAL, (Object)special);
        stack.set(IFAttachments.INFINITY_ITEM_SELECTED_TIER, (Object)((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getLeft())));
        stack.set(IFAttachments.INFINITY_ITEM_CAN_CHARGE, (Object)true);
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        for (InfinityTier value : InfinityTier.values()) {
            event.accept(this.createStack(value.getPowerNeeded(), 0, false));
        }
        event.accept(this.createStack(InfinityTier.ARTIFACT.getPowerNeeded(), 1000000, true));
    }

    public ItemStack createStack(long power, int fuel, boolean special) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.addNbt(stack, power, fuel, special);
        return stack;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 50;
    }

    public UseAnim getUseAnimation(ItemStack p_77661_1_) {
        return UseAnim.BOW;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged && !oldStack.equals(newStack);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return this.enoughFuel(stack) ? 10.0f : 0.0f;
    }

    public boolean isBarVisible(ItemStack p_150899_) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        Supplier<Supplier> checker = () -> () -> false;
        if (FMLEnvironment.dist.isClient()) {
            checker = () -> Screen::hasShiftDown;
        }
        if (!((Boolean)checker.get().get()).booleanValue()) {
            int fuel = this.getFuelFromStack(stack);
            return (int)Math.round((double)fuel * 13.0 / 1000000.0);
        }
        long power = ItemInfinity.getPowerFromStack(stack);
        return (int)Math.round((double)power * 13.0 / (double)((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getRight())).getPowerNeeded());
    }

    public int getBarColor(ItemStack p_150901_) {
        Supplier<Supplier> checker = () -> () -> false;
        if (FMLEnvironment.dist.isClient()) {
            checker = () -> Screen::hasShiftDown;
        }
        return (Boolean)checker.get().get() == false ? 13304063 : 53503;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        IFluidHandlerItem capability = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (capability != null) {
            for (int i = 0; i < capability.getTanks(); ++i) {
                if (!capability.getFluidInTank(i).is((Holder)ModuleCore.BIOFUEL.getSourceFluid())) continue;
                return capability.getFluidInTank(i).getAmount();
            }
        }
        return fuelAmount;
    }

    public boolean isSpecial(ItemStack stack) {
        return (Boolean)stack.getOrDefault(IFAttachments.INFINITY_ITEM_SPECIAL, (Object)false);
    }

    public boolean isSpecialEnabled(ItemStack stack) {
        return this.isSpecial(stack) && (Boolean)stack.getOrDefault(IFAttachments.INFINITY_ITEM_SPECIAL_ENABLED, (Object)false) != false;
    }

    public void setSpecialEnabled(ItemStack stack, boolean special) {
        if (this.isSpecial(stack)) {
            stack.set(IFAttachments.INFINITY_ITEM_SPECIAL_ENABLED, (Object)special);
        }
    }

    public boolean enoughFuel(ItemStack stack) {
        int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)IFAttachments.registryAccess().holderOrThrow(Enchantments.UNBREAKING), (ItemStack)stack);
        return (double)this.getFuelFromStack(stack) >= (double)this.biofuelConsumption * (1.0 / (double)(level + 1)) || (double)ItemInfinity.getPowerFromStack(stack) >= (double)this.powerConsumption * (1.0 / (double)(level + 1));
    }

    public void consumeFuel(ItemStack stack) {
        int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)IFAttachments.registryAccess().holderOrThrow(Enchantments.UNBREAKING), (ItemStack)stack);
        if ((double)this.getFuelFromStack(stack) >= (double)this.biofuelConsumption * (1.0 / (double)(level + 1))) {
            IFluidHandlerItem capability = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (capability != null) {
                for (int i = 0; i < capability.getTanks(); ++i) {
                    if (!capability.getFluidInTank(i).is((Holder)ModuleCore.BIOFUEL.getSourceFluid())) continue;
                    capability.drain(new FluidStack((Holder)ModuleCore.BIOFUEL.getSourceFluid(), this.biofuelConsumption * (1 / (level + 1))), IFluidHandler.FluidAction.EXECUTE);
                    return;
                }
            }
        } else {
            stack.set(IFAttachments.INFINITY_ITEM_POWER, (Object)((long)((double)((Long)stack.getOrDefault(IFAttachments.INFINITY_ITEM_POWER, (Object)0L)).longValue() - (double)this.powerConsumption * (1.0 / (double)(level + 1)))));
        }
    }

    public void setCanCharge(ItemStack stack, boolean canCharge) {
        stack.set(IFAttachments.INFINITY_ITEM_CAN_CHARGE, (Object)canCharge);
    }

    public void setSelectedDrillTier(ItemStack stack, InfinityTier tier) {
        stack.set(IFAttachments.INFINITY_ITEM_SELECTED_TIER, (Object)tier);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        long power = ItemInfinity.getPowerFromStack(stack);
        Pair<InfinityTier, InfinityTier> braquet = InfinityTier.getTierBraquet(power);
        InfinityTier current = ItemInfinity.getSelectedTier(stack);
        if (this.usesArea) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.current_area").append(" ").append(this.getFormattedArea(stack, current, current.getRadius(), this.usesDepth)).withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.tier").append(" " + String.valueOf(((InfinityTier)((Object)braquet.getLeft())).getColor()) + ((InfinityTier)((Object)braquet.getLeft())).getLocalizedName()).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.power").append(" ").append(String.valueOf(ChatFormatting.RED) + NumberFormat.getNumberInstance(Locale.ROOT).format(power) + String.valueOf(ChatFormatting.GREEN)).append("/").append(NumberFormat.getNumberInstance(Locale.ROOT).format(((InfinityTier)((Object)braquet.getRight())).getPowerNeeded())).append("RF ").append((Component)Component.translatable((String)"text.industrialforegoing.display.next_tier")).withStyle(ChatFormatting.GRAY));
        int fuelAmount = this.getFuelFromStack(stack);
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.fluid").append(" ").append(String.valueOf(ChatFormatting.LIGHT_PURPLE) + NumberFormat.getNumberInstance(Locale.ROOT).format(fuelAmount) + String.valueOf(ChatFormatting.GRAY)).append("/").append(NumberFormat.getNumberInstance(Locale.ROOT).format(1000000L)).append(" mb of Biofuel").withStyle(ChatFormatting.GRAY));
        if (this.usesArea) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.max_area").append(" ").append(this.getFormattedArea(stack, (InfinityTier)((Object)braquet.getLeft()), ((InfinityTier)((Object)braquet.getLeft())).getRadius(), this.usesDepth)).withStyle(ChatFormatting.GRAY));
        }
        if (ItemInfinity.canCharge(stack)) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.charging").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"text.industrialforegoing.display.enabled").withStyle(ChatFormatting.GREEN)));
        } else {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.charging").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"text.industrialforegoing.display.disabled").withStyle(ChatFormatting.RED)));
        }
        if (this.isSpecial(stack)) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.special").withStyle(ChatFormatting.GOLD));
        }
    }

    public Pair<BlockPos, BlockPos> getArea(BlockPos pos, Direction facing, InfinityTier currentTier, boolean withDepth) {
        int radius = currentTier.getRadius();
        BlockPos bottomLeft = pos.relative(facing.getAxis() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, radius).relative(facing.getAxis() == Direction.Axis.Y ? Direction.WEST : facing.getCounterClockWise(), radius);
        BlockPos topRight = pos.relative(facing.getAxis() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, radius).relative(facing.getAxis() == Direction.Axis.Y ? Direction.EAST : facing.getClockWise(), radius);
        if (facing.getAxis() != Direction.Axis.Y && radius > 0) {
            bottomLeft = bottomLeft.relative(Direction.UP, radius - 1);
            topRight = topRight.relative(Direction.UP, radius - 1);
        }
        if (currentTier == InfinityTier.ARTIFACT && withDepth) {
            topRight = topRight.relative(facing.getOpposite(), radius * 2);
        }
        return Pair.of((Object)bottomLeft, (Object)topRight);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers attributes = super.getDefaultAttributeModifiers(stack);
        attributes = attributes.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"base_attack_damage"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.ANY);
        attributes = attributes.withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"base_attack_speed"), -2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.ANY);
        return attributes;
    }

    public Component getDisplayName() {
        return this.getDescription().copy().withStyle(ChatFormatting.DARK_GRAY);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory p_createMenu_2_, Player playerEntity) {
        return new BasicAddonContainer((Object)ItemStackHarnessRegistry.createItemStackHarness((ItemStack)playerEntity.getMainHandItem()), (LocatorInstance)new HeldStackLocatorInstance(true), new ContainerLevelAccess(this){

            public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> p_221484_1_) {
                return Optional.empty();
            }
        }, playerEntity.getInventory(), menu);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        if (player.isCrouching()) {
            if (player instanceof ServerPlayer) {
                IndustrialForegoing.NETWORK.sendTo((Message)new BackpackOpenedMessage(player.getInventory().selected, PlayerInventoryFinder.MAIN), (ServerPlayer)player);
                player.openMenu((MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new HeldStackLocatorInstance(handIn == InteractionHand.MAIN_HAND)));
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(handIn));
        }
        if (IndustrialForegoing.CAT_EARS.getPlayers().contains(player.getUUID())) {
            player.getItemInHand(handIn).set(IFAttachments.INFINITY_ITEM_SPECIAL, (Object)true);
        }
        return super.use(worldIn, player, handIn);
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        ItemStack stack = playerEntity.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof ItemInfinity)) {
            stack = playerEntity.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (stack.getItem() instanceof ItemInfinity) {
            if (id == 1) {
                InfinityTier prev = ItemInfinity.getSelectedTier(stack).getPrev((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, prev);
            }
            if (id == 2) {
                InfinityTier next = ItemInfinity.getSelectedTier(stack).getNext((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, next);
            }
            if (id == 3) {
                this.setCanCharge(stack, !ItemInfinity.canCharge(stack));
            }
            if (id == -10) {
                this.setSpecialEnabled(stack, !this.isSpecialEnabled(stack));
            }
        }
    }

    public void registerRecipe(RecipeOutput consumer) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        ArrayList<IFactory<? extends IScreenAddon>> factory = new ArrayList<IFactory<? extends IScreenAddon>>();
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 20, 14, 14, FacingUtil.Sideness.RIGHT).setId(2)));
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 20, 14, 14, FacingUtil.Sideness.LEFT).setId(1)));
        factory.add(() -> new TextScreenAddon("", 72, 24, false){

            public String getText() {
                InfinityTier current = ItemInfinity.getSelectedTier((ItemStack)stack.get());
                return String.valueOf(ChatFormatting.DARK_GRAY) + "Area: " + ItemInfinity.this.getFormattedArea((ItemStack)stack.get(), current, current.getRadius(), ItemInfinity.this.usesDepth);
            }
        });
        factory.add(() -> new StateButtonAddon(this, new ButtonComponent(54, 36, 14, 14).setId(3), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

            public int getState() {
                return ItemInfinity.canCharge((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        factory.add(() -> new TextScreenAddon(this, "", 72, 40, false){

            public String getText() {
                if (ItemInfinity.canCharge((ItemStack)stack.get())) {
                    return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.display.charging").getString() + String.valueOf(ChatFormatting.GREEN) + Component.translatable((String)"text.industrialforegoing.display.enabled").getString();
                }
                return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.display.charging").getString() + String.valueOf(ChatFormatting.RED) + Component.translatable((String)"text.industrialforegoing.display.disabled").getString();
            }
        });
        if (this.isSpecial(stack.get())) {
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(12, 80, 14, 15).setId(-10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

                public int getState() {
                    return ItemInfinity.this.isSpecialEnabled((ItemStack)stack.get()) ? 0 : 1;
                }
            }));
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.industrialforegoing.display.special").getString(), 30, 84, false)));
        }
        return factory;
    }

    public IFactory<InfinityTankStorage> getTankConstructor(ItemStack stack) {
        return () -> new InfinityTankStorage(stack, new InfinityTankStorage.TankDefinition("biofuel", 1000000, 30, 20, fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get()), true, true, FluidTankComponent.Type.NORMAL));
    }

    public IFactory<InfinityEnergyStorage> getEnergyConstructor(final ItemStack stack) {
        return () -> new InfinityEnergyStorage(this, InfinityTier.ARTIFACT.getPowerNeeded(), 10, 20){

            @Override
            public long getLongEnergyStored() {
                return Math.min((Long)stack.getOrDefault(IFAttachments.INFINITY_ITEM_POWER, (Object)0L), InfinityTier.ARTIFACT.getPowerNeeded());
            }

            @Override
            public void setEnergyStored(long energy) {
                stack.set(IFAttachments.INFINITY_ITEM_POWER, (Object)Math.min(energy, InfinityTier.ARTIFACT.getPowerNeeded()));
            }

            @Override
            public boolean canReceive() {
                return ItemInfinity.canCharge(stack);
            }
        };
    }
}

