/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.gui.component.ItemStackTankScreenAddon;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class InfinityTankStorage
implements IFluidHandlerItem,
IScreenAddonProvider {
    private final ItemStack stack;
    private List<TankDefinition> tanks;
    private HashMap<String, FluidTank> tankMap;

    public InfinityTankStorage(ItemStack stack, TankDefinition ... tanks) {
        this.stack = stack;
        this.tanks = List.of(tanks);
        this.tankMap = new HashMap();
        CompoundTag component = (CompoundTag)stack.getOrDefault(IFAttachments.INFINITY_TANKS, (Object)new CompoundTag());
        for (TankDefinition tankDefinition : this.tanks) {
            FluidTank tank = new FluidTank(tankDefinition.capacity(), tankDefinition.filter());
            if (component.contains(tankDefinition.name())) {
                tank = tank.readFromNBT((HolderLookup.Provider)IFAttachments.registryAccess(), component.getCompound(tankDefinition.name()));
            }
            this.tankMap.put(tankDefinition.name(), tank);
        }
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    public int getTanks() {
        return this.tanks.size();
    }

    public FluidStack getFluidInTank(int i) {
        return this.tankMap.get(this.tanks.get(i).name()).getFluid();
    }

    public int getTankCapacity(int i) {
        return this.tanks.get(i).capacity();
    }

    public boolean isFluidValid(int i, FluidStack fluidStack) {
        return this.tankMap.get(this.tanks.get(i).name()).isFluidValid(fluidStack);
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        for (TankDefinition tankDefinition : this.tanks) {
            FluidTank tank;
            int filled;
            if (!tankDefinition.insert() || (filled = (tank = this.tankMap.get(tankDefinition.name())).fill(fluidStack, fluidAction)) <= 0) continue;
            if (fluidAction.execute()) {
                this.save();
            }
            return filled;
        }
        return 0;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        for (TankDefinition tankDefinition : this.tanks) {
            FluidTank tank;
            FluidStack drained;
            if (!tankDefinition.extract() || (drained = (tank = this.tankMap.get(tankDefinition.name())).drain(fluidStack, fluidAction)).isEmpty()) continue;
            if (fluidAction.execute()) {
                this.save();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        for (TankDefinition tankDefinition : this.tanks) {
            FluidTank tank;
            FluidStack drained;
            if (!tankDefinition.extract() || (drained = (tank = this.tankMap.get(tankDefinition.name())).drain(i, fluidAction)).isEmpty()) continue;
            if (fluidAction.execute()) {
                this.save();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    public void save() {
        CompoundTag component = new CompoundTag();
        for (TankDefinition tankDefinition : this.tanks) {
            FluidTank tank = this.tankMap.get(tankDefinition.name());
            component.put(tankDefinition.name(), (Tag)tank.writeToNBT((HolderLookup.Provider)IFAttachments.registryAccess(), component.getCompound(tankDefinition.name())));
        }
        this.stack.set(IFAttachments.INFINITY_TANKS, (Object)component);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        int i = 0;
        while (i < this.tanks.size()) {
            TankDefinition tankDefinition = this.tanks.get(i);
            int finalI = i++;
            list.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ItemStackTankScreenAddon(tankDefinition.x, tankDefinition.y, (IFluidHandler)this, finalI, tankDefinition.type)));
        }
        return list;
    }

    public record TankDefinition(String name, int capacity, int x, int y, Predicate<FluidStack> filter, boolean extract, boolean insert, FluidTankComponent.Type type) {
    }
}

