/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon;

import com.buuz135.industrial.item.addon.AddonItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class SpeedAddonItem
extends AddonItem
implements ISpecialCreativeTabItem {
    private int tier;

    public SpeedAddonItem(int tier, TitaniumTab group) {
        super("speed_addon_tier_" + tier, group, new Item.Properties().stacksTo(16));
        this.tier = tier;
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)AugmentTypes.SPEED, (float)(1 + this.tier));
    }

    public void registerRecipe(RecipeOutput consumer) {
        TagKey<Item> tierMaterial = this.tier == 1 ? IndustrialTags.Items.GEAR_GOLD : IndustrialTags.Items.GEAR_DIAMOND;
        DissolutionChamberRecipe.createRecipe(consumer, "speed_addon_tier_" + this.tier, new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.REDSTONE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.REDSTONE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLASS_PANE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLASS_PANE)}), Ingredient.of(tierMaterial), Ingredient.of(tierMaterial), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.SUGAR)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.SUGAR)})), new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1000), 200, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }

    public String getDescriptionId() {
        return Component.translatable((String)"item.industrialforegoing.addon").getString() + Component.translatable((String)"item.industrialforegoing.speed").getString() + "Tier " + this.tier + " ";
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"text.industrialforegoing.tooltip.speed").getString() + "+" + this.tier * 100 + "%")));
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        ItemStack stack = new ItemStack((ItemLike)this);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)AugmentTypes.SPEED, (float)(1 + this.tier));
        event.accept(stack);
    }
}

