/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class MeatFeederItem
extends IFCustomItem {
    public MeatFeederItem(TitaniumTab group) {
        super("meat_feeder", group, new Item.Properties().stacksTo(1));
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void onCraftedPostProcess(ItemStack stack, Level level) {
        super.onCraftedPostProcess(stack, level);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        IFluidHandlerItem handlerItemStack = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handlerItemStack != null && key == null) {
            tooltip.add((Component)Component.literal((String)(NumberFormat.getNumberInstance(Locale.ROOT).format(handlerItemStack.getFluidInTank(0).getAmount()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getNumberInstance(Locale.ROOT).format(512000L) + String.valueOf(ChatFormatting.GOLD) + "mb of Meat")));
        }
    }

    public int getFilledAmount(ItemStack stack) {
        IFluidHandlerItem handlerItemStack = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        return handlerItemStack == null || handlerItemStack.getFluidInTank(0).isEmpty() ? 0 : handlerItemStack.getFluidInTank(0).getAmount();
    }

    public void drain(ItemStack stack, int amount) {
        IFluidHandlerItem handlerItemStack = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handlerItemStack != null) {
            handlerItemStack.drain(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), amount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.isClientSide && entityIn instanceof Player && ((player = (Player)entityIn).getFoodData().needsFood() || player.getFoodData().getSaturationLevel() < 10.0f) && stack.getItem().equals(ModuleTool.MEAT_FEEDER.get())) {
            MeatFeederItem.meatTick(stack, player);
        }
    }

    public static boolean meatTick(ItemStack stack, Player player) {
        int filledAmount = ((MeatFeederItem)stack.getItem()).getFilledAmount(stack);
        if (filledAmount >= 400 && (player.getFoodData().getSaturationLevel() < 20.0f || player.getFoodData().getFoodLevel() < 20)) {
            ((MeatFeederItem)stack.getItem()).drain(stack, 400);
            player.getFoodData().eat(1, 1.0f);
            return true;
        }
        return false;
    }

    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("pip").pattern("gig").pattern(" i ").define(Character.valueOf('p'), (ItemLike)ModuleCore.PLASTIC.get()).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('g'), (ItemLike)Items.GLASS_BOTTLE).save(consumer);
    }
}

