/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.transporter;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.network.TransporterButtonInteractMessage;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.network.Message;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiTransporter
extends AbstractContainerScreen<ContainerTransporter>
implements ICanSendNetworkMessage {
    public static final ResourceLocation BG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/conveyor.png");
    private TransporterType upgrade = this.getMenu().getTransporterTile().getTransporterTypeMap().get(this.getMenu().getFacing());
    private List<IGuiComponent> componentList = new ArrayList<IGuiComponent>();
    private List<IScreenAddon> screenAddonList;
    private int x;
    private int y;
    private List<IFilter.GhostSlot> ghostSlots = new ArrayList<IFilter.GhostSlot>();

    public GuiTransporter(ContainerTransporter inventorySlotsIn, Inventory inventory, Component component) {
        super((AbstractContainerMenu)inventorySlotsIn, inventory, component);
        this.screenAddonList = new ArrayList<IScreenAddon>();
    }

    protected void init() {
        super.init();
        this.componentList.clear();
        this.upgrade.addComponentsToGui(this.componentList);
        this.screenAddonList.add((IScreenAddon)((ContainerTransporter)this.menu).getTransporterTile().getAugmentBackground().create());
        this.screenAddonList.add((IScreenAddon)new SlotsScreenAddon(((ContainerTransporter)this.menu).getTransporterTile().getAugmentInventory()));
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!(iGuiComponent instanceof FilterGuiComponent)) continue;
            this.ghostSlots.addAll(Arrays.asList(((FilterGuiComponent)iGuiComponent).getFilter().getFilter()));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.x = (this.width - this.imageWidth) / 2;
        this.y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BG_TEXTURE, this.x, this.y, 0, 0, this.imageWidth, this.imageHeight);
        if (this.upgrade != null) {
            String localized = Component.translatable((String)this.upgrade.getFactory().getUpgradeItem().getDescriptionId()).getString();
            guiGraphics.drawString(Minecraft.getInstance().font, localized, this.x + this.imageWidth / 2 - this.getMinecraft().font.width(localized) / 2, this.y + 6, 0x404040, false);
        }
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiBackgroundLayer(guiGraphics, this.x, this.y, mouseX, mouseY);
        }
        for (IScreenAddon iScreenAddon : this.screenAddonList) {
            iScreenAddon.drawBackgroundLayer(guiGraphics, (Screen)this, (IAssetProvider)IAssetProvider.DEFAULT_PROVIDER, this.x, this.y, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.x = (this.width - this.imageWidth) / 2;
        this.y = (this.height - this.imageHeight) / 2;
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiForegroundLayer(guiGraphics, this.x, this.y, mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX - this.x, mouseY - this.y);
        for (IGuiComponent iGuiComponent : this.componentList) {
            List<Component> tooltips;
            if (!iGuiComponent.isInside(mouseX - this.x, mouseY - this.y) || (tooltips = iGuiComponent.getTooltip(this.x, this.y, mouseX, mouseY)) == null) continue;
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltips, mouseX - this.x, mouseY - this.y);
        }
    }

    public ContainerTransporter getMenu() {
        return (ContainerTransporter)super.getMenu();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean click = super.mouseClicked(mouseX, mouseY, mouseButton);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!iGuiComponent.isInside(mouseX - (double)this.x, mouseY - (double)this.y) || !iGuiComponent.handleClick(this, this.x, this.y, mouseX, mouseY)) continue;
            return true;
        }
        return click;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean click = super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!iGuiComponent.isInside(mouseX - (double)this.x, mouseY - (double)this.y) || !iGuiComponent.onScrolled(this, this.x, this.y, mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        return click;
    }

    @Override
    public void sendMessage(int id, CompoundTag compound) {
        IndustrialForegoing.NETWORK.sendToServer((Message)new TransporterButtonInteractMessage(this.upgrade.getPos(), id, this.upgrade.getSide(), compound));
    }

    public List<IFilter.GhostSlot> getGhostSlots() {
        return this.ghostSlots;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

