/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.item.infinity.item.ItemInfinityLauncher;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.network.PlungerPlayerHitMessage;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.network.Message;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class InfinityLauncherProjectileEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> PLUNGER_ACTION = SynchedEntityData.defineId(InfinityLauncherProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.defineId(InfinityLauncherProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public InfinityLauncherProjectileEntity(EntityType<? extends InfinityLauncherProjectileEntity> type, Level world) {
        super(type, world);
    }

    public InfinityLauncherProjectileEntity(Level worldIn, LivingEntity thrower, ItemInfinityLauncher.PlungerAction plungerAction, int tier, ItemStack stack) {
        super((EntityType)ModuleTool.INFINITY_LAUNCHER_PROJECTILE_ENTITY_TYPE.value(), thrower, worldIn, ItemStack.EMPTY, stack);
        this.entityData.set(PLUNGER_ACTION, (Object)plungerAction.getId());
        this.entityData.set(TIER, (Object)tier);
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfinityLauncherProjectileEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModuleTool.INFINITY_LAUNCHER_PROJECTILE_ENTITY_TYPE.value(), x, y, z, worldIn, ItemStack.EMPTY, ItemStack.EMPTY);
    }

    public void tick() {
        super.tick();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Entity player = this.getOwner();
        ItemInfinityLauncher.PlungerAction action = ItemInfinityLauncher.PlungerAction.getFromId((Integer)this.entityData.get(PLUNGER_ACTION));
        if (player instanceof Player && action == ItemInfinityLauncher.PlungerAction.RELEASE) {
            for (ItemStack itemStack : ((Player)player).getInventory().items) {
                if (!(itemStack.getItem() instanceof MobImprisonmentToolItem) || !itemStack.has(IFAttachments.MOB_IMPRISONMENT_TOOL)) continue;
                ItemStack copy = itemStack.copy();
                if (!((MobImprisonmentToolItem)itemStack.getItem()).release((Player)player, result.getBlockPos(), result.getDirection(), this.level(), copy)) continue;
                ((Player)player).getInventory().removeItem(itemStack);
                ((Player)player).getInventory().add(copy);
                break;
            }
            this.onClientRemoval();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLUNGER_ACTION, (Object)0);
        builder.define(TIER, (Object)0);
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnchanted() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double dist) {
        return dist <= 64.0;
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
        Entity player;
        Entity entity = p_213868_1_.getEntity();
        float f = (float)this.getDeltaMovement().length();
        int i = Mth.ceil((double)Mth.clamp((double)((double)f * 1.0 + (double)((Integer)this.entityData.get(TIER)).intValue()), (double)0.0, (double)2.147483647E9));
        ItemInfinityLauncher.PlungerAction action = ItemInfinityLauncher.PlungerAction.getFromId((Integer)this.entityData.get(PLUNGER_ACTION));
        if (action == ItemInfinityLauncher.PlungerAction.DAMAGE) {
            DamageSource damagesource;
            Entity entity1;
            if (this.isCritArrow()) {
                long j = this.random.nextInt(i / 2 + 2);
                i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
            }
            if ((entity1 = this.getOwner()) == null) {
                damagesource = this.level().damageSources().arrow((AbstractArrow)this, (Entity)this);
            } else {
                damagesource = this.level().damageSources().arrow((AbstractArrow)this, entity1);
                if (entity1 instanceof LivingEntity) {
                    ((LivingEntity)entity1).setLastHurtMob(entity);
                }
            }
            boolean flag = entity.getType() == EntityType.ENDERMAN;
            int k = entity.getRemainingFireTicks();
            if (this.isOnFire() && !flag) {
                entity.igniteForSeconds(5.0f);
            }
            if (entity.hurt(damagesource, (float)i)) {
                if (flag) {
                    return;
                }
                if (entity instanceof LivingEntity) {
                    Level level;
                    Vec3 vector3d;
                    LivingEntity livingentity = (LivingEntity)entity;
                    if (!this.level().isClientSide && livingentity instanceof Player) {
                        IndustrialForegoing.NETWORK.sendToNearby(this.level(), this.blockPosition(), 256, (Message)new PlungerPlayerHitMessage(livingentity.getUUID()));
                    }
                    if ((vector3d = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(0.6)).lengthSqr() > 0.0) {
                        livingentity.push(vector3d.x, 0.1, vector3d.z);
                    }
                    if ((level = this.level()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (entity1 instanceof LivingEntity) {
                            EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                        }
                    }
                    this.doPostHurtEffects(livingentity);
                    if (entity1 != null && livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.isSilent()) {
                        ((ServerPlayer)entity1).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
                this.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                if (this.getPierceLevel() <= 0) {
                    this.onClientRemoval();
                }
            } else {
                entity.setRemainingFireTicks(k);
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
                this.setYRot(180.0f);
                this.yRotO += 180.0f;
                if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                    if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                        this.spawnAtLocation(this.getPickupItem(), 0.1f);
                    }
                    this.onClientRemoval();
                }
            }
        }
        if ((player = this.getOwner()) instanceof Player && entity instanceof LivingEntity && action == ItemInfinityLauncher.PlungerAction.CAPTURE) {
            for (ItemStack itemStack : ((Player)player).getInventory().items) {
                if (!(itemStack.getItem() instanceof MobImprisonmentToolItem) || itemStack.has(IFAttachments.MOB_IMPRISONMENT_TOOL)) continue;
                ItemStack copy = itemStack.copy();
                if (!((MobImprisonmentToolItem)itemStack.getItem()).capture(copy, (LivingEntity)entity)) continue;
                ((Player)player).getInventory().removeItem(itemStack);
                ((Player)player).getInventory().add(copy);
                break;
            }
            this.onClientRemoval();
        }
    }
}

