/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.TextGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.utils.MovementUtils;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class ConveyorSplittingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTH = Shapes.box((double)0.295, (double)0.1, (double)-0.08000000000000002, (double)0.6950000000000001, (double)0.16, (double)0.29999999999999993);
    public static VoxelShape SOUTH = Shapes.box((double)0.295, (double)0.1, (double)0.7, (double)0.6950000000000001, (double)0.16, (double)1.08);
    public static VoxelShape WEST = Shapes.box((double)-0.08, (double)0.1, (double)0.3, (double)0.3, (double)0.16, (double)0.7);
    public static VoxelShape EAST = Shapes.box((double)0.7, (double)0.1, (double)0.3, (double)1.07, (double)0.16, (double)0.7);
    public List<Integer> handlingEntities = new ArrayList<Integer>();
    private Direction nextFacing;
    private int ratio;
    private int currentRatio;

    public ConveyorSplittingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
        this.nextFacing = side;
        this.ratio = 1;
        this.currentRatio = 1;
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (!this.getWorld().isClientSide && !this.getContainer().getEntityFilter().contains(entity.getId()) && this.nextFacing == this.getSide()) {
            this.handlingEntities.add(entity.getId());
            this.getContainer().getEntityFilter().add(entity.getId());
            IndustrialForegoing.NETWORK.sendToNearby(this.getContainer().getBlockWorld(), this.getPos(), 64, (Message)new ConveyorSplittingSyncEntityMessage(this.getPos(), entity.getId(), this.getSide()));
            this.findNextUpgradeAndUpdate();
        }
        if (this.handlingEntities.contains(entity.getId())) {
            MovementUtils.handleConveyorMovement(entity, this.getSide(), this.getPos(), ((ConveyorTile)this.getContainer()).getConveyorType());
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.handlingEntities.isEmpty()) {
            return;
        }
        AABB box = ((AABB)this.getWorld().getBlockState(this.getPos()).getCollisionShape((BlockGetter)this.getWorld(), this.getPos()).toAabbs().get(0)).move(this.getPos()).inflate(0.04);
        for (Integer integer : new ArrayList<Integer>(this.handlingEntities)) {
            Entity entity = this.getWorld().getEntity(integer.intValue());
            if (entity == null || box.intersects(entity.getBoundingBox())) continue;
            this.handlingEntities.remove(integer);
            this.getContainer().getEntityFilter().remove(integer);
        }
    }

    @Override
    public void onUpgradeRemoved() {
        super.onUpgradeRemoved();
        if (this.nextFacing == this.getSide()) {
            this.findNextUpgradeAndUpdate();
        }
    }

    public void findNextUpgradeAndUpdate() {
        int y;
        --this.currentRatio;
        if (this.currentRatio > 0) {
            this.getContainer().requestSync();
            return;
        }
        this.currentRatio = this.ratio;
        Direction facing = this.nextFacing.getClockWise();
        ConveyorUpgrade conveyorUpgrade = ((ConveyorTile)this.getContainer()).getUpgradeMap().get(facing);
        for (y = 0; !(conveyorUpgrade instanceof ConveyorSplittingUpgrade) && y < 10; ++y) {
            facing = facing.getClockWise();
            conveyorUpgrade = ((ConveyorTile)this.getContainer()).getUpgradeMap().get(facing);
        }
        if (y >= 10) {
            facing = this.getSide();
        }
        ConveyorTile entityConveyor = (ConveyorTile)this.getContainer();
        for (Direction Direction2 : entityConveyor.getUpgradeMap().keySet()) {
            ConveyorUpgrade upgrade = entityConveyor.getUpgradeMap().get(Direction2);
            if (!(upgrade instanceof ConveyorSplittingUpgrade)) continue;
            ((ConveyorSplittingUpgrade)upgrade).setNextFacing(facing);
        }
        this.getContainer().requestSync();
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: 
        }
        return EAST;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider) == null ? new CompoundTag() : super.serializeNBT(provider);
        compound.putString("NextFacing", this.nextFacing.getSerializedName());
        compound.putInt("Ratio", this.ratio);
        compound.putInt("CurrentRatio", this.currentRatio);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.nextFacing = Direction.byName((String)nbt.getString("NextFacing"));
        this.ratio = nbt.getInt("Ratio");
        this.currentRatio = nbt.getInt("CurrentRatio");
    }

    public Direction getNextFacing() {
        return this.nextFacing;
    }

    public void setNextFacing(Direction nextFacing) {
        this.nextFacing = nextFacing;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
        componentList.add(new TextureGuiComponent(20, 26, 16, 16, res, 40, 234, "splitting_ratio"));
        componentList.add(new TextGuiComponent(40, 31){

            @Override
            public String getText() {
                return String.valueOf(ChatFormatting.DARK_GRAY) + (ConveyorSplittingUpgrade.this.ratio < 10 ? " " : "") + ConveyorSplittingUpgrade.this.ratio;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(this, 0, 60, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(this, 1, 76, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId == 0 && this.ratio <= 64) {
            ++this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
        if (buttonId == 1 && this.ratio > 1) {
            --this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            super("splitting");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorSplittingUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("block/conveyor_upgrade_splitting_" + upgradeSide.getSerializedName().toLowerCase()));
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"conveyor_splitting_upgrade");
        }

        public void registerRecipe(RecipeOutput consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).pattern("IPI").pattern("IDI").pattern("ICI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)ModuleTransportStorage.CONVEYOR.getBlock()).define(Character.valueOf('D'), (ItemLike)Blocks.HOPPER).define(Character.valueOf('C'), (ItemLike)ModuleTransportStorage.CONVEYOR.getBlock()).save(consumer);
        }
    }
}

