/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.LaserDrillConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LaserDrillTile
extends IndustrialAreaWorkingTile<LaserDrillTile> {
    @Save
    private BlockPos target = BlockPos.ZERO;

    public LaserDrillTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.LASER_DRILL, RangeManager.RangeType.BEHIND, false, LaserDrillConfig.powerPerOperation, blockPos, blockState);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextScreenAddon(String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.target").getString(), 44, 26, false));
        this.addGuiAddonFactory(() -> new TextScreenAddon("Target: ", 44, 36, false){

            public String getText() {
                if (LaserDrillTile.this.target.equals((Object)BlockPos.ZERO) || LaserDrillTile.this.target == null) {
                    return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.target_not_found").getString();
                }
                return String.valueOf(ChatFormatting.DARK_GRAY) + "X: " + LaserDrillTile.this.target.getX() + " Y: " + LaserDrillTile.this.target.getY() + " Z: " + LaserDrillTile.this.target.getZ();
            }
        });
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (!this.target.equals((Object)BlockPos.ZERO) && !this.isValidTarget(this.target)) {
            this.target = BlockPos.ZERO;
            this.markForUpdate();
        }
        if (this.target.equals((Object)BlockPos.ZERO)) {
            this.findTarget();
        }
        if (!this.target.equals((Object)BlockPos.ZERO) && this.hasEnergy(LaserDrillConfig.powerPerOperation) && this.level.getBlockEntity(this.target) instanceof ILaserBase) {
            ILaserBase laserBase = (ILaserBase)this.level.getBlockEntity(this.target);
            laserBase.getBar().setProgress(laserBase.getBar().getProgress() + 1);
            laserBase.getBar().tickBar();
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, LaserDrillConfig.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public VoxelShape getWorkingArea() {
        Vec3i vector = this.getFacingDirection().getOpposite().getNormal();
        return Shapes.box((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).move((double)(this.worldPosition.getX() + vector.getX() * 2), (double)(this.worldPosition.getY() + vector.getY() * 2 - 1), (double)(this.worldPosition.getZ() + vector.getZ() * 2));
    }

    public void findTarget() {
        for (BlockPos blockPos : BlockUtils.getBlockPosInAABB(this.getWorkingArea().bounds())) {
            if (!this.isValidTarget(blockPos)) continue;
            this.target = blockPos;
            this.markForUpdate();
            return;
        }
    }

    public boolean isValidTarget(BlockPos pos) {
        if (pos.equals((Object)BlockPos.ZERO)) {
            return false;
        }
        return this.level.getBlockEntity(pos) instanceof ILaserBase;
    }

    public LaserDrillTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<LaserDrillTile> createEnergyStorage() {
        return new EnergyStorageComponent(LaserDrillConfig.maxStoredPower, 10, 20);
    }

    public BlockPos getTarget() {
        return this.target;
    }

    @Override
    public int getMaxProgress() {
        return LaserDrillConfig.maxProgress;
    }
}

