/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.BlockBreakerConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BlockBreakerTile
extends IndustrialAreaWorkingTile<BlockBreakerTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedInventoryComponent<BlockBreakerTile> output = (SidedInventoryComponent)new SidedInventoryComponent("output", 54, 22, 18, 0).setColor(DyeColor.ORANGE).setRange(6, 3);

    public BlockBreakerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.BLOCK_BREAKER, RangeManager.RangeType.BEHIND, false, BlockBreakerConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.output);
        this.getMaxProgress = BlockBreakerConfig.maxProgress;
        this.getPowerPerOperation = BlockBreakerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            BlockPos pointed = this.getPointedBlockPos();
            if (this.isLoaded(pointed) && !this.level.isEmptyBlock(pointed) && BlockUtils.canBlockBeBroken(this.level, pointed, this.getUuid())) {
                FakePlayer fakePlayer = IndustrialForegoing.getFakePlayer(this.level, pointed, this.getUuid());
                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
                if (this.level.getBlockState(pointed).getDestroySpeed((BlockGetter)this.level, pointed) >= 0.0f && this.level.getBlockState(pointed).canHarvestBlock((BlockGetter)this.level, pointed, (Player)fakePlayer)) {
                    for (ItemStack blockDrop : BlockUtils.getBlockDrops(this.level, pointed)) {
                        ItemStack result = ItemHandlerHelper.insertItem(this.output, (ItemStack)blockDrop, (boolean)false);
                        if (result.isEmpty()) continue;
                        BlockUtils.spawnItemStack(result, this.level, pointed);
                    }
                    this.level.setBlockAndUpdate(pointed, Blocks.AIR.defaultBlockState());
                    this.increasePointer();
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
                }
            } else {
                this.increasePointer();
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<BlockBreakerTile> createEnergyStorage() {
        return new EnergyStorageComponent(BlockBreakerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public BlockBreakerTile getSelf() {
        return this;
    }
}

