/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.misc.StasisChamberConfig;
import com.buuz135.industrial.module.ModuleMisc;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class StasisChamberTile
extends IndustrialAreaWorkingTile<StasisChamberTile> {
    private int getMaxProgress = StasisChamberConfig.maxProgress;
    private int getPowerPerOperation = StasisChamberConfig.powerPerOperation;

    public StasisChamberTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.STASIS_CHAMBER, RangeManager.RangeType.TOP, false, StasisChamberConfig.powerPerOperation, blockPos, blockState);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            List entities = this.level.getEntitiesOfClass(Mob.class, this.getWorkingArea().bounds());
            for (Mob entity : entities) {
                entity.setNoAi(true);
                entity.getPersistentData().putLong("StasisChamberTime", this.level.getGameTime());
                if (!entity.getType().is(Tags.EntityTypes.BOSSES) && this.level instanceof ServerLevel) {
                    if (StasisChamberConfig.disableBossBars) {
                        this.level.players().forEach(entity1 -> entity.stopSeenByPlayer((ServerPlayer)entity1));
                    } else {
                        this.level.players().forEach(entity1 -> entity.startSeenByPlayer((ServerPlayer)entity1));
                    }
                }
                if (!this.level.random.nextBoolean() || !this.level.random.nextBoolean()) continue;
                entity.heal(1.0f);
            }
            List players = this.level.getEntitiesOfClass(Player.class, this.getWorkingArea().bounds());
            players.forEach(playerEntity -> {
                playerEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 25, 135));
                if (this.level.random.nextBoolean()) {
                    playerEntity.heal(1.0f);
                }
            });
            return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.getPowerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return Shapes.box((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).move((double)this.worldPosition.getX(), (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ());
    }

    @Nonnull
    public StasisChamberTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<StasisChamberTile> createEnergyStorage() {
        return new EnergyStorageComponent(StasisChamberConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }
}

