/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.tile.MycelialReactorTile;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.worlddata.MycelialDataManager;
import com.hrznstudio.titanium.block.RotatableBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MycelialReactorBlock
extends IndustrialBlock<MycelialReactorTile> {
    public MycelialReactorBlock() {
        super("mycelial_reactor", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), MycelialReactorTile.class, ModuleGenerator.TAB_GENERATOR);
    }

    public BlockEntityType.BlockEntitySupplier<MycelialReactorTile> getTileEntityFactory() {
        return MycelialReactorTile::new;
    }

    @Nonnull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @Override
    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (entity instanceof MycelialReactorTile && placer != null) {
            ((MycelialReactorTile)entity).setOwner(placer.getUUID().toString());
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (player.isShiftKeyDown() && !worldIn.isClientSide && tileEntity instanceof MycelialReactorTile) {
            List<String> available = MycelialDataManager.getReactorAvailable(((MycelialReactorTile)tileEntity).getOwner(), worldIn, false);
            if (available.size() != IMycelialGeneratorType.TYPES.size()) {
                player.sendSystemMessage((Component)Component.literal((String)"Generators not running:").withStyle(ChatFormatting.RED));
            }
            for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
                if (available.contains(type.getName())) continue;
                player.sendSystemMessage((Component)Component.translatable((String)("block.industrialforegoing.mycelial_" + type.getName())).withStyle(ChatFormatting.RED));
            }
        }
        return super.useItemOn(stack, state, worldIn, pos, player, hand, ray);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult ray) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (player.isShiftKeyDown() && !worldIn.isClientSide && tileEntity instanceof MycelialReactorTile) {
            List<String> available = MycelialDataManager.getReactorAvailable(((MycelialReactorTile)tileEntity).getOwner(), worldIn, false);
            if (available.size() != IMycelialGeneratorType.TYPES.size()) {
                player.sendSystemMessage((Component)Component.literal((String)"Generators not running:").withStyle(ChatFormatting.RED));
            }
            for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
                if (available.contains(type.getName())) continue;
                player.sendSystemMessage((Component)Component.translatable((String)("block.industrialforegoing.mycelial_" + type.getName())).withStyle(ChatFormatting.RED));
            }
        }
        return super.useWithoutItem(state, worldIn, pos, player, ray);
    }
}

