/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.capability.tile.BigEnergyHandler;
import com.buuz135.industrial.config.machine.agriculturehusbandry.WitherBuilderConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IFFakePlayer;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;

public class WitherBuilderTile
extends IndustrialAreaWorkingTile<WitherBuilderTile> {
    @Save
    private SidedInventoryComponent<WitherBuilderTile> top = (SidedInventoryComponent)new SidedInventoryComponent("wither_skulls", 64, 25, 3, 0).setColor(DyeColor.BLACK).setInputFilter((itemStack, integer) -> itemStack.getItem().equals(Items.WITHER_SKELETON_SKULL)).setSlotLimit(1).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedInventoryComponent<WitherBuilderTile> middle;
    @Save
    private SidedInventoryComponent<WitherBuilderTile> bottom;

    public WitherBuilderTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.WITHER_BUILDER, RangeManager.RangeType.TOP_UP, true, WitherBuilderConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.top);
        this.middle = (SidedInventoryComponent)new SidedInventoryComponent("soulsand", 64, 43, 3, 1).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> itemStack.getItem().equals(Blocks.SOUL_SAND.asItem())).setSlotLimit(1).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.middle);
        this.bottom = (SidedInventoryComponent)new SidedInventoryComponent("soulsand", 82, 61, 1, 2).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> itemStack.getItem().equals(Blocks.SOUL_SAND.asItem())).setSlotLimit(1).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.bottom);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (!this.hasEnergy(WitherBuilderConfig.powerPerOperation) || !BlockUtils.canBlockBeBroken(this.level, this.worldPosition, this.getUuid())) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        BlockPos pos = this.worldPosition.offset(0, 2, 0);
        float power = 0.0f;
        if (this.level.getBlockState(pos).getBlock().equals(Blocks.AIR) && !this.getDefaultOrFind(0, (ItemStackHandler)this.bottom, new ItemStack((ItemLike)Blocks.SOUL_SAND)).isEmpty()) {
            this.level.setBlockAndUpdate(pos, Blocks.SOUL_SAND.defaultBlockState());
            this.getDefaultOrFind(0, (ItemStackHandler)this.bottom, new ItemStack((ItemLike)Blocks.SOUL_SAND)).shrink(1);
            power += 0.14285715f;
        }
        if (this.level.getBlockState(pos).getBlock().equals(Blocks.SOUL_SAND)) {
            for (int i = 0; i < 3; ++i) {
                BlockPos temp = this.getFacingDirection() == Direction.EAST || this.getFacingDirection() == Direction.WEST ? pos.offset(0, 1, i - 1) : pos.offset(i - 1, 1, 0);
                if (!this.level.getBlockState(temp).getBlock().equals(Blocks.AIR) || this.getDefaultOrFind(i, (ItemStackHandler)this.middle, new ItemStack((ItemLike)Blocks.SOUL_SAND)).isEmpty()) continue;
                this.level.setBlockAndUpdate(temp, Blocks.SOUL_SAND.defaultBlockState());
                this.getDefaultOrFind(i, (ItemStackHandler)this.middle, new ItemStack((ItemLike)Blocks.SOUL_SAND)).shrink(1);
                power += 0.14285715f;
            }
        }
        if (this.level.getBlockState(pos).getBlock().equals(Blocks.SOUL_SAND)) {
            BlockPos temp;
            int i;
            boolean secondRow = true;
            for (i = 0; i < 3; ++i) {
                temp = this.getFacingDirection() == Direction.EAST || this.getFacingDirection() == Direction.WEST ? pos.offset(0, 1, i - 1) : pos.offset(i - 1, 1, 0);
                if (this.level.getBlockState(temp).getBlock().equals(Blocks.SOUL_SAND)) continue;
                secondRow = false;
                break;
            }
            if (secondRow) {
                for (i = 0; i < 3; ++i) {
                    ItemStack stack;
                    IFFakePlayer fakePlayer;
                    temp = this.getFacingDirection() == Direction.EAST || this.getFacingDirection() == Direction.WEST ? pos.offset(0, 2, i - 1) : pos.offset(i - 1, 2, 0);
                    if (!this.level.getBlockState(temp).getBlock().equals(Blocks.AIR) || this.getDefaultOrFind(i, (ItemStackHandler)this.top, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL)).isEmpty() || !this.level.getBlockState(temp.offset(0, -1, 0)).getBlock().equals(Blocks.SOUL_SAND) || !(fakePlayer = (IFFakePlayer)IndustrialForegoing.getFakePlayer(this.level, temp, this.getUuid())).placeBlock(this.level, temp, stack = this.getDefaultOrFind(i, (ItemStackHandler)this.top, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL)))) continue;
                    power += 0.14285715f;
                }
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, power > 0.0f ? WitherBuilderConfig.powerPerOperation : 0);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.worldPosition, this.getFacingDirection(), RangeManager.RangeType.TOP_UP){

            @Override
            public AABB getBox() {
                if (WitherBuilderTile.this.getFacingDirection() == Direction.EAST || WitherBuilderTile.this.getFacingDirection() == Direction.WEST) {
                    return super.getBox().move(new BlockPos(0, 1, 0)).inflate(0.0, 1.0, 1.0);
                }
                return super.getBox().move(new BlockPos(0, 1, 0)).inflate(1.0, 1.0, 0.0);
            }
        }.get(0);
    }

    @Nonnull
    public WitherBuilderTile getSelf() {
        return this;
    }

    @Nonnull
    protected EnergyStorageComponent<WitherBuilderTile> createEnergyStorage() {
        return new BigEnergyHandler<WitherBuilderTile>(WitherBuilderConfig.maxStoredPower, 10, 20){

            @Override
            public void sync() {
                WitherBuilderTile.this.syncObject(WitherBuilderTile.this.getEnergyStorage());
            }
        };
    }

    @Override
    public int getMaxProgress() {
        return WitherBuilderConfig.maxProgress;
    }

    public ItemStack getDefaultOrFind(int i, ItemStackHandler handler, ItemStack filter) {
        if (ItemStack.isSameItem((ItemStack)handler.getStackInSlot(i), (ItemStack)filter)) {
            return handler.getStackInSlot(i);
        }
        for (ItemStackHandler h : new ItemStackHandler[]{this.top, this.middle, this.bottom}) {
            for (int s = 0; s < h.getSlots(); ++s) {
                if (!ItemStack.isSameItem((ItemStack)h.getStackInSlot(s), (ItemStack)filter)) continue;
                return h.getStackInSlot(s);
            }
        }
        return ItemStack.EMPTY;
    }
}

