/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial;

import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.proxy.network.BackpackOpenMessage;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.proxy.network.BackpackSyncMessage;
import com.buuz135.industrial.proxy.network.ConveyorButtonInteractMessage;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.proxy.network.PlungerPlayerHitMessage;
import com.buuz135.industrial.proxy.network.SpecialParticleMessage;
import com.buuz135.industrial.proxy.network.TransporterButtonInteractMessage;
import com.buuz135.industrial.proxy.network.TransporterSyncMessage;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.recipe.provider.IndustrialRecipeProvider;
import com.buuz135.industrial.recipe.provider.IndustrialTagsProvider;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IFFakePlayer;
import com.buuz135.industrial.utils.data.IndustrialBlockstateProvider;
import com.buuz135.industrial.utils.data.IndustrialModelProvider;
import com.hrznstudio.titanium.datagenerator.loot.TitaniumLootTableProvider;
import com.hrznstudio.titanium.datagenerator.model.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import com.hrznstudio.titanium.reward.RewardManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="industrialforegoing")
public class IndustrialForegoing
extends ModuleController {
    private static CommonProxy proxy;
    private static HashMap<String, IFFakePlayer> worldFakePlayer;
    public static NetworkHandler NETWORK;
    public static Logger LOGGER;
    public static IndustrialForegoing INSTANCE;
    public static Reward CAT_EARS;
    public static List<String> OWN_MODS_LOADED;

    public IndustrialForegoing(Dist dist, IEventBus modBus, ModContainer container) {
        super(container);
        NETWORK.registerMessage("conveyor_button_interact", ConveyorButtonInteractMessage.class);
        NETWORK.registerMessage("conveyor_splitting_sync_entity", ConveyorSplittingSyncEntityMessage.class);
        NETWORK.registerMessage("special_particle", SpecialParticleMessage.class);
        NETWORK.registerMessage("backpack_sync", BackpackSyncMessage.class);
        NETWORK.registerMessage("backpack_open", BackpackOpenMessage.class);
        NETWORK.registerMessage("backpack_opened", BackpackOpenedMessage.class);
        NETWORK.registerMessage("transporter_sync", TransporterSyncMessage.class);
        NETWORK.registerMessage("transporter_button_interact", TransporterButtonInteractMessage.class);
        NETWORK.registerMessage("plunger_player_hit", PlungerPlayerHitMessage.class);
        proxy = new CommonProxy();
        if (dist.isClient()) {
            EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> new ClientProxy().run()).subscribe();
            EventManager.mod(ModelEvent.RegisterAdditional.class).process(modelRegistryEvent -> modelRegistryEvent.register(new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"block/catears"), "standalone"))).subscribe();
            this.initClient();
        }
        EventManager.mod(FMLCommonSetupEvent.class).process(fmlCommonSetupEvent -> proxy.run()).subscribe();
        EventManager.forge(ServerStartingEvent.class).process(fmlServerStartingEvent -> worldFakePlayer.clear()).subscribe();
        EventManager.mod(NewRegistryEvent.class).process(IFRegistries::create).subscribe();
        RewardGiver giver = RewardManager.get().getGiver(UUID.fromString("d28b7061-fb92-4064-90fb-7e02b95a72a6"), "Buuz135");
        try {
            CAT_EARS = new Reward(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"cat_ears"), new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json"), () -> iDist -> {}, new String[]{"normal", "cat", "spooky", "snowy"});
            giver.addReward(CAT_EARS);
        }
        catch (MalformedURLException e) {
            LOGGER.catching((Throwable)e);
        }
        LaserDrillRarity.init();
        PlayerInventoryFinder.init();
        NeoForgeMod.enableMilkFluid();
        IFAttachments.DR.register(modBus);
        OWN_MODS_LOADED = ModList.get().getMods().stream().filter(iModInfo -> iModInfo.getConfig().getConfigElement(new String[]{"authors"}).orElse("").toString().contains("Buuz135")).map(IModInfo::getDisplayName).toList();
    }

    private static FakePlayer getFakePlayer(Level world, String uuid) {
        if (worldFakePlayer.containsKey(uuid)) {
            return worldFakePlayer.get(uuid);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            IFFakePlayer fakePlayer = new IFFakePlayer(serverLevel, uuid);
            worldFakePlayer.put(uuid, fakePlayer);
            return fakePlayer;
        }
        return null;
    }

    public static FakePlayer getFakePlayer(Level world, BlockPos pos, String uuid) {
        FakePlayer player = IndustrialForegoing.getFakePlayer(world, uuid);
        if (player != null) {
            player.absMoveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 90.0f, 90.0f);
        }
        return player;
    }

    public void onPreInit() {
        super.onPreInit();
    }

    public void addDataProvider(GatherDataEvent event) {
        super.addDataProvider(event);
        Lazy blocksToProcess = Lazy.of(() -> BuiltInRegistries.BLOCK.stream().filter(block -> !block.getClass().equals(LiquidBlock.class)).filter(basicBlock -> Optional.ofNullable(BuiltInRegistries.BLOCK.getKey(basicBlock)).map(ResourceLocation::getNamespace).filter("industrialforegoing"::equalsIgnoreCase).isPresent()).collect(Collectors.toList()));
        IndustrialTagsProvider.Blocks blockProvider = new IndustrialTagsProvider.Blocks(event.getGenerator(), event.getLookupProvider(), "industrialforegoing", event.getExistingFileHelper());
        event.getGenerator().addProvider(true, (DataProvider)blockProvider);
        event.getGenerator().addProvider(true, (DataProvider)new IndustrialTagsProvider.Items(event.getGenerator(), event.getLookupProvider(), blockProvider.contentsGetter(), "industrialforegoing", event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new IndustrialRecipeProvider(event.getGenerator(), (Lazy<List<Block>>)blocksToProcess, event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new TitaniumLootTableProvider(event.getGenerator(), (Supplier)blocksToProcess, event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), "industrialforegoing", (Supplier)blocksToProcess));
        event.getGenerator().addProvider(true, (DataProvider)new IndustrialBlockstateProvider(event.getGenerator(), event.getExistingFileHelper(), (Lazy<List<Block>>)blocksToProcess));
        event.getGenerator().addProvider(true, (DataProvider)new IndustrialModelProvider(event.getGenerator(), event.getExistingFileHelper()));
    }

    protected void initModules() {
        INSTANCE = this;
        new ModuleCore().generateFeatures(this.getRegistries());
        new ModuleTool().generateFeatures(this.getRegistries());
        new ModuleTransportStorage().generateFeatures(this.getRegistries());
        new ModuleGenerator().generateFeatures(this.getRegistries());
        new ModuleAgricultureHusbandry().generateFeatures(this.getRegistries());
        new ModuleResourceProduction().generateFeatures(this.getRegistries());
        new ModuleMisc().generateFeatures(this.getRegistries());
        this.addCreativeTab("core", () -> new ItemStack((ItemLike)ModuleCore.DISSOLUTION_CHAMBER.getBlock()), "industrialforegoing_core", ModuleCore.TAB_CORE);
        this.addCreativeTab("ag_hus", () -> new ItemStack((ItemLike)ModuleAgricultureHusbandry.PLANT_SOWER.getBlock()), "industrialforegoing_ag_hus", ModuleAgricultureHusbandry.TAB_AG_HUS);
        this.addCreativeTab("transport", () -> new ItemStack((ItemLike)ModuleTransportStorage.CONVEYOR.getBlock()), "industrialforegoing_transport", ModuleTransportStorage.TAB_TRANSPORT);
        this.addCreativeTab("resource_production", () -> new ItemStack((ItemLike)ModuleResourceProduction.WATER_CONDENSATOR.getBlock()), "industrialforegoing_resource_production", ModuleResourceProduction.TAB_RESOURCE);
        this.addCreativeTab("generator", () -> new ItemStack((ItemLike)ModuleGenerator.PITIFUL_GENERATOR.getBlock()), "industrialforegoing_generator", ModuleGenerator.TAB_GENERATOR);
        this.addCreativeTab("misc", () -> new ItemStack((ItemLike)ModuleMisc.ENCHANTMENT_FACTORY.getBlock()), "industrialforegoing_misc", ModuleMisc.TAB_MISC);
        this.addCreativeTab("tool", () -> new ItemStack((ItemLike)ModuleTool.INFINITY_DRILL.get()), "industrialforegoing_tool", ModuleTool.TAB_TOOL);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClient() {
        EventManager.mod(RegisterMenuScreensEvent.class).process(registerMenuScreensEvent -> {
            registerMenuScreensEvent.register((MenuType)ContainerTransporter.TYPE.get(), GuiTransporter::new);
            registerMenuScreensEvent.register((MenuType)ContainerConveyor.TYPE.get(), GuiConveyor::new);
        }).subscribe();
        EventManager.mod(ModelEvent.BakingCompleted.class).process(event -> {
            ClientProxy.ears_baked = (BakedModel)event.getModels().get(new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"block/catears"), "standalone"));
        }).subscribe();
        ClientProxy.OPEN_BACKPACK = new KeyMapping("key.industrialforegoing.backpack.desc", -1, "key.industrialforegoing.category");
        EventManager.mod(RegisterKeyMappingsEvent.class).process(event -> event.register(ClientProxy.OPEN_BACKPACK)).subscribe();
        EventManager.forge(ClientTickEvent.Post.class).process(event -> {
            if (ClientProxy.OPEN_BACKPACK.consumeClick()) {
                NETWORK.sendToServer((Message)new BackpackOpenMessage(Screen.hasControlDown()));
            }
        }).subscribe();
    }

    static {
        worldFakePlayer = new HashMap();
        NETWORK = new NetworkHandler("industrialforegoing");
        LOGGER = LogManager.getLogger((String)"industrialforegoing");
        OWN_MODS_LOADED = new ArrayList<String>();
    }
}

