/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectConjureWater
extends AbstractEffect
implements IPotionEffect {
    public static EffectConjureWater INSTANCE = new EffectConjureWater();

    private EffectConjureWater() {
        super(GlyphLib.EffectConjureWaterID, "Conjure Water");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity.isOnFire()) {
            entity.clearFire();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (spellStats.getDurationMultiplier() > 0.0) {
                this.applyConfigPotion(livingEntity, (Holder<MobEffect>)ModPotions.SOAKED_EFFECT, spellStats);
            }
        }
        if (spellStats.isSensitive() && !world.dimensionType().ultraWarm()) {
            this.placeWater((ServerLevel)world, shooter, spellContext, resolver, entity.blockPosition(), Direction.UP);
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double aoeBuff = spellStats.getAoeMultiplier();
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.getBlockPos(), rayTraceResult, aoeBuff, spellStats.getBuffCount(AugmentPierce.INSTANCE));
        if (world.dimensionType().ultraWarm()) {
            return;
        }
        for (BlockPos pos1 : posList) {
            this.placeWater((ServerLevel)world, shooter, spellContext, resolver, pos1, rayTraceResult.getDirection());
        }
    }

    private void placeWater(ServerLevel world, @NotNull LivingEntity shooter, SpellContext spellContext, SpellResolver resolver, BlockPos pos1, Direction direction) {
        LiquidBlockContainer liquidBlockContainer;
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, world), (Level)world, pos1)) {
            return;
        }
        if (!world.isInWorldBounds(pos1)) {
            return;
        }
        BlockState hitState = world.getBlockState(pos1);
        Block block = hitState.getBlock();
        if (block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(this.getPlayer(shooter, world), (BlockGetter)world, pos1, world.getBlockState(pos1), (Fluid)Fluids.WATER)) {
            liquidBlockContainer.placeLiquid((LevelAccessor)world, pos1, hitState, Fluids.WATER.getSource(true));
            ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ()), direction, pos1, false), (Level)world, (Entity)shooter, spellContext, resolver);
        } else if (world.getBlockState(pos1.relative(direction)).canBeReplaced((Fluid)Fluids.WATER)) {
            pos1 = pos1.relative(direction);
            world.setBlockAndUpdate(pos1, Blocks.WATER.defaultBlockState());
            ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ()), direction, pos1, false), (Level)world, (Entity)shooter, spellContext, resolver);
        }
    }

    @Override
    public int getDefaultManaCost() {
        return 80;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentExtendTime.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Places water at a location or extinguishes entities on fire. If augmented with extend time, it will keep entities wet for a longer period of time.";
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_WATER);
    }

    @Override
    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    @Override
    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 10 : (Integer)this.EXTEND_TIME.get();
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 20);
        this.addExtendTimeConfig(builder, 10);
    }
}

