/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class EffectBlink
extends AbstractEffect {
    public static EffectBlink INSTANCE = new EffectBlink();

    private EffectBlink() {
        super(GlyphLib.EffectBlinkID, "Blink");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity;
        ItemStack stack;
        WarpScrollData data;
        InventoryManager manager;
        SlotReference reference;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        if (rayTraceResult.getEntity().getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED)) {
            return;
        }
        double distance = (double)((Integer)this.GENERIC_INT.get()).intValue() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
        if (spellContext.getCaster() instanceof TileCaster && !(reference = (manager = spellContext.getCaster().getInvManager()).findItem(i -> i.getItem() == ItemsRegistry.WARP_SCROLL.asItem() || i.getItem() == ItemsRegistry.STABLE_WARP_SCROLL.asItem(), InteractType.EXTRACT)).isEmpty() && (data = (WarpScrollData)(stack = reference.getHandler().getStackInSlot(reference.getSlot())).get(DataComponentRegistry.WARP_SCROLL)) != null && data.isValid() && data.canTeleportWithDim(world)) {
            EffectBlink.warpEntity(rayTraceResult.getEntity(), data);
            return;
        }
        if (rayTraceResult.getEntity().equals((Object)shooter)) {
            EffectBlink.blinkForward(world, (Entity)shooter, distance);
            return;
        }
        if (this.isRealPlayer((Entity)shooter)) {
            WarpScrollData scrollData = (WarpScrollData)shooter.getOffhandItem().get(DataComponentRegistry.WARP_SCROLL);
            if (scrollData != null && scrollData.isValid() && scrollData.canTeleportWithDim(world)) {
                EffectBlink.warpEntity(rayTraceResult.getEntity(), scrollData);
            } else {
                shooter.teleportTo(vec.x(), vec.y(), vec.z());
            }
        } else if (spellContext.getCaster().getCasterType() == SpellContext.CasterType.RUNE && (entity = rayTraceResult.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EffectBlink.blinkForward(world, (Entity)living, distance);
        }
    }

    public static void warpEntity(Entity entity, WarpScrollData warpScrollData) {
        LivingEntity living;
        EntityTeleportEvent.EnderEntity event;
        if (entity == null) {
            return;
        }
        BlockPos pos = warpScrollData.pos().get();
        if (entity instanceof LivingEntity && (event = EventHooks.onEnderTeleport((LivingEntity)(living = (LivingEntity)entity), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).isCanceled()) {
            return;
        }
        ServerLevel dimension = PortalTile.getServerLevel(warpScrollData.dimension(), (ServerLevel)entity.level);
        if (dimension == null) {
            return;
        }
        PortalTile.teleportEntityTo(entity, (Level)dimension, pos, warpScrollData.rotation());
    }

    public static void warpEntity(Entity entity, BlockPos warpPos) {
        LivingEntity living;
        EntityTeleportEvent.EnderEntity event;
        if (entity == null) {
            return;
        }
        Level world = entity.level;
        if (entity instanceof LivingEntity && (event = EventHooks.onEnderTeleport((LivingEntity)(living = (LivingEntity)entity), (double)warpPos.getX(), (double)warpPos.getY(), (double)warpPos.getZ())).isCanceled()) {
            return;
        }
        ((ServerLevel)entity.level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX(), entity.getY() + 1.0, entity.getZ(), 4, (world.random.nextDouble() - 0.5) * 2.0, -world.random.nextDouble(), (world.random.nextDouble() - 0.5) * 2.0, (double)0.1f);
        entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY(), (double)warpPos.getZ() + 0.5);
        Networking.sendToNearbyClient(world, entity, (CustomPacketPayload)new PacketWarpPosition(entity.getId(), entity.getX(), entity.getY(), entity.getZ(), entity.getXRot(), entity.getYRot()));
        entity.level.playSound(null, entity.blockPosition(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 1.0f);
        ((ServerLevel)entity.level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)entity.blockPosition().getX() + 0.5, (double)entity.blockPosition().getY() + 1.0, (double)entity.blockPosition().getZ() + 0.5, 4, (world.random.nextDouble() - 0.5) * 2.0, -world.random.nextDouble(), (world.random.nextDouble() - 0.5) * 2.0, (double)0.1f);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 vec = rayTraceResult.getLocation();
        if (this.isRealPlayer((Entity)shooter) && EffectBlink.isValidTeleport(world, rayTraceResult.getBlockPos().relative(rayTraceResult.getDirection()))) {
            EffectBlink.warpEntity((Entity)shooter, BlockPos.containing((Position)vec));
        }
    }

    public static void blinkForward(Level world, Entity shooter, double distance) {
        Vec3 lookVec = new Vec3(shooter.getLookAngle().x(), 0.0, shooter.getLookAngle().z());
        Vec3 vec = shooter.position().add(lookVec.scale(distance));
        BlockPos pos = BlockPos.containing((Position)vec);
        if (!EffectBlink.isValidTeleport(world, pos)) {
            BlockPos blockPos = pos = EffectBlink.getForward(world, pos, shooter, distance) == null ? EffectBlink.getForward(world, pos.above(2), shooter, distance) : EffectBlink.getForward(world, pos, shooter, distance);
        }
        if (pos == null) {
            return;
        }
        EffectBlink.warpEntity(shooter, pos);
    }

    public static BlockPos getForward(Level world, BlockPos pos, Entity shooter, double distance) {
        Vec3 lookVec = new Vec3(shooter.getLookAngle().x(), 0.0, shooter.getLookAngle().z());
        Vec3 oldVec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(lookVec.scale(distance));
        for (double i = distance; i >= 0.0; i -= 1.0) {
            Vec3 vec = oldVec.add(lookVec.scale(i));
            BlockPos sendPos = BlockPos.containing((Position)vec);
            if (i <= 0.0) {
                return null;
            }
            if (!EffectBlink.isValidTeleport(world, sendPos)) continue;
            return sendPos;
        }
        return null;
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 8, "Base teleport distance", "distance");
        this.addAmpConfig(builder, 3.0);
    }

    public static boolean isValidTeleport(Level world, BlockPos pos) {
        return !world.getBlockState(pos).canOcclude() && !world.getBlockState(pos.above()).canOcclude() && !world.getBlockState(pos.above(2)).canOcclude();
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Teleports the caster to a location. If an entity is hit and the caster is holding a Warp Scroll in the offhand, the entity will be warped to the location on the Warp Scroll. When used on Self, the caster blinks forward. Spell Turrets and Runes can warp entities using Warp Scrolls from adjacent inventories without consuming the scroll.";
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

