/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RitualHarvest
extends AbstractRitual {
    @Override
    protected void tick() {
        Level world = this.getWorld();
        BlockPos pos = this.getPos();
        if (world != null && world.isClientSide) {
            ParticleUtil.spawnRitualAreaEffect(this.getPos(), this.getWorld(), this.rand, this.getCenterColor(), 4);
            return;
        }
        if (world == null || pos == null || world.getGameTime() % 200L != 0L) {
            return;
        }
        int range = 4;
        boolean hasPlayedSound = false;
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(range, -1, range), (BlockPos)pos.offset(-range, 1, -range))) {
            CropBlock cropsBlock;
            BlockState state = world.getBlockState(blockpos);
            if (state.getBlock() instanceof FarmBlock || world.getBlockState(blockpos.above()).getBlock() instanceof CropBlock || world.getBlockState(blockpos.above()).getBlock() instanceof NetherWartBlock || world.getBlockState(blockpos.above()).is(BlockTagProvider.HARVEST_STEMS)) {
                blockpos = blockpos.above();
                state = world.getBlockState(blockpos);
            }
            if (state.getBlock() instanceof NetherWartBlock) {
                if (!this.harvestNetherwart(blockpos, state, world) || hasPlayedSound) continue;
                world.playSound(null, this.getPos(), SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                hasPlayedSound = true;
                continue;
            }
            if (state.getBlock() instanceof CocoaBlock) {
                if (!this.harvestPods(blockpos, state, world) || hasPlayedSound) continue;
                world.playSound(null, this.getPos(), SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                hasPlayedSound = true;
                continue;
            }
            if (state.is(BlockTagProvider.HARVEST_STEMS) && state.getBlock() == world.getBlockState(blockpos.below()).getBlock()) {
                this.processAndSpawnDrops(blockpos, state, world, false);
                BlockUtil.destroyBlockSafely(world, blockpos, false, null);
                continue;
            }
            if (!(state.getBlock() instanceof CropBlock) || !(cropsBlock = (CropBlock)world.getBlockState(blockpos).getBlock()).isMaxAge(state) || !(world instanceof ServerLevel)) continue;
            if (this.processAndSpawnDrops(blockpos, state, world, true) && !hasPlayedSound) {
                world.playSound(null, this.getPos(), SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                hasPlayedSound = true;
            }
            world.setBlockAndUpdate(blockpos, cropsBlock.getStateForAge(1));
        }
    }

    public boolean harvestNetherwart(BlockPos pos, BlockState state, Level world) {
        if ((Integer)state.getValue((Property)NetherWartBlock.AGE) != 3) {
            return false;
        }
        this.processAndSpawnDrops(pos, state, world, true);
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(0)));
        this.setNeedsSource(true);
        return true;
    }

    public boolean harvestPods(BlockPos pos, BlockState state, Level world) {
        if ((Integer)state.getValue((Property)CocoaBlock.AGE) != 2) {
            return false;
        }
        this.processAndSpawnDrops(pos, state, world, true);
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0)));
        this.setNeedsSource(true);
        return true;
    }

    public boolean processAndSpawnDrops(BlockPos pos, BlockState state, Level world, boolean takeSeedToReplant) {
        List cropDrops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos));
        if (takeSeedToReplant) {
            for (ItemStack i : cropDrops) {
                BlockItem blockItem;
                Item item = i.getItem();
                if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != state.getBlock()) continue;
                i.shrink(1);
                break;
            }
        }
        InventoryManager manager = this.tile.getInventoryManager();
        cropDrops.forEach(d -> {
            if (d.isEmpty() || d.getItem() == BlockRegistry.MAGE_BLOOM_CROP.asItem()) {
                return;
            }
            if (!(d = manager.insertStack((ItemStack)d)).isEmpty()) {
                world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), d));
            }
        });
        this.setNeedsSource(true);
        return true;
    }

    @Override
    public String getLangDescription() {
        return "Casts the Harvest effect on nearby crops. Consumes source each time a set of crops are harvested. If an inventory is adjacent to the brazier, the items will be deposited in them before dropping on the ground.";
    }

    @Override
    public String getLangName() {
        return "Harvest";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.HARVEST);
    }

    @Override
    public int getSourceCost() {
        return 100;
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(50, 180, 50);
    }
}

