/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.RangeRitual;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.Nullable;

public class DenySpawnRitual
extends RangeRitual {
    public int radius = 32;
    public boolean deniedSpawn;

    public boolean denySpawn(FinalizeSpawnEvent checkSpawn) {
        boolean shouldDeny;
        boolean bl = shouldDeny = checkSpawn.getSpawnType() == MobSpawnType.NATURAL && checkSpawn.getEntity() instanceof Enemy && checkSpawn.getEntity().distanceToSqr((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ()) <= (double)(this.radius * this.radius);
        if (shouldDeny) {
            checkSpawn.setSpawnCancelled(true);
            this.deniedSpawn = true;
        }
        return shouldDeny;
    }

    @Override
    public void onStart(@Nullable Player player) {
        super.onStart(player);
        if (this.getWorld().isClientSide) {
            return;
        }
        for (ItemStack i : this.getConsumedItems()) {
            if (!i.is(Items.ROTTEN_FLESH)) continue;
            this.radius += i.getCount();
        }
    }

    @Override
    protected void tick() {
        super.tick();
        if (this.getWorld().isClientSide) {
            return;
        }
        if (this.deniedSpawn && this.getWorld().getGameTime() % 1200L == 0L) {
            this.deniedSpawn = false;
            this.takeSourceNow();
        }
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return stack.is(Items.ROTTEN_FLESH) && this.itemConsumedCount(i -> i.getItem() == Items.ROTTEN_FLESH) < 128;
    }

    @Override
    public int getSourceCost() {
        return 500;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.SANCTUARY);
    }

    @Override
    public String getLangName() {
        return "Sanctuary";
    }

    @Override
    public String getLangDescription() {
        return "Denies hostile mobs from naturally spawning in a 32 block radius. Augment with rotten flesh to increase the radius by 1 each, up to 128. Costs source once a minute if a spawn is denied.";
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        this.radius = tag.getInt("radius");
        this.deniedSpawn = tag.getBoolean("deniedSpawn");
    }

    @Override
    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        super.write(provider, tag);
        tag.putInt("radius", this.radius);
        tag.putBoolean("deniedSpawn", this.deniedSpawn);
    }
}

