/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.AbstractStorageTerminalScreen;
import com.hollingsworth.arsnouveau.client.container.SortSettings;
import com.hollingsworth.arsnouveau.client.container.StorageTerminalMenu;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SetTerminalSettingsPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<SetTerminalSettingsPacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("terminal_settings"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetTerminalSettingsPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(SortSettings.STREAM_CODEC), s -> Optional.ofNullable(s.settings), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), s -> Optional.ofNullable(s.selectedTab), SetTerminalSettingsPacket::new);
    public SortSettings settings;
    public String selectedTab;

    public SetTerminalSettingsPacket(Optional<SortSettings> settings, Optional<String> selectedTab) {
        this((SortSettings)settings.orElse(null), (String)selectedTab.orElse(null));
    }

    public SetTerminalSettingsPacket(SortSettings settings, String selectedTab) {
        this.settings = settings;
        this.selectedTab = selectedTab;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        super.onClientReceived(minecraft, player);
        Screen screen = minecraft.screen;
        if (screen instanceof AbstractStorageTerminalScreen) {
            AbstractStorageTerminalScreen terminalScreen = (AbstractStorageTerminalScreen)screen;
            terminalScreen.receiveSettings(this.settings);
        }
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        super.onServerReceived(minecraftServer, player);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof StorageTerminalMenu) {
            StorageTerminalMenu terminalScreen = (StorageTerminalMenu)abstractContainerMenu;
            terminalScreen.receiveSettings(this.settings, this.selectedTab);
        }
    }
}

