/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class PacketUpdateGlowColor
extends AbstractPacket {
    public int entity;
    public int color;
    public static final CustomPacketPayload.Type<PacketUpdateGlowColor> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("glow_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateGlowColor> CODEC = StreamCodec.ofMember(PacketUpdateGlowColor::toBytes, PacketUpdateGlowColor::new);

    public PacketUpdateGlowColor(int entity, int color) {
        this.entity = entity;
        this.color = color;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf RegistryFriendlyByteBuf2) {
        RegistryFriendlyByteBuf2.writeInt(this.entity);
        RegistryFriendlyByteBuf2.writeInt(this.color);
    }

    public PacketUpdateGlowColor(RegistryFriendlyByteBuf RegistryFriendlyByteBuf2) {
        this.entity = RegistryFriendlyByteBuf2.readInt();
        this.color = RegistryFriendlyByteBuf2.readInt();
    }

    @Override
    public void onClientReceived(Minecraft mc, Player player) {
        Entity entity = player.level.getEntity(this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.color != 0) {
                living.getPersistentData().putInt("GlowColor", this.color);
            } else {
                living.getPersistentData().remove("GlowColor");
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

