/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.common.items.data.PerkMap;
import com.hollingsworth.arsnouveau.common.items.data.StackPerkHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class ArmorPerkHolder
extends StackPerkHolder<ArmorPerkHolder> {
    public static final Codec<ArmorPerkHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("color").forGetter(ArmorPerkHolder::getColor), (App)StackPerkHolder.PERK_CODEC.listOf().fieldOf("perks").forGetter(StackPerkHolder::getPerks), (App)Codec.INT.fieldOf("tier").forGetter(StackPerkHolder::getTier), (App)PerkMap.CODEC.fieldOf("perkTags").forGetter(StackPerkHolder::getPerkTags)).apply((Applicative)instance, ArmorPerkHolder::new));
    private String color;

    public ArmorPerkHolder(String color, List<IPerk> perks, int tier, Map<IPerk, CompoundTag> perkTags) {
        super(perks, tier, perkTags);
        this.color = color;
    }

    public ArmorPerkHolder(String color, List<IPerk> perks, int tier, PerkMap perkTags) {
        super(perks, tier, perkTags);
        this.color = color;
    }

    public ArmorPerkHolder() {
        this("", new ArrayList<IPerk>(), 0, new HashMap<IPerk, CompoundTag>());
    }

    public String getColor() {
        return this.color == null ? DyeColor.PURPLE.getName() : this.color;
    }

    public ArmorPerkHolder setColor(String color) {
        return new ArmorPerkHolder(color, this.getPerks(), this.getTier(), this.getPerkTags());
    }

    @Override
    public ArmorPerkHolder setPerks(List<IPerk> perks) {
        return new ArmorPerkHolder(this.color, perks, this.getTier(), this.getPerkTags());
    }

    @Override
    public List<PerkSlot> getSlotsForTier(ItemStack stack) {
        List<List<PerkSlot>> slotsForTier = PerkRegistry.getPerkProvider(stack.getItem());
        if (slotsForTier == null) {
            return Collections.emptyList();
        }
        ArrayList<PerkSlot> slots = new ArrayList<PerkSlot>((Collection)slotsForTier.get(this.getTier()));
        slots.sort(Comparator.comparingInt(a -> -a.value()));
        return slots;
    }

    @Override
    public ArmorPerkHolder setTier(int tier) {
        return new ArmorPerkHolder(this.color, this.getPerks(), tier, this.getPerkTags());
    }

    @Override
    public ArmorPerkHolder setTagForPerk(IPerk perk, CompoundTag tag) {
        return new ArmorPerkHolder(this.color, this.getPerks(), this.getTier(), this.getPerkTags().put(perk, tag));
    }

    public ArmorPerkHolder setPerkTags(Map<IPerk, CompoundTag> perkTags) {
        return new ArmorPerkHolder(this.color, this.getPerks(), this.getTier(), perkTags);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArmorPerkHolder that = (ArmorPerkHolder)o;
        return Objects.equals(this.color, that.color);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color);
    }
}

