/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellCrossbowRenderer;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.items.FormSpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpellCrossbow
extends CrossbowItem
implements GeoItem,
ICasterTool,
IManaDiscountEquipment {
    private static final CrossbowItem.ChargingSounds DEFAULT_SOUNDS = new CrossbowItem.ChargingSounds(Optional.of(SoundEvents.CROSSBOW_LOADING_START), Optional.of(SoundEvents.CROSSBOW_LOADING_MIDDLE), Optional.of(SoundEvents.CROSSBOW_LOADING_END));
    public AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SpellCrossbow(Item.Properties pProperties) {
        super(pProperties);
    }

    public void releaseUsing(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        int i = this.getUseDuration(pStack, pEntityLiving) - pTimeLeft;
        float f = SpellCrossbow.getPowerForTime((int)i, (ItemStack)pStack, (LivingEntity)pEntityLiving);
        if (f >= 1.0f && !SpellCrossbow.isCharged((ItemStack)pStack) && this.tryLoadProjectiles(pEntityLiving, pStack)) {
            CrossbowItem.ChargingSounds crossbowitem$chargingsounds = EnchantmentHelper.pickHighestLevel((ItemStack)pStack, (DataComponentType)EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS).orElse(DEFAULT_SOUNDS);
            crossbowitem$chargingsounds.end().ifPresent(p_352852_ -> pLevel.playSound(null, pEntityLiving.getX(), pEntityLiving.getY(), pEntityLiving.getZ(), (SoundEvent)p_352852_.value(), pEntityLiving.getSoundSource(), 1.0f, 1.0f / (pLevel.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
        }
    }

    private boolean tryLoadProjectiles(LivingEntity pShooter, ItemStack pCrossbowStack) {
        Item item;
        if (pShooter.level().isClientSide) {
            return true;
        }
        int multishotLevel = EnchantmentHelper.getTagEnchantmentLevel((Holder)pShooter.level.holderOrThrow(Enchantments.MULTISHOT), (ItemStack)pCrossbowStack);
        int numProjectiles = multishotLevel == 0 ? 1 : 3;
        boolean isCreative = pShooter instanceof Player && ((Player)pShooter).getAbilities().instabuild;
        ItemStack ammoStack = pShooter.getProjectile(pCrossbowStack);
        ItemStack ammoCopy = ammoStack.copy();
        AbstractCaster caster = this.getSpellCaster(pCrossbowStack);
        SpellResolver resolver = new SpellResolver(new SpellContext(pShooter.level, caster.modifySpellBeforeCasting((ServerLevel)pShooter.level, (Entity)pShooter, InteractionHand.MAIN_HAND, caster.getSpell()), pShooter, LivingCaster.from(pShooter), pCrossbowStack));
        boolean consumedMana = false;
        if (!(pShooter instanceof Player) || resolver.withSilent(true).canCast(pShooter)) {
            resolver.expendMana();
            consumedMana = true;
            numProjectiles += resolver.spell.getBuffsAtIndex(0, pShooter, AugmentSplit.INSTANCE);
        }
        if ((item = ammoStack.getItem()) instanceof FormSpellArrow) {
            FormSpellArrow formSpellArrow = (FormSpellArrow)item;
            if (formSpellArrow.part == AugmentSplit.INSTANCE) {
                numProjectiles += formSpellArrow.numParts;
            }
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int k = 0; k < numProjectiles; ++k) {
            ItemStack checkedAmmo;
            if (k > 0) {
                ammoStack = ammoCopy.copy();
            }
            if (ammoStack.isEmpty() && isCreative) {
                ammoStack = new ItemStack((ItemLike)Items.ARROW);
                ammoCopy = ammoStack.copy();
            }
            if ((checkedAmmo = SpellCrossbow.useAmmo((ItemStack)pCrossbowStack, (ItemStack)ammoStack, (LivingEntity)pShooter, (k > 0 ? 1 : 0) != 0)).isEmpty()) continue;
            stacks.add(checkedAmmo);
        }
        if (!stacks.isEmpty()) {
            pCrossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(stacks));
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("isSpell", true);
            pCrossbowStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return true;
    }

    public void shootOne(Level worldIn, LivingEntity pShooter, InteractionHand pHand, ItemStack pCrossbowStack, ItemStack pAmmoStack, float pSoundPitch, boolean pIsCreativeMode, float pVelocity, float pInaccuracy, float pProjectileAngle, boolean isSpell) {
        if (!worldIn.isClientSide) {
            Object projectile;
            boolean flag = pAmmoStack.is(Items.FIREWORK_ROCKET);
            if (flag) {
                projectile = new FireworkRocketEntity(worldIn, pAmmoStack, (Entity)pShooter, pShooter.getX(), pShooter.getEyeY() - (double)0.15f, pShooter.getZ(), true);
            } else {
                projectile = this.getArrow(worldIn, pShooter, pCrossbowStack, pAmmoStack);
                if (pIsCreativeMode || pProjectileAngle != 0.0f) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            LivingCaster livingCaster = pShooter instanceof Player ? new PlayerCaster((Player)pShooter) : new LivingCaster(pShooter);
            AbstractCaster caster = this.getSpellCaster(pCrossbowStack);
            SpellResolver resolver = new SpellResolver(new SpellContext(worldIn, caster.modifySpellBeforeCasting((ServerLevel)worldIn, (Entity)pShooter, InteractionHand.MAIN_HAND, caster.getSpell()), pShooter, livingCaster, pCrossbowStack));
            if (isSpell) {
                projectile = this.buildSpellArrow(worldIn, pShooter, caster, pCrossbowStack, pAmmoStack);
                ((EntitySpellArrow)((Object)projectile)).pierceLeft += EnchantmentHelper.getTagEnchantmentLevel((Holder)worldIn.holderOrThrow(Enchantments.PIERCING), (ItemStack)pCrossbowStack);
            } else if (pAmmoStack.getItem() instanceof SpellArrow && projectile instanceof EntitySpellArrow) {
                EntitySpellArrow spellArrow = (EntitySpellArrow)((Object)projectile);
                spellArrow.pierceLeft += EnchantmentHelper.getTagEnchantmentLevel((Holder)worldIn.holderOrThrow(Enchantments.PIERCING), (ItemStack)pCrossbowStack);
                spellArrow.setColors(resolver.spell.color());
            }
            Vec3 vec31 = pShooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(pProjectileAngle * ((float)Math.PI / 180)), vec31.x, vec31.y, vec31.z);
            Vec3 vec3 = pShooter.getViewVector(1.0f);
            Vector3f vector3f = vec3.toVector3f().rotate((Quaternionfc)quaternionf);
            projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), pVelocity, pInaccuracy);
            worldIn.addFreshEntity((Entity)projectile);
            worldIn.playSound(null, pShooter.getX(), pShooter.getY(), pShooter.getZ(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    private AbstractArrow getArrow(Level pLevel, LivingEntity pLivingEntity, ItemStack pCrossbowStack, ItemStack pAmmoStack) {
        ArrowItem arrowitem = (ArrowItem)(pAmmoStack.getItem() instanceof ArrowItem ? pAmmoStack.getItem() : Items.ARROW);
        AbstractArrow abstractarrow = arrowitem.createArrow(pLevel, pAmmoStack, pLivingEntity, pCrossbowStack);
        if (pLivingEntity instanceof Player) {
            abstractarrow.setCritArrow(true);
        }
        abstractarrow.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        return abstractarrow;
    }

    public void performShooting(@NotNull Level pLevel, @NotNull LivingEntity pShooter, @NotNull InteractionHand pUsedHand, @NotNull ItemStack pCrossbowStack, float pVelocity, float pInaccuracy, @Nullable LivingEntity pTarget) {
        Player player;
        if (pShooter instanceof Player && EventHooks.onArrowLoose((ItemStack)pCrossbowStack, (Level)pShooter.level, (Player)(player = (Player)pShooter), (int)1, (boolean)true) < 0) {
            return;
        }
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)pCrossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        if (chargedprojectiles == null) {
            return;
        }
        CustomData customData = (CustomData)pCrossbowStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = customData != null ? customData.getUnsafe() : new CompoundTag();
        boolean isSpell = tag.getBoolean("isSpell");
        for (int i = 0; i < chargedprojectiles.getItems().size(); ++i) {
            boolean isOdd;
            boolean flag;
            ItemStack itemstack = (ItemStack)chargedprojectiles.getItems().get(i);
            boolean bl = flag = pShooter instanceof Player && ((Player)pShooter).getAbilities().instabuild;
            if (itemstack.isEmpty()) continue;
            float offset = 10.0f * (float)((i > 0 ? 1 + i : 0) / 2);
            boolean bl2 = isOdd = i % 2 == 1;
            if (isOdd) {
                offset *= -1.0f;
            }
            this.shootOne(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, i == 0 ? 1.0f : SpellCrossbow.getRandomShotPitch((isOdd == pShooter.getRandom().nextBoolean() ? 1 : 0) != 0, (RandomSource)pShooter.getRandom()), flag, pVelocity, pInaccuracy, offset, isSpell);
        }
        if (pShooter instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pShooter;
            if (!pLevel.isClientSide) {
                CriteriaTriggers.SHOT_CROSSBOW.trigger(serverplayer, pCrossbowStack);
            }
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)pCrossbowStack.getItem()));
        }
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return super.getAllSupportedProjectiles().or(i -> i.getItem() instanceof SpellArrow);
    }

    public EntitySpellArrow buildSpellArrow(Level worldIn, LivingEntity playerentity, AbstractCaster<?> caster, ItemStack bowStack, ItemStack arrowStack) {
        EntitySpellArrow spellArrow = new EntitySpellArrow(worldIn, playerentity, arrowStack, bowStack);
        spellArrow.spellResolver = new SpellResolver(new SpellContext(worldIn, caster.getSpell(), playerentity, LivingCaster.from(playerentity), playerentity.getMainHandItem())).withSilent(true);
        spellArrow.setColors(caster.getColor());
        return spellArrow;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        if (Screen.hasShiftDown() || !((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue()) {
            this.getInformation(stack, context, tooltip2, flagIn);
        }
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        if (caster != null && ((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !Screen.hasShiftDown() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }

    @Override
    public boolean isScribedSpellValid(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.unsafeList().stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    @Override
    public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.bow.invalid"));
    }

    @Override
    public void scribeModifiedSpell(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell.Mutable spell) {
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        recipe.add(MethodProjectile.INSTANCE);
        recipe.addAll(spell.recipe);
        spell.recipe = recipe;
    }

    @Override
    public int getManaDiscount(ItemStack i, Spell spell) {
        return MethodProjectile.INSTANCE.getCastingCost();
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private final BlockEntityWithoutLevelRenderer renderer = new SpellCrossbowRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

