/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellBookRenderer;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetCasterSlot;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpellBook
extends ModItem
implements GeoItem,
ICasterTool,
IDyeable,
IRadialProvider {
    public SpellTier tier;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SpellBook(SpellTier tier) {
        this(new Item.Properties().stacksTo(1).component(DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster(10)), tier);
    }

    public SpellBook(Item.Properties properties, SpellTier tier) {
        super(properties);
        this.tier = tier;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ManaCap iMana;
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (this != ItemsRegistry.CREATIVE_SPELLBOOK.get() && (iMana = CapabilityRegistry.getMana((LivingEntity)playerIn)) != null) {
            boolean shouldSync = false;
            if (iMana.getBookTier() < this.tier.value) {
                iMana.setBookTier(this.tier.value);
                shouldSync = true;
            }
            ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)playerIn);
            if (iMana.getGlyphBonus() < cap.getKnownGlyphs().size()) {
                iMana.setGlyphBonus(cap.getKnownGlyphs().size());
                shouldSync = true;
            }
            if (shouldSync && playerIn instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)playerIn;
                iMana.syncToClient(player);
            }
        }
        AbstractCaster caster = this.getSpellCaster(stack);
        return caster.castSpell(worldIn, (LivingEntity)playerIn, handIn, (Component)Component.translatable((String)"ars_nouveau.invalid_spell"));
    }

    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, world, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell_book.select", (Object[])new Object[]{KeyMapping.createNameSupplier((String)ModKeyBindings.OPEN_RADIAL_HUD.getName()).get()}));
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell_book.craft", (Object[])new Object[]{KeyMapping.createNameSupplier((String)ModKeyBindings.OPEN_BOOK.getName()).get()}));
        tooltip.add((Component)Component.translatable((String)"tooltip.ars_nouveau.caster_level", (Object[])new Object[]{this.getTier().value}).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
    }

    public SpellTier getTier() {
        return this.tier;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private final BlockEntityWithoutLevelRenderer renderer = new SpellBookRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onOpenBookMenuKeyPressed(ItemStack stack, Player player) {
        InteractionHand hand = StackUtil.getBookHand(player);
        if (hand == null) {
            return;
        }
        Minecraft.getInstance().setScreen((Screen)new GuiSpellBook(hand));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        Minecraft.getInstance().setScreen(new GuiRadialMenu<AbstractSpellPart>(this.getRadialMenuProviderForSpellpart(stack)));
    }

    public RadialMenu<AbstractSpellPart> getRadialMenuProviderForSpellpart(ItemStack itemStack) {
        return new RadialMenu<AbstractSpellPart>(slot -> Networking.sendToServer(new PacketSetCasterSlot(slot)), this.getRadialMenuSlotsForSpellpart(itemStack), RenderUtils::drawSpellPart, 0);
    }

    public List<RadialMenuSlot<AbstractSpellPart>> getRadialMenuSlotsForSpellpart(ItemStack itemStack) {
        AbstractCaster<?> spellCaster = SpellCasterRegistry.from(itemStack);
        ArrayList<RadialMenuSlot<AbstractSpellPart>> radialMenuSlots = new ArrayList<RadialMenuSlot<AbstractSpellPart>>();
        for (int i = 0; i < spellCaster.getMaxSlots(); ++i) {
            Spell spell = spellCaster.getSpell(i);
            AbstractSpellPart primaryIcon = null;
            ArrayList<AbstractSpellPart> secondaryIcons = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart p : spell.recipe()) {
                if (p instanceof AbstractCastMethod) {
                    secondaryIcons.add(p);
                }
                if (!(p instanceof AbstractEffect)) continue;
                primaryIcon = p;
                break;
            }
            radialMenuSlots.add(new RadialMenuSlot<Object>(spellCaster.getSpellName(i), primaryIcon, (List<Object>)secondaryIcons));
        }
        return radialMenuSlots;
    }

    @Override
    public boolean canQuickCast() {
        return true;
    }
}

