/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.renderer.item.MobJarItemRenderer;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.items.data.MobJarData;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MobJarItem
extends BlockItem
implements GeoItem {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MobJarItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            final MobJarItemRenderer renderer = new MobJarItemRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        super.appendHoverText(stack, pLevel, pTooltip, pFlag);
        Entity entity = MobJarItem.fromItem(stack, ArsNouveau.proxy.getClientWorld());
        if (entity == null) {
            return;
        }
        pTooltip.add(entity.getDisplayName());
        if (entity.hasCustomName()) {
            MutableComponent name = entity.getType().getDescription().copy();
            name.withStyle(ChatFormatting.GRAY);
            pTooltip.add((Component)name);
        }
        if (entity.getType().is(EntityTags.DRYGMY_BLACKLIST)) {
            MutableComponent blacklisted = Component.translatable((String)"ars_nouveau.drygmy.blacklist").withStyle(ChatFormatting.DARK_RED);
            pTooltip.add((Component)blacklisted);
        }
    }

    public static Entity fromItem(ItemStack stack, Level level) {
        MobJarData jarData = (MobJarData)stack.get(DataComponentRegistry.MOB_JAR);
        if (jarData == null) {
            return null;
        }
        CompoundTag entityTag = jarData.entityTag().orElse(new CompoundTag());
        if (entityTag.isEmpty()) {
            return null;
        }
        return MobJarTile.loadEntityFromTag(level, entityTag);
    }
}

