/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.api.registry.PotionProviderRegistry;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.client.renderer.item.FlaskCannonRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.items.AlchemistsCrown;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.PotionLauncherData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetLauncher;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class FlaskCannon
extends ModItem
implements IRadialProvider,
GeoItem {
    public AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FlaskCannon(Item.Properties properties) {
        super(properties.component(DataComponentRegistry.POTION_LAUNCHER, (Object)new PotionLauncherData()));
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        return InteractionResult.FAIL;
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pLevel.isClientSide) {
            return;
        }
        if (!(pEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)pEntity;
        PotionLauncherData potionLauncherData = (PotionLauncherData)pStack.getOrDefault(DataComponentRegistry.POTION_LAUNCHER, (Object)new PotionLauncherData());
        int lastSlot = potionLauncherData.lastSlot();
        if (lastSlot < 0 || lastSlot >= player.inventory.getContainerSize()) {
            return;
        }
        ItemStack item = player.inventory.getItem(lastSlot);
        if (potionLauncherData.amountLeft((Player)player) > 0 && PotionProviderRegistry.from(item) == null && !(item.getItem() instanceof PotionItem)) {
            pStack.set(DataComponentRegistry.POTION_LAUNCHER, (Object)new PotionLauncherData(potionLauncherData.renderData(), lastSlot));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        PotionLauncherData potionLauncherData = (PotionLauncherData)itemstack.get(DataComponentRegistry.POTION_LAUNCHER);
        if (pLevel.isClientSide) {
            return InteractionResultHolder.consume((Object)itemstack);
        }
        ItemStack selectedPotion = potionLauncherData.getSelectedStack(pPlayer);
        IPotionProvider potionData = potionLauncherData.getPotionDataFromSlot(pPlayer);
        if (potionData == null || PotionUtil.isEmpty(potionData.getPotionData(selectedPotion)) || potionData.usesRemaining(selectedPotion) <= 0) {
            PortUtil.sendMessage((Entity)pPlayer, (Component)Component.translatable((String)"ars_nouveau.flask_cannon.no_potion"));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
        }
        ThrownPotion thrownpotion = new ThrownPotion(pLevel, (LivingEntity)pPlayer);
        ItemStack stckToThrow = this.getThrownStack(pLevel, pPlayer, pHand, itemstack);
        PotionContents contents = (PotionContents)stckToThrow.get(DataComponents.POTION_CONTENTS);
        if (contents == PotionContents.EMPTY) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        thrownpotion.setItem(stckToThrow);
        thrownpotion.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), -20.0f, 0.5f, 1.0f);
        pLevel.addFreshEntity((Entity)thrownpotion);
        pPlayer.getCooldowns().addCooldown((Item)this, 10);
        itemstack.set(DataComponentRegistry.POTION_LAUNCHER, (Object)new PotionLauncherData(contents, potionLauncherData.lastSlot()));
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)itemstack);
    }

    public abstract ItemStack getThrownStack(Level var1, Player var2, InteractionHand var3, ItemStack var4);

    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int forKey() {
        return ModKeyBindings.OPEN_RADIAL_HUD.getKey().getValue();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        ArrayList slots = new ArrayList();
        for (int i = 0; i < player.inventory.getContainerSize() && slots.size() < 9; ++i) {
            ItemStack item = player.inventory.getItem(i);
            PotionContents contents = PotionUtil.getContents(item);
            if (PotionUtil.isEmpty(contents) || item.getItem() instanceof ArrowItem) continue;
            slots.add(new RadialMenuSlot<AlchemistsCrown.SlotData>(item.getHoverName().getString(), new AlchemistsCrown.SlotData(i, item)));
        }
        if (slots.isEmpty()) {
            PortUtil.sendMessage((Entity)Minecraft.getInstance().player, (Component)Component.translatable((String)"ars_nouveau.alchemists_crown.no_flasks"));
            return;
        }
        Minecraft.getInstance().setScreen(new GuiRadialMenu<AlchemistsCrown.SlotData>(new RadialMenu<AlchemistsCrown.SlotData>(index -> Networking.sendToServer(new PacketSetLauncher(((AlchemistsCrown.SlotData)((RadialMenuSlot)slots.get(index)).primarySlotIcon()).getSlot())), slots, (slotData, posestack, positionx, posy, size, transparent) -> RenderUtils.drawItemAsIcon(slotData.getStack(), posestack, positionx, posy, size, transparent), 3)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public static class LingeringLauncher
    extends FlaskCannon {
        public LingeringLauncher(Item.Properties properties) {
            super(properties);
        }

        @Override
        public ItemStack getThrownStack(Level pLevel, Player pPlayer, InteractionHand pHand, ItemStack launcherStack) {
            PotionLauncherData data = (PotionLauncherData)launcherStack.getOrDefault(DataComponentRegistry.POTION_LAUNCHER, (Object)new PotionLauncherData());
            ItemStack splashStack = new ItemStack((ItemLike)Items.LINGERING_POTION);
            PotionContents potionData = data.expendPotion(pPlayer, launcherStack);
            splashStack.set(DataComponents.POTION_CONTENTS, (Object)potionData);
            return splashStack;
        }

        public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
            consumer.accept(new GeoRenderProvider(this){
                private final BlockEntityWithoutLevelRenderer renderer = new FlaskCannonRenderer(new GenericModel("lingering_flask_cannon", "item").withEmptyAnim());

                public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                    return this.renderer;
                }
            });
        }
    }

    public static class SplashLauncher
    extends FlaskCannon {
        public SplashLauncher(Item.Properties properties) {
            super(properties);
        }

        @Override
        public ItemStack getThrownStack(Level pLevel, Player pPlayer, InteractionHand pHand, ItemStack launcherStack) {
            PotionLauncherData data = (PotionLauncherData)launcherStack.getOrDefault(DataComponentRegistry.POTION_LAUNCHER, (Object)new PotionLauncherData());
            ItemStack splashStack = new ItemStack((ItemLike)Items.SPLASH_POTION);
            PotionContents potionData = data.expendPotion(pPlayer, launcherStack);
            splashStack.set(DataComponents.POTION_CONTENTS, (Object)potionData);
            return splashStack;
        }

        public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
            consumer.accept(new GeoRenderProvider(this){
                private final BlockEntityWithoutLevelRenderer renderer = new FlaskCannonRenderer(new GenericModel("splash_flask_cannon", "item").withEmptyAnim());

                public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                    return this.renderer;
                }
            });
        }
    }
}

