/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.DominionWandData;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateDominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DominionWand
extends ModItem
implements IRadialProvider {
    public DominionWand() {
        super(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData()));
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pIsSelected || pLevel.isClientSide || pLevel.getGameTime() % 5L != 0L) {
            return;
        }
        DominionWandData data = (DominionWandData)pStack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.storedPos().isPresent()) {
            BlockEntity blockEntity = pLevel.getBlockEntity(data.storedPos().get());
            if (blockEntity instanceof IWandable) {
                IWandable wandable = (IWandable)blockEntity;
                Networking.sendToPlayerClient(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
            }
            return;
        }
        Entity entity = pLevel.getEntity(data.getStoredEntity());
        if (entity instanceof IWandable) {
            IWandable wandable = (IWandable)entity;
            Networking.sendToPlayerClient(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack doNotUseStack, Player playerEntity, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        IWandable wandable;
        BlockEntity blockEntity;
        if (playerEntity.level.isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = playerEntity.getItemInHand(hand);
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (playerEntity.isShiftKeyDown() && target instanceof IWandable) {
            IWandable wandable2 = (IWandable)target;
            wandable2.onWanded(playerEntity);
            this.clear(stack, playerEntity);
            return InteractionResult.SUCCESS;
        }
        if (!data.hasStoredData()) {
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data.storeEntity(target.getId()));
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.stored_entity"));
            return InteractionResult.SUCCESS;
        }
        Level world = playerEntity.getCommandSenderWorld();
        if (data.storedPos().isPresent() && (blockEntity = world.getBlockEntity(data.storedPos().get())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(data.storedPos().orElse(null), data.face().orElse(null), target, playerEntity);
        }
        if (target instanceof IWandable) {
            wandable = (IWandable)target;
            wandable.onFinishedConnectionLast(data.storedPos().orElse(null), data.face().orElse(null), target, playerEntity);
            this.clear(stack, playerEntity);
        }
        if (playerEntity.isShiftKeyDown() && target instanceof IDecoratable) {
            IDecoratable coolBoy = (IDecoratable)target;
            coolBoy.setCosmeticItem(ItemStack.EMPTY);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return false;
    }

    public void clear(ItemStack stack, Player player) {
        DominionWandData data = ((DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData())).setFace(null).storeEntity(-1).storePos(null);
        stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        IWandable wandable;
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (context.getLevel().isClientSide || context.getPlayer() == null) {
            return super.useOn(context);
        }
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        Level world = context.getLevel();
        Player playerEntity = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (playerEntity.isShiftKeyDown() && (blockEntity2 = world.getBlockEntity(pos)) instanceof IWandable) {
            IWandable wandable2 = (IWandable)blockEntity2;
            if (!data.hasStoredData()) {
                wandable2.onWanded(playerEntity);
                this.clear(stack, playerEntity);
                return InteractionResult.CONSUME;
            }
        }
        if (!data.hasStoredData()) {
            if ((data = data.storePos(pos.immutable())).strict()) {
                data = data.setFace(face);
            }
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_set"));
            return InteractionResult.SUCCESS;
        }
        BlockPos storedPos = data.storedPos().orElse(null);
        Direction storedDirection = data.face().orElse(null);
        if (storedPos != null && (blockEntity = world.getBlockEntity(storedPos)) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(pos, storedDirection, (LivingEntity)world.getEntity(data.storedEntityId()), playerEntity);
        }
        if ((blockEntity = world.getBlockEntity(pos)) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionLast(storedPos, storedDirection, (LivingEntity)world.getEntity(data.storedEntityId()), playerEntity);
        }
        if (data.storedEntityId() != -1 && (blockEntity = world.getEntity(data.storedEntityId())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(pos, (Direction)(data.strict() ? face : null), null, playerEntity);
        }
        this.clear(stack, playerEntity);
        return super.useOn(context);
    }

    @NotNull
    public String getDescriptionId(ItemStack pStack) {
        DominionWandData data = (DominionWandData)pStack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.strict()) {
            return super.getDescriptionId(pStack) + ".strict";
        }
        return super.getDescriptionId(pStack);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext world, @NotNull List<Component> tooltip, @NotNull TooltipFlag p_77624_4_) {
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.storedEntityId() == -1) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.no_entity"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.entity_stored"));
        }
        if (data.storedPos().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.no_location"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_stored", (Object[])new Object[]{DominionWand.getPosString(data.getValidPos())}));
        }
        if (data.strict()) {
            tooltip.add((Component)Component.literal((String)"Side-Sensitive"));
        }
    }

    public static String getPosString(BlockPos pos) {
        return Component.translatable((String)"ars_nouveau.position", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).getString();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        Minecraft.getInstance().setScreen(new GuiRadialMenu<String>(this.getRadialMenuProviderForDominion(stack)));
    }

    public RadialMenu<String> getRadialMenuProviderForDominion(ItemStack stack) {
        return new RadialMenu<String>(slot -> Networking.sendToServer(new PacketUpdateDominionWand(slot)), this.getRadialMenuSlotsForDominion(stack), RenderUtils::drawString, 0);
    }

    public List<RadialMenuSlot<String>> getRadialMenuSlotsForDominion(ItemStack stack) {
        ArrayList<RadialMenuSlot<String>> radialMenuSlots = new ArrayList<RadialMenuSlot<String>>();
        radialMenuSlots.add(new RadialMenuSlot<String>(DominionSlots.CLEAR.translatable().getString(), DominionSlots.CLEAR.key));
        radialMenuSlots.add(new RadialMenuSlot<String>(DominionSlots.NORMAL.translatable().getString(), DominionSlots.NORMAL.key));
        radialMenuSlots.add(new RadialMenuSlot<String>(DominionSlots.STRICT.translatable().getString(), DominionSlots.STRICT.key));
        return radialMenuSlots;
    }

    public static enum DominionSlots {
        CLEAR("ars_nouveau.dominion_wand.clear"),
        NORMAL("ars_nouveau.dominion_wand.normal"),
        STRICT("ars_nouveau.dominion_wand.strict");

        public final String key;

        private DominionSlots(String key) {
            this.key = key;
        }

        public Component translatable() {
            return Component.translatable((String)this.key);
        }
    }
}

