/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.perk.IEffectResolvePerk;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.perk.TotemPerk;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import oshi.util.tuples.Pair;

@EventBusSubscriber(modid="ars_nouveau")
public class PerkEvents {
    @SubscribeEvent
    public static void equipmentChangedEvent(LivingEquipmentChangeEvent event) {
        if (!event.getEntity().level.isClientSide) {
            List<PerkInstance> toInstances;
            if (event.getSlot().getType() != EquipmentSlot.Type.HUMANOID_ARMOR) {
                return;
            }
            List<PerkInstance> perkInstances = PerkUtil.getPerksFromItem(event.getFrom());
            if (perkInstances.equals(toInstances = PerkUtil.getPerksFromItem(event.getTo()))) {
                return;
            }
            ArrayList<IPerk> playerPerks = new ArrayList<IPerk>(PerkUtil.getPerksFromLiving(event.getEntity()).stream().map(PerkInstance::getPerk).toList());
            List<IPerk> itemPerks = PerkUtil.getPerksFromItem(event.getTo()).stream().map(PerkInstance::getPerk).toList();
            for (IPerk perk : itemPerks) {
                playerPerks.remove(perk);
            }
            for (IPerk equippedPerks : playerPerks) {
                if (!itemPerks.contains(equippedPerks)) continue;
                PortUtil.sendMessageNoSpam((Entity)event.getEntity(), (Component)Component.translatable((String)"ars_nouveau.perks.duplicated"));
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCast(SpellCastEvent spellCastEvent) {
        PerkUtil.getPerksFromLiving(spellCastEvent.getEntity()).forEach(perkInstance -> {
            IPerk perk = perkInstance.getPerk();
            if (perk instanceof IEffectResolvePerk) {
                ((IEffectResolvePerk)((Object)perk)).onSpellCast(spellCastEvent, (PerkInstance)perkInstance);
            }
        });
    }

    @SubscribeEvent
    public static void preSpellResolve(SpellResolveEvent.Pre event) {
        PerkUtil.getPerksFromLiving(event.shooter).forEach(perkInstance -> {
            IPerk perk = perkInstance.getPerk();
            if (perk instanceof IEffectResolvePerk) {
                ((IEffectResolvePerk)((Object)perk)).onSpellPreResolve(event, (PerkInstance)perkInstance);
            }
        });
    }

    @SubscribeEvent
    public static void postSpellResolve(SpellResolveEvent.Post event) {
        PerkUtil.getPerksFromLiving(event.shooter).forEach(perkInstance -> {
            IPerk perk = perkInstance.getPerk();
            if (perk instanceof IEffectResolvePerk) {
                ((IEffectResolvePerk)((Object)perk)).onSpellPostResolve(event, (PerkInstance)perkInstance);
            }
        });
    }

    @SubscribeEvent
    public static void preEffectResolve(EffectResolveEvent.Pre event) {
        PerkUtil.getPerksFromLiving(event.shooter).forEach(perkInstance -> {
            IPerk perk = perkInstance.getPerk();
            if (perk instanceof IEffectResolvePerk) {
                ((IEffectResolvePerk)((Object)perk)).onEffectPreResolve(event, (PerkInstance)perkInstance);
            }
        });
    }

    @SubscribeEvent
    public static void postEffectResolve(EffectResolveEvent.Post event) {
        PerkUtil.getPerksFromLiving(event.shooter).forEach(perkInstance -> {
            IPerk perk = perkInstance.getPerk();
            if (perk instanceof IEffectResolvePerk) {
                ((IEffectResolvePerk)((Object)perk)).onEffectPostResolve(event, (PerkInstance)perkInstance);
            }
        });
    }

    @SubscribeEvent
    public static void preSpellDamageEvent(SpellDamageEvent.Pre event) {
        PerkUtil.getPerksFromLiving(event.caster).forEach(perkInstance -> {
            IPerk perk = perkInstance.getPerk();
            if (perk instanceof IEffectResolvePerk) {
                ((IEffectResolvePerk)((Object)perk)).onPreSpellDamageEvent(event, (PerkInstance)perkInstance);
            }
        });
    }

    @SubscribeEvent
    public static void postSpellDamageEvent(SpellDamageEvent.Post event) {
        PerkUtil.getPerksFromLiving(event.caster).forEach(perkInstance -> {
            IPerk perk = perkInstance.getPerk();
            if (perk instanceof IEffectResolvePerk) {
                ((IEffectResolvePerk)((Object)perk)).onPostSpellDamageEvent(event, (PerkInstance)perkInstance);
            }
        });
    }

    @SubscribeEvent
    public static void totemEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Pair<ItemStack, ArmorPerkHolder> holder = PerkUtil.getHolderForPerk(TotemPerk.INSTANCE, entity);
        if (holder == null) {
            return;
        }
        CompoundTag tag = ((ArmorPerkHolder)holder.getB()).getTagForPerk(TotemPerk.INSTANCE);
        if (tag == null || !tag.getBoolean("isActive")) {
            return;
        }
        entity.setHealth(1.0f);
        entity.removeAllEffects();
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        entity.level.broadcastEntityEvent((Entity)entity, (byte)35);
        tag.putBoolean("isActive", false);
        ((ItemStack)holder.getA()).set(DataComponentRegistry.ARMOR_PERKS, (Object)((ArmorPerkHolder)holder.getB()).setTagForPerk(TotemPerk.INSTANCE, tag));
        PortUtil.sendMessage((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.totem_perk.trigger"));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void sleepEvent(SleepFinishedTimeEvent event) {
        for (Player p : event.getLevel().players()) {
            Pair<ItemStack, ArmorPerkHolder> holder = PerkUtil.getHolderForPerk(TotemPerk.INSTANCE, (LivingEntity)p);
            if (holder == null) continue;
            CompoundTag tag = ((ArmorPerkHolder)holder.getB()).getTagForPerk(TotemPerk.INSTANCE);
            if (tag != null) {
                tag.putBoolean("isActive", true);
                ((ItemStack)holder.getA()).set(DataComponentRegistry.ARMOR_PERKS, (Object)((ArmorPerkHolder)holder.getB()).setTagForPerk(TotemPerk.INSTANCE, tag));
            }
            PortUtil.sendMessage((Entity)p, (Component)Component.translatable((String)"ars_nouveau.totem_perk.active"));
        }
    }
}

