/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class ManaCapEvents {
    public static double MEAN_TPS = 20.0;

    @SubscribeEvent
    public static void playerOnTick(PlayerTickEvent.Pre e) {
        boolean forceSync;
        ServerPlayer serverPlayer;
        Player player;
        block8: {
            block7: {
                player = e.getEntity();
                if (!(player instanceof ServerPlayer)) break block7;
                serverPlayer = (ServerPlayer)player;
                if (player.getCommandSenderWorld().getGameTime() % (long)((Integer)ServerConfig.REGEN_INTERVAL.get()).intValue() == 0L) break block8;
            }
            return;
        }
        ManaCap mana = CapabilityRegistry.getMana((LivingEntity)player);
        if (mana == null) {
            return;
        }
        boolean sync = false;
        boolean bl = forceSync = player.level().getGameTime() % 60L == 0L;
        if (mana.getCurrentMana() != (double)mana.getMaxMana() || forceSync) {
            double regenPerSecond = ManaUtil.getManaRegen(player) / (double)Math.max(1, (int)MEAN_TPS / (Integer)ServerConfig.REGEN_INTERVAL.get());
            mana.addMana(regenPerSecond);
            sync = true;
        }
        ManaUtil.Mana maxmana = ManaUtil.calcMaxMana(player);
        int max = maxmana.getRealMax();
        if (mana.getMaxMana() != max || forceSync) {
            mana.setMaxMana(max);
            mana.setReserve(maxmana.Reserve());
            sync = true;
        }
        if (sync) {
            mana.syncToClient(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        ManaCapEvents.syncPlayerEvent(e.getEntity());
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.StartTracking e) {
        ManaCapEvents.syncPlayerEvent(e.getEntity());
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        ManaCapEvents.syncPlayerEvent(e.getEntity());
    }

    public static void syncPlayerEvent(Player playerEntity) {
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            ManaCap mana = CapabilityRegistry.getMana((LivingEntity)playerEntity);
            if (mana != null) {
                ManaUtil.Mana manaCalc = ManaUtil.calcMaxMana(playerEntity);
                mana.setMaxMana(manaCalc.getRealMax());
                mana.setReserve(manaCalc.Reserve());
                mana.syncToClient(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Post e) {
        Player player = e.getEntity();
        if (player.level.isClientSide) {
            return;
        }
        if (player.level.getGameTime() % 600L == 0L && player.getServer() != null) {
            double meanTickTime = (double)ManaCapEvents.mean(player.getServer().getTickTime(player.level.dimension())) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            MEAN_TPS = Math.max(1.0, meanTPS);
        }
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

