/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;

public class FamiliarWixie
extends FlyingFamiliarEntity
implements IAnimationListener {
    public int debuffCooldown;

    public FamiliarWixie(EntityType<? extends PathfinderMob> ent, Level world) {
        super(ent, world);
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.level().isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.getMainHandItem().is(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.entityData.get(COLOR)).equals(color.getName()) || !Arrays.asList(EntityWixie.COLORS).contains(color.getName())) {
                return InteractionResult.SUCCESS;
            }
            this.setColor(color);
            return InteractionResult.SUCCESS;
        }
        for (BrewingRecipe r : ArsNouveauAPI.getInstance().getAllPotionRecipes(this.level())) {
            PotionContents contents;
            ItemStack water = PotionUtil.getPotion((Holder<Potion>)Potions.WATER);
            ItemStack awkward = PotionUtil.getPotion((Holder<Potion>)Potions.AWKWARD);
            if (!r.isIngredient(stack) || !r.getInput().test(awkward) && !r.getInput().test(water) || PotionUtil.isEmpty(contents = PotionUtil.getContents(r.getOutput()))) continue;
            PotionUtil.applyContents(contents, (LivingEntity)player, (LivingEntity)player, (LivingEntity)player);
            ItemStack potionStack = new ItemStack((ItemLike)Items.POTION);
            potionStack.set(DataComponents.POTION_CONTENTS, (Object)contents);
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.wixie_familiar.applied", (Object[])new Object[]{potionStack.getHoverName().getString()}));
            Networking.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new PacketAnimEntity(this.getId(), EntityWixie.Animations.CAST.ordinal()));
            ParticleUtil.spawnPoof((ServerLevel)this.level(), player.blockPosition().above());
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void potionEvent(MobEffectEvent.Added event) {
        boolean isApplierOwner;
        if (!this.isAlive() || event.getEffectInstance() == null) {
            return;
        }
        LivingEntity target = event.getEntity();
        Entity applier = event.getEffectSource();
        boolean isBeneficialOwner = target.equals((Object)this.getOwner()) && ((MobEffect)event.getEffectInstance().getEffect().value()).isBeneficial();
        boolean bl = isApplierOwner = applier != null && applier.equals((Object)this.getOwner());
        if (isBeneficialOwner || isApplierOwner) {
            event.getEffectInstance().mapDuration(duration -> duration + duration * 2);
        }
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new DebuffTargetGoal(this));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide && this.debuffCooldown > 0) {
            --this.debuffCooldown;
        }
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_FAMILIAR_WIXIE.get();
    }

    @Override
    public void startAnimation(int arg) {
        if (this.controller == null) {
            return;
        }
        if (arg == EntityWixie.Animations.CAST.ordinal()) {
            this.controller.forceAnimationReset();
            this.controller.setAnimation(RawAnimation.begin().thenPlay("cast"));
        }
    }

    @Override
    public ResourceLocation getTexture() {
        String color = this.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "blue";
        }
        return ArsNouveau.prefix("textures/entity/wixie_" + color + ".png");
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public static class DebuffTargetGoal
    extends Goal {
        FamiliarWixie wixie;
        public static ArrayList<Holder<MobEffect>> effectTable = new ArrayList<Holder>(Arrays.asList(MobEffects.MOVEMENT_SLOWDOWN, MobEffects.WEAKNESS, MobEffects.LEVITATION, MobEffects.POISON));

        public DebuffTargetGoal(FamiliarWixie wixie) {
            this.wixie = wixie;
        }

        public void tick() {
            super.tick();
            if (this.wixie.getTarget() == null) {
                return;
            }
            Holder effect = effectTable.get(new Random().nextInt(effectTable.size()));
            if (effect == MobEffects.POISON && this.wixie.getTarget().isInvertedHealAndHarm()) {
                effect = MobEffects.REGENERATION;
            }
            Networking.sendToNearbyClient(this.wixie.level, (Entity)this.wixie, (CustomPacketPayload)new PacketAnimEntity(this.wixie.getId(), EntityWixie.Animations.CAST.ordinal()));
            this.wixie.getTarget().addEffect(new MobEffectInstance(effect, 140, new Random().nextInt(2)));
            this.wixie.debuffCooldown = 150;
        }

        public boolean canUse() {
            return this.wixie.debuffCooldown <= 0 && this.wixie.getTarget() != null;
        }
    }
}

