/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.LevelEntityMap;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WhirlisprigTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.BonemealGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.FollowMobGoalBackoff;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.FollowPlayerGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig.InspectPlantGoal;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.ItemScrollData;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Whirlisprig
extends AbstractFlyingCreature
implements GeoEntity,
ITooltipProvider,
IDispellable,
ICharmSerializable {
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static LevelEntityMap WHIRLI_MAP = new LevelEntityMap();
    public int timeSinceBonemeal = 0;
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.defineId(Whirlisprig.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int tamingTime = 0;
    public boolean droppingShards;
    public static final EntityDataAccessor<Integer> MOOD_SCORE = SynchedEntityData.defineId(Whirlisprig.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(Whirlisprig.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public int diversityScore;
    public BlockPos flowerPos;
    public int timeSinceGen;
    private boolean setBehaviors;
    public static Map<String, ResourceLocation> TEXTURES = new HashMap<String, ResourceLocation>();

    private PlayState idlePredicate(AnimationState<?> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("fly"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "idleController", 1, this::idlePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getCommandSenderWorld().isClientSide) {
            return super.mobInteract(player, hand);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == ItemsRegistry.DENY_ITEM_SCROLL.asItem() && this.getTile() != null) {
            ItemScrollData scrollData = (ItemScrollData)stack.getOrDefault(DataComponentRegistry.ITEM_SCROLL_DATA, (Object)new ItemScrollData());
            this.getTile().ignoreItems.addAll(scrollData.mutable().getItems());
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.whirlisprig.ignore"));
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void fromCharmData(PersistentFamiliarData data) {
        this.setCustomName(data.name());
        this.entityData.set(COLOR, (Object)data.color());
    }

    @Override
    public String getColor() {
        return (String)this.entityData.get(COLOR);
    }

    public static String getColorFromStack(ItemStack stack) {
        if (stack.is(Tags.Items.DYES)) {
            if (stack.is(Tags.Items.DYES_GREEN)) {
                return "summer";
            }
            if (stack.is(Tags.Items.DYES_ORANGE)) {
                return "autumn";
            }
            if (stack.is(Tags.Items.DYES_YELLOW)) {
                return "spring";
            }
            if (stack.is(Tags.Items.DYES_WHITE)) {
                return "winter";
            }
        }
        return null;
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || player.getCommandSenderWorld().isClientSide || !((Boolean)this.entityData.get(TAMED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        String color = Whirlisprig.getColorFromStack(stack);
        if (color != null && !this.getColor().equals(color)) {
            this.entityData.set(COLOR, (Object)color);
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if (stack.isEmpty()) {
            int moodScore = (Integer)this.entityData.get(MOOD_SCORE);
            if (moodScore < 250) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.unhappy"));
            } else if (moodScore <= 500) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.content"));
            } else if (moodScore <= 750) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.happy"));
            } else if (moodScore < 1000) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.very_happy"));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.extremely_happy"));
            }
            int numDrops = this.diversityScore / 2;
            if (numDrops <= 5) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.okay_diversity"));
            } else if (numDrops <= 10) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.diverse_enough"));
            } else if (numDrops <= 20) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.very_diverse"));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.extremely_diverse"));
            }
            WhirlisprigTile tile = this.getTile();
            if (tile.ignoreItems != null && !tile.ignoreItems.isEmpty()) {
                StringBuilder status = new StringBuilder();
                status.append(Component.translatable((String)"ars_nouveau.whirlisprig.ignore_list").getString());
                for (ItemStack i : tile.ignoreItems) {
                    status.append(i.getHoverName().getString()).append(" ");
                }
                PortUtil.sendMessage((Entity)player, (Component)Component.literal((String)status.toString()));
            }
            return InteractionResult.SUCCESS;
        }
        if (!(stack.getItem() instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
        int score = WhirlisprigTile.getScore(state);
        if (score > 0 && this.getTile() != null && this.getTile().scoreMap != null && this.getTile().scoreMap.get(state) != null && this.getTile().scoreMap.get(state) >= 50) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.toomuch"));
            return InteractionResult.SUCCESS;
        }
        if (score == 0) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.notinterested"));
        }
        if (score == 1) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.likes"));
        }
        if (score == 2) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"whirlisprig.excited"));
        }
        return InteractionResult.SUCCESS;
    }

    public Whirlisprig(EntityType<? extends AbstractFlyingCreature> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.addGoalsAfterConstructor();
    }

    public Whirlisprig(Level world, boolean isTamed, BlockPos pos) {
        super((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), world);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.entityData.set(TAMED, (Object)isTamed);
        this.flowerPos = pos;
        this.addGoalsAfterConstructor();
    }

    public void setRemoved(Entity.RemovalReason pRemovalReason) {
        super.setRemoved(pRemovalReason);
        WHIRLI_MAP.removeEntity(this.level, this.getUUID());
    }

    public void tick() {
        super.tick();
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.level.isClientSide) {
            if (!this.isRemoved() && !this.isTamed()) {
                WHIRLI_MAP.addEntity(this.level, this.getUUID());
            }
            if (this.level.getGameTime() % 20L == 0L && this.blockPosition().getY() < this.level.getMinBuildHeight()) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            ++this.timeSinceBonemeal;
            ++this.timeSinceGen;
            if (this.level.getGameTime() % 20L == 0L && this.flowerPos != null && this.isTamed() && this.getTile() != null) {
                this.entityData.set(MOOD_SCORE, (Object)this.getTile().moodScore);
                this.diversityScore = this.getTile().diversityScore;
            }
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 60L == 0L && this.isTamed() && this.flowerPos != null && !(this.level.getBlockEntity(this.flowerPos) instanceof WhirlisprigTile)) {
            this.hurt(this.level.damageSources().playerAttack((Player)ANFakePlayer.getPlayer((ServerLevel)this.level)), 99.0f);
            return;
        }
        if (this.droppingShards) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.level.isClientSide()) {
                Networking.sendToNearbyClient(this.level, (Entity)this, (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.blockPosition(), ParticleColor.GREEN, new int[0]));
            }
            if (this.tamingTime > 60 && !this.level.isClientSide) {
                ItemStack stack = new ItemStack(ItemsRegistry.WHIRLISPRIG_SHARDS, 1 + this.level.random.nextInt(1));
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY() + 0.5, this.getZ(), stack));
                this.remove(Entity.RemovalReason.DISCARDED);
                this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.tamingTime > 55 && this.level.isClientSide) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.getX();
                    double d1 = this.getY() + 0.1;
                    double d2 = this.getZ();
                    this.level.addParticle((ParticleOptions)ParticleTypes.END_ROD, d0, d1, d2, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    protected void addGoalsAfterConstructor() {
        if (this.level.isClientSide()) {
            return;
        }
        for (WrappedGoal goal : this.getGoals()) {
            this.goalSelector.addGoal(goal.getPriority(), goal.getGoal());
        }
    }

    public List<WrappedGoal> getGoals() {
        return (Boolean)this.entityData.get(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    public boolean isTamed() {
        return (Boolean)this.entityData.get(TAMED);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage(pSource) && super.hurt(pSource, pAmount);
    }

    public void die(DamageSource source) {
        if (!this.level.isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack(ItemsRegistry.WHIRLISPRIG_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
        }
        super.die(source);
    }

    public List<WrappedGoal> getTamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new BonemealGoal(this, () -> this.flowerPos, 10)));
        list.add(new WrappedGoal(2, (Goal)new InspectPlantGoal(this, () -> this.flowerPos, 15)));
        list.add(new WrappedGoal(1, (Goal)new GoBackHomeGoal((Mob)this, () -> this.flowerPos, 20)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        return list;
    }

    public List<WrappedGoal> getUntamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(3, (Goal)new FollowMobGoalBackoff((Mob)this, 1.0, 3.0f, 7.0f, 0.5f)));
        list.add(new WrappedGoal(5, (Goal)new FollowPlayerGoal((Mob)this, 1.0, 3.0f, 7.0f)));
        list.add(new WrappedGoal(2, (Goal)new RandomLookAroundGoal((Mob)this)));
        list.add(new WrappedGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0)));
        list.add(new WrappedGoal(1, (Goal)new BonemealGoal(this)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        return list;
    }

    public WhirlisprigTile getTile() {
        if (this.flowerPos == null || !(this.level.getBlockEntity(this.flowerPos) instanceof WhirlisprigTile)) {
            return null;
        }
        return (WhirlisprigTile)this.level.getBlockEntity(this.flowerPos);
    }

    protected void registerGoals() {
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (!((Boolean)this.entityData.get(TAMED)).booleanValue()) {
            return;
        }
        int mood = (Integer)this.entityData.get(MOOD_SCORE);
        String moodStr = Component.translatable((String)"ars_nouveau.whirlisprig.tooltip_unhappy").getString();
        if (mood >= 1000) {
            moodStr = Component.translatable((String)"ars_nouveau.whirlisprig.tooltip_extremely_happy").getString();
        } else if (mood >= 750) {
            moodStr = Component.translatable((String)"ars_nouveau.whirlisprig.tooltip_very_happy").getString();
        } else if (mood >= 500) {
            moodStr = Component.translatable((String)"ars_nouveau.whirlisprig.tooltip_happy").getString();
        } else if (mood >= 250) {
            moodStr = Component.translatable((String)"ars_nouveau.whirlisprig.tooltip_content").getString();
        }
        tooltip.add((Component)Component.literal((String)(Component.translatable((String)"ars_nouveau.whirlisprig.tooltip_mood").getString() + moodStr)));
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.FLYING_SPEED, ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue()).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    @NotNull
    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("summoner_x")) {
            this.flowerPos = new BlockPos(tag.getInt("summoner_x"), tag.getInt("summoner_y"), tag.getInt("summoner_z"));
        }
        this.timeSinceBonemeal = tag.getInt("bonemeal");
        this.entityData.set(TAMED, (Object)tag.getBoolean("tamed"));
        this.entityData.set(MOOD_SCORE, (Object)tag.getInt("score"));
        if (!this.setBehaviors) {
            this.tryResetGoals();
            this.setBehaviors = true;
        }
        this.entityData.set(COLOR, (Object)tag.getString("color"));
        this.timeSinceGen = tag.getInt("genTime");
    }

    public void tryResetGoals() {
        this.goalSelector.availableGoals = new LinkedHashSet();
        this.addGoalsAfterConstructor();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.flowerPos != null) {
            tag.putInt("summoner_x", this.flowerPos.getX());
            tag.putInt("summoner_y", this.flowerPos.getY());
            tag.putInt("summoner_z", this.flowerPos.getZ());
        }
        tag.putInt("bonemeal", this.timeSinceBonemeal);
        tag.putBoolean("tamed", ((Boolean)this.entityData.get(TAMED)).booleanValue());
        tag.putInt("score", ((Integer)this.entityData.get(MOOD_SCORE)).intValue());
        if (this.entityData.get(COLOR) != null) {
            tag.putString("color", (String)this.entityData.get(COLOR));
        }
        tag.putInt("genTime", this.timeSinceGen);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(MOOD_SCORE, (Object)0);
        pBuilder.define(TAMED, (Object)false);
        pBuilder.define(COLOR, (Object)"summer");
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack(ItemsRegistry.WHIRLISPRIG_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    public ResourceLocation getTexture() {
        String color = this.getColor();
        if (color.isEmpty()) {
            color = "summer";
        }
        String finalColor = color;
        return TEXTURES.computeIfAbsent(color, key -> ArsNouveau.prefix("textures/entity/whirlisprig_" + finalColor + ".png"));
    }
}

